/*
 * Copyright (c) 2008-2012, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.monitor;

public interface LocalLockOperationStats extends LocalInstanceOperationStats {
    /**
     * Returns the number of lock operations.
     *
     * @return number of lock operations
     */
    public long getNumberOfLocks();

    /**
     * Returns the number of unlock operations.
     *
     * @return number of unlock operations
     */
    public long getNumberOfUnlocks();

    /**
     * Returns the number of failed lock operations.
     *
     * @return number of failed lock operations
     */
    public long getNumberOfFailedLocks();

    /**
     * Returns the number of total operations.
     *
     * @return number of total operations
     */
    public long total();
}
