/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.BlockingQueueManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.HazelcastInstanceAwareInstance;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.impl.monitor.QueueOperationsCounter;
import com.hazelcast.monitor.LocalQueueOperationStats;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class QProxyImpl
extends AbstractQueue
implements QProxy,
HazelcastInstanceAwareInstance,
DataSerializable {
    private transient QProxy qproxyReal = null;
    private transient FactoryImpl factory = null;
    private String name = null;
    private BlockingQueueManager blockingQueueManager = null;
    private ListenerManager listenerManager = null;

    public QProxyImpl() {
    }

    QProxyImpl(String name, FactoryImpl factory) {
        this.name = name;
        this.qproxyReal = new QProxyReal();
        this.setHazelcastInstance(factory);
    }

    public FactoryImpl getFactory() {
        return this.factory;
    }

    @Override
    public String getLongName() {
        this.ensure();
        return this.qproxyReal.getLongName();
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
        this.blockingQueueManager = this.factory.node.blockingQueueManager;
        this.listenerManager = this.factory.node.listenerManager;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.qproxyReal == null) {
            this.qproxyReal = (QProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    @Override
    public Object getId() {
        this.ensure();
        return this.qproxyReal.getId();
    }

    @Override
    public String toString() {
        return "Queue [" + this.getName() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QProxyImpl qProxy = (QProxyImpl)o;
        return !(this.name != null ? !this.name.equals(qProxy.name) : qProxy.name != null);
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeData(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readData(in);
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        this.ensure();
        return this.qproxyReal.getLocalQueueStats();
    }

    @Override
    public Iterator iterator() {
        this.ensure();
        return this.qproxyReal.iterator();
    }

    @Override
    public int size() {
        this.ensure();
        return this.qproxyReal.size();
    }

    @Override
    public void addItemListener(ItemListener listener, boolean includeValue) {
        this.ensure();
        this.qproxyReal.addItemListener(listener, includeValue);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.ensure();
        this.qproxyReal.removeItemListener(listener);
    }

    @Override
    public String getName() {
        return this.name.substring("q:".length());
    }

    @Override
    public int drainTo(Collection c) {
        this.ensure();
        return this.qproxyReal.drainTo(c);
    }

    @Override
    public int drainTo(Collection c, int maxElements) {
        this.ensure();
        return this.qproxyReal.drainTo(c, maxElements);
    }

    @Override
    public void destroy() {
        this.ensure();
        this.qproxyReal.destroy();
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.qproxyReal.getInstanceType();
    }

    @Override
    public boolean offer(Object o) {
        this.ensure();
        return this.qproxyReal.offer(o);
    }

    @Override
    public boolean offer(Object obj, long timeout, TimeUnit unit) throws InterruptedException {
        this.ensure();
        return this.qproxyReal.offer(obj, timeout, unit);
    }

    @Override
    public void put(Object obj) throws InterruptedException {
        this.ensure();
        this.qproxyReal.put(obj);
    }

    @Override
    public Object poll() {
        this.ensure();
        return this.qproxyReal.poll();
    }

    @Override
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.ensure();
        return this.qproxyReal.poll(timeout, unit);
    }

    @Override
    public Object take() throws InterruptedException {
        this.ensure();
        return this.qproxyReal.take();
    }

    @Override
    public int remainingCapacity() {
        this.ensure();
        return this.qproxyReal.remainingCapacity();
    }

    @Override
    public Object peek() {
        this.ensure();
        return this.qproxyReal.peek();
    }

    @Override
    public QueueOperationsCounter getQueueOperationCounter() {
        return this.qproxyReal.getQueueOperationCounter();
    }

    private static void check(Object obj) {
        Util.checkSerializable(obj);
    }

    private class QProxyReal
    extends AbstractQueue
    implements QProxy {
        private final QueueOperationsCounter operationsCounter = new QueueOperationsCounter();

        @Override
        public LocalQueueStats getLocalQueueStats() {
            this.operationsCounter.incrementOtherOperations();
            LocalQueueStatsImpl localQueueStats = QProxyImpl.this.blockingQueueManager.getOrCreateBQ(QProxyImpl.this.name).getQueueStats();
            localQueueStats.setOperationStats((LocalQueueOperationStats)this.operationsCounter.getPublishedStats());
            return localQueueStats;
        }

        @Override
        public String getLongName() {
            return QProxyImpl.this.name;
        }

        @Override
        public boolean offer(Object obj) {
            QProxyImpl.check(obj);
            try {
                return this.offer(obj, 0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                return false;
            }
        }

        @Override
        public boolean offer(Object obj, long timeout, TimeUnit unit) throws InterruptedException {
            boolean result;
            QProxyImpl.check(obj);
            if (timeout < 0L) {
                timeout = 0L;
            }
            if (!(result = QProxyImpl.this.blockingQueueManager.offer(QProxyImpl.this.name, obj, unit.toMillis(timeout)))) {
                this.operationsCounter.incrementRejectedOffers();
            }
            this.operationsCounter.incrementOffers();
            return result;
        }

        @Override
        public void put(Object obj) throws InterruptedException {
            QProxyImpl.check(obj);
            QProxyImpl.this.blockingQueueManager.offer(QProxyImpl.this.name, obj, -1L);
            this.operationsCounter.incrementOffers();
        }

        @Override
        public Object peek() {
            this.operationsCounter.incrementOtherOperations();
            return QProxyImpl.this.blockingQueueManager.peek(QProxyImpl.this.name);
        }

        @Override
        public Object poll() {
            try {
                Object result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, 0L);
                if (result == null) {
                    this.operationsCounter.incrementEmptyPolls();
                }
                this.operationsCounter.incrementPolls();
                return result;
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        @Override
        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            Object result;
            if (timeout < 0L) {
                timeout = 0L;
            }
            if ((result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, unit.toMillis(timeout))) == null) {
                this.operationsCounter.incrementEmptyPolls();
            }
            this.operationsCounter.incrementPolls();
            return result;
        }

        @Override
        public Object take() throws InterruptedException {
            Object result = QProxyImpl.this.blockingQueueManager.poll(QProxyImpl.this.name, -1L);
            if (result == null) {
                this.operationsCounter.incrementEmptyPolls();
            }
            this.operationsCounter.incrementPolls();
            return result;
        }

        @Override
        public int remainingCapacity() {
            this.operationsCounter.incrementOtherOperations();
            BlockingQueueManager.BQ q = QProxyImpl.this.blockingQueueManager.getOrCreateBQ(QProxyImpl.this.name);
            int maxSizePerJVM = q.getMaxSizePerJVM();
            if (maxSizePerJVM <= 0) {
                return Integer.MAX_VALUE;
            }
            int size = this.size();
            int numberOfMembers = ((QProxyImpl)QProxyImpl.this).factory.node.getClusterImpl().getMembers().size();
            int totalCapacity = numberOfMembers * maxSizePerJVM;
            return totalCapacity - size;
        }

        @Override
        public Iterator iterator() {
            this.operationsCounter.incrementOtherOperations();
            return QProxyImpl.this.blockingQueueManager.iterate(QProxyImpl.this.name);
        }

        @Override
        public int size() {
            this.operationsCounter.incrementOtherOperations();
            return QProxyImpl.this.blockingQueueManager.size(QProxyImpl.this.name);
        }

        @Override
        public void addItemListener(ItemListener listener, boolean includeValue) {
            QProxyImpl.this.blockingQueueManager.addItemListener(QProxyImpl.this.name, listener, includeValue);
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            QProxyImpl.this.blockingQueueManager.removeItemListener(QProxyImpl.this.name, listener);
        }

        @Override
        public String getName() {
            return QProxyImpl.this.getName();
        }

        @Override
        public boolean remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int drainTo(Collection c) {
            return this.drainTo(c, Integer.MAX_VALUE);
        }

        @Override
        public int drainTo(Collection c, int maxElements) {
            QProxy q;
            if (c == null) {
                throw new NullPointerException("drainTo null!");
            }
            if (maxElements < 0) {
                throw new IllegalArgumentException("Negative maxElements:" + maxElements);
            }
            if (maxElements == 0) {
                return 0;
            }
            if (c instanceof QProxy && (q = (QProxy)c).getName().equals(this.getName())) {
                throw new IllegalArgumentException("Cannot drainTo self!");
            }
            this.operationsCounter.incrementOtherOperations();
            int added = 0;
            Object value = null;
            do {
                if ((value = this.poll()) == null) continue;
                if (!c.add(value)) {
                    throw new RuntimeException("drainTo is not able to add!");
                }
                ++added;
            } while (added < maxElements && value != null);
            return added;
        }

        @Override
        public void destroy() {
            this.operationsCounter.incrementOtherOperations();
            QProxyImpl.this.factory.destroyInstanceClusterWide(QProxyImpl.this.name, null);
            QProxyImpl.this.factory.destroyInstanceClusterWide("c:" + QProxyImpl.this.name, null);
        }

        @Override
        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.QUEUE;
        }

        @Override
        public Object getId() {
            return QProxyImpl.this.name;
        }

        @Override
        public QueueOperationsCounter getQueueOperationCounter() {
            return this.operationsCounter;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

