/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedHashMap;

public class ClusterPropsRequest
implements ConsoleRequest {
    @Override
    public int getType() {
        return 9;
    }

    @Override
    public Object readResponse(DataInput in) throws IOException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String[] temp = in.readUTF().split(":#");
            properties.put(temp[0], temp.length == 1 ? "" : temp[1]);
            ++i;
        }
        return properties;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        PartitionManager partitionManager = mcs.getHazelcastInstance().node.concurrentMapManager.getPartitionManager();
        properties.put("hazelcast.cl_version", mcs.getHazelcastInstance().node.initializer.getVersion());
        properties.put("date.cl_startTime", Long.toString(runtimeMxBean.getStartTime()));
        properties.put("seconds.cl_upTime", Long.toString(runtimeMxBean.getUptime()));
        properties.put("memory.cl_freeMemory", Long.toString(runtime.freeMemory()));
        properties.put("memory.cl_totalMemory", Long.toString(runtime.totalMemory()));
        properties.put("memory.cl_maxMemory", Long.toString(runtime.maxMemory()));
        properties.put("data.cl_immediateTasksCount", Long.toString(partitionManager.getImmediateTasksCount()));
        properties.put("data.cl_scheduledTasksCount", Long.toString(partitionManager.getScheduledTasksCount()));
        dos.writeInt(properties.size());
        for (Object property : properties.keySet()) {
            dos.writeUTF(String.valueOf((String)property) + ":#" + (String)properties.get(property));
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
    }

    @Override
    public void readData(DataInput in) throws IOException {
    }
}

