/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WcsException
extends Exception {
    private Code code;
    private String locator;
    private List<String> textMessages;

    public WcsException() {
        this.code = Code.UNKNOWN;
        this.locator = null;
        this.textMessages = Collections.emptyList();
    }

    public WcsException(String message) {
        super(message);
        this.code = Code.UNKNOWN;
        this.locator = null;
        this.textMessages = Collections.singletonList(message);
    }

    public WcsException(String message, Throwable cause) {
        super(message, cause);
        this.code = Code.UNKNOWN;
        this.locator = null;
        this.textMessages = Collections.singletonList(message);
    }

    public WcsException(Throwable cause) {
        super(cause);
        this.code = Code.UNKNOWN;
        this.locator = null;
        this.textMessages = Collections.singletonList(cause.getMessage());
    }

    public WcsException(Code code, String locator, List<String> messages) {
        super(messages.get(0));
        this.code = code;
        this.locator = locator;
        this.textMessages = new ArrayList<String>(messages);
    }

    public WcsException(Code code, String locator, String message) {
        super(message);
        this.code = code;
        this.locator = locator;
        this.textMessages = Collections.singletonList(message);
    }

    public Code getCode() {
        return this.code;
    }

    public String getLocator() {
        return this.locator;
    }

    public List<String> getTextMessages() {
        return Collections.unmodifiableList(this.textMessages);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        UNKNOWN,
        InvalidFormat,
        CoverageNotDefined,
        CurrentUpdateSequence,
        InvalidUpdateSequence,
        MissingParameterValue,
        InvalidParameterValue;

    }
}

