/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.testapp.model;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.javasimon.testapp.model.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleDAO {
    private Connection conn;
    private String table;

    public TupleDAO(Connection connection, String tableName) {
        this.conn = connection;
        this.table = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Tuple t) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement("insert into " + this.table + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.populateStatement(stmt, t);
            stmt.executeUpdate();
            stmt.getConnection().commit();
            this.closeStatement(stmt);
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(List<Tuple> list) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement("insert into " + this.table + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (Tuple t : list) {
                this.populateStatement(stmt, t);
                stmt.addBatch();
            }
            stmt.executeBatch();
            stmt.getConnection().commit();
            this.closeStatement(stmt);
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(int unique1) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement("update " + this.table + " set string4 = 'UPDATED' where unique1 = ?");
            stmt.setInt(1, unique1);
            int res = stmt.executeUpdate();
            stmt.getConnection().commit();
            int n = res;
            this.closeStatement(stmt);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByUnique1(int unique1) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement("delete from " + this.table + " where unique1 = ?");
            stmt.setInt(1, unique1);
            int res = stmt.executeUpdate();
            stmt.getConnection().commit();
            int n = res;
            this.closeStatement(stmt);
            return n;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
    }

    private void populateStatement(PreparedStatement s, Tuple t) throws SQLException {
        int j = 0;
        s.setInt(++j, t.getUnique1());
        s.setInt(++j, t.getIdx());
        s.setInt(++j, t.getOne());
        s.setInt(++j, t.getTen());
        s.setInt(++j, t.getTwenty());
        s.setInt(++j, t.getTwentyFive());
        s.setInt(++j, t.getFifty());
        s.setInt(++j, t.getEvenOnePercent());
        s.setInt(++j, t.getOddOnePercent());
        s.setString(++j, t.getStringU1());
        s.setString(++j, t.getStringU2());
        s.setString(++j, t.getString4());
        s.setDate(++j, new Date(t.getCreated()));
    }

    private void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

