/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.text;

import java.util.Arrays;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.text.TextStyle;

public class ParagraphStyle
extends TextStyle {
    public static final String STYLE_FAMILY = "paragraph";
    public static final StyleDesc<ParagraphStyle> DESC = new StyleDesc<ParagraphStyle>(ParagraphStyle.class, XMLVersion.OD, "paragraph", "P"){
        {
            this.getRefElementsMap().putAll((Object)"text:style-name", Arrays.asList("text:alphabetical-index-entry-template", "text:bibliography-entry-template", "text:h", "text:p", "text:illustration-index-entry-template", "text:index-source-style", "text:object-index-entry-template", "text:table-index-entry-template", "text:table-of-content-entry-template", "text:user-index-entry-template"));
            this.getRefElementsMap().putAll((Object)"draw:text-style-name", Arrays.asList("draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:custom-shape", "draw:ellipse", "draw:frame", "draw:line", "draw:measure", "draw:path", "draw:polygon", "draw:polyline", "draw:rect", "draw:regular-polygon", "office:annotation"));
        }

        @Override
        public ParagraphStyle create(ODPackage oDPackage, Element element) {
            return new ParagraphStyle(oDPackage, element);
        }
    };
    private SyleParagraphProperties pProps = null;

    public ParagraphStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final SyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new SyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public final String getAlignment() {
        return this.getParagraphProperties().getAlignment();
    }

    public static class SyleParagraphProperties
    extends StyleProperties {
        public SyleParagraphProperties(StyleStyle styleStyle) {
            super(styleStyle, ParagraphStyle.STYLE_FAMILY);
        }

        public final String getAlignment() {
            return this.getElement().getAttributeValue("text-align", this.getNS("fo"));
        }
    }
}

