/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import javax.swing.table.AbstractTableModel;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Table;

public class SheetTableModel<D extends ODDocument>
extends AbstractTableModel {
    protected final Table<D> table;
    protected final int row;
    protected final int column;
    protected final int lastRow;
    protected final int lastCol;

    SheetTableModel(Table<D> table, int n, int n2) {
        this(table, n, n2, table.getRowCount(), table.getColumnCount());
    }

    SheetTableModel(Table<D> table, int n, int n2, int n3, int n4) {
        this.table = table;
        this.row = n;
        this.column = n2;
        this.lastRow = n3;
        this.lastCol = n4;
    }

    @Override
    public int getColumnCount() {
        return this.lastCol - this.column;
    }

    @Override
    public int getRowCount() {
        return this.lastRow - this.row;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        this.check(n, n2);
        return this.table.getValueAt(this.column + n2, this.row + n);
    }

    public Cell<D> getImmutableCellAt(int n, int n2) {
        this.check(n, n2);
        return this.table.getImmutableCellAt(this.column + n2, this.row + n);
    }

    protected final void check(int n, int n2) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("row :" + n + " not between 0 and " + (this.getRowCount() - 1));
        }
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException("column: " + n2 + " not between 0 and " + (this.getColumnCount() - 1));
        }
    }

    public static final class MutableTableModel<D extends ODDocument>
    extends SheetTableModel<D> {
        MutableTableModel(Table<D> table, int n, int n2) {
            super(table, n, n2);
        }

        MutableTableModel(Table<D> table, int n, int n2, int n3, int n4) {
            super(table, n, n2, n3, n4);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.check(n, n2);
            this.table.setValueAt(object, this.column + n2, this.row + n);
        }

        public MutableCell<D> getCellAt(int n, int n2) {
            this.check(n, n2);
            return this.table.getCellAt(this.column + n2, this.row + n);
        }
    }
}

