/*
 * Decompiled with CFR 0.152.
 */
package de.rtner.security.auth.spi;

import de.rtner.misc.BinTools;
import de.rtner.security.auth.spi.PBKDF2Formatter;
import de.rtner.security.auth.spi.PBKDF2Parameters;

public class PBKDF2HexFormatter
implements PBKDF2Formatter {
    public boolean fromString(PBKDF2Parameters pBKDF2Parameters, String string) {
        if (pBKDF2Parameters == null || string == null) {
            return true;
        }
        String[] stringArray = string.split(":");
        if (stringArray == null || stringArray.length != 3) {
            return true;
        }
        byte[] byArray = BinTools.hex2bin(stringArray[0]);
        int n = Integer.parseInt(stringArray[1]);
        byte[] byArray2 = BinTools.hex2bin(stringArray[2]);
        pBKDF2Parameters.setSalt(byArray);
        pBKDF2Parameters.setIterationCount(n);
        pBKDF2Parameters.setDerivedKey(byArray2);
        return false;
    }

    public String toString(PBKDF2Parameters pBKDF2Parameters) {
        String string = BinTools.bin2hex(pBKDF2Parameters.getSalt()) + ":" + String.valueOf(pBKDF2Parameters.getIterationCount()) + ":" + BinTools.bin2hex(pBKDF2Parameters.getDerivedKey());
        return string;
    }
}

