/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.parameter.Value;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DateList
implements List,
Serializable {
    private static final long serialVersionUID = -3700862452550012357L;
    private final Value type;
    private final List dates;
    private TimeZone timeZone;
    private boolean utc;

    public DateList() {
        this(false);
    }

    public DateList(boolean unmodifiable) {
        this.type = Value.DATE_TIME;
        this.dates = unmodifiable ? Collections.EMPTY_LIST : new ArrayList();
    }

    public DateList(Value aType) {
        this(aType, null);
    }

    public DateList(Value aType, TimeZone timezone) {
        this.type = aType == null ? Value.DATE_TIME : aType;
        this.timeZone = timezone;
        this.dates = new ArrayList();
    }

    public DateList(String aValue, Value aType) throws ParseException {
        this(aValue, aType, null);
    }

    public DateList(String aValue, Value aType, TimeZone timezone) throws ParseException {
        this(aType, timezone);
        StringTokenizer t = new StringTokenizer(aValue, ",");
        while (t.hasMoreTokens()) {
            if (Value.DATE.equals(this.type)) {
                this.add((Object)new Date(t.nextToken()));
                continue;
            }
            this.add((Object)new DateTime(t.nextToken(), timezone));
        }
    }

    public DateList(DateList list, Value type) {
        if (!Value.DATE.equals(type) && !Value.DATE_TIME.equals(type)) {
            throw new IllegalArgumentException("Type must be either DATE or DATE-TIME");
        }
        this.type = type;
        this.dates = new ArrayList();
        if (Value.DATE.equals(type)) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.add(new Date((Date)i.next()));
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.add(new DateTime((Date)i.next()));
            }
        }
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            b.append(i.next());
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }

    public final boolean add(Date date) {
        if (date instanceof DateTime) {
            if (this.isUtc()) {
                ((DateTime)date).setUtc(true);
            } else {
                ((DateTime)date).setTimeZone(this.getTimeZone());
            }
        } else if (!Value.DATE.equals(this.getType())) {
            DateTime dateTime = new DateTime(date);
            dateTime.setTimeZone(this.getTimeZone());
            return this.add((Object)dateTime);
        }
        return this.add((Object)date);
    }

    public final boolean add(Object date) {
        if (!(date instanceof Date)) {
            throw new IllegalArgumentException("Argument not a " + Date.class.getName());
        }
        return this.dates.add(date);
    }

    public final boolean remove(Date date) {
        return this.remove((Object)date);
    }

    public final Value getType() {
        return this.type;
    }

    public final boolean isUtc() {
        return this.utc;
    }

    public final void setUtc(boolean utc) {
        if (!Value.DATE.equals(this.type)) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((DateTime)i.next()).setUtc(utc);
            }
        }
        this.timeZone = null;
        this.utc = utc;
    }

    public final void setTimeZone(TimeZone timeZone) {
        if (!Value.DATE.equals(this.type)) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((DateTime)i.next()).setTimeZone(timeZone);
            }
        }
        this.timeZone = timeZone;
        this.utc = false;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public final void add(int arg0, Object arg1) {
        this.dates.add(arg0, arg1);
    }

    public final boolean addAll(Collection arg0) {
        return this.dates.addAll(arg0);
    }

    public final boolean addAll(int arg0, Collection arg1) {
        return this.dates.addAll(arg0, arg1);
    }

    public final void clear() {
        this.dates.clear();
    }

    public final boolean contains(Object o) {
        return this.dates.contains(o);
    }

    public final boolean containsAll(Collection arg0) {
        return this.dates.containsAll(arg0);
    }

    public final Object get(int index) {
        return this.dates.get(index);
    }

    public final int indexOf(Object o) {
        return this.dates.indexOf(o);
    }

    public final boolean isEmpty() {
        return this.dates.isEmpty();
    }

    public final Iterator iterator() {
        return this.dates.iterator();
    }

    public final int lastIndexOf(Object o) {
        return this.dates.lastIndexOf(o);
    }

    public final ListIterator listIterator() {
        return this.dates.listIterator();
    }

    public final ListIterator listIterator(int index) {
        return this.dates.listIterator(index);
    }

    public final Object remove(int index) {
        return this.dates.remove(index);
    }

    public final boolean remove(Object o) {
        return this.dates.remove(o);
    }

    public final boolean removeAll(Collection arg0) {
        return this.dates.removeAll(arg0);
    }

    public final boolean retainAll(Collection arg0) {
        return this.dates.retainAll(arg0);
    }

    public final Object set(int arg0, Object arg1) {
        return this.dates.set(arg0, arg1);
    }

    public final int size() {
        return this.dates.size();
    }

    public final List subList(int fromIndex, int toIndex) {
        return this.dates.subList(fromIndex, toIndex);
    }

    public final Object[] toArray() {
        return this.dates.toArray();
    }

    public final Object[] toArray(Object[] arg0) {
        return this.dates.toArray(arg0);
    }

    public final boolean equals(Object obj) {
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        DateList rhs = (DateList)obj;
        return new EqualsBuilder().append((Object)this.dates, (Object)rhs.dates).append((Object)this.type, (Object)rhs.type).append((Object)this.timeZone, (Object)rhs.timeZone).append(this.utc, this.utc).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.dates).append((Object)this.type).append((Object)this.timeZone).append(this.utc).toHashCode();
    }
}

