/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <Viktor.Pracht@open-xchange.org>
 * 
 */

var temporary = { lists: {} };

temporary.MakeList = function(list) {
    if (!list.addIcon) {
        list.addIcon = temporary.MakeList.addIcon;
    }
    if (!list.addColumn) {
        list.addColumn = function(column) {
            this.columns.push(column);
            this.updated();
        };
    }
    return list;
};

temporary.MakeList.addIcon = function(icon) {
    this.columns.splice(0, 0, {
        text: "&#x00a0;",
        name: icon.name,
        width: icon.width,
        style: { padding: 0, textAlign: "center" },
        set: function(div, data) {
            var src;
            if (icon.isVisible(data)) {
                src = icon.getIcon(data);
                src = src.charAt(0) == "/" ? urlify(src.substring(1))
                                           : getFullImgSrc(src); 
            } else {
                src = getFullImgSrc("img/dummy.gif");
            }
            if (!div.firstChild) {
                div.appendChild(newnode("img", 0, { src: src }));
            } else {
                if (div.firstChild.src != src) {
                    div.firstChild.src = src;
                }
            }
        },
        clear: function(div) {
            var src = getFullImgSrc("img/dummy.gif");
            if (!div.firstChild) {
                div.appendChild(newnode("img", 0, { src: src }));
            } else {
                if (div.firstChild.src != src) {
                    div.firstChild.src = src;
                }
            }
        }
    });
    this.updated();
};

temporary.services = {
    services: {},
    init: function(name) {
        var service = this.services[name];
        if (!service) {
            service = this.services[name] = { providers: [], consumers: [] };
        }
        return service;
    },
    provide: function(name, service) {
        this.init(name).providers.push(service);
    },
    consume: function(name, callback) {
        this.init(name).consumers.push(callback);
    },
    finish: function() {
        for (var i in this.services) {
            var service = this.services[i];
            for (var j = 0; j < service.consumers.length; j++) {
                try {
                    service.consumers[j](service.providers);
                } catch (e) {
                    if (window.console && console.exception) {
                        console.exception(e);
                    }
                }
            }
        }
    },
    getProviders: function(name) { return this.init(name).providers; }
};

temporary.Tabs = function() {
    ox.UI.Widget.call(this);
    this.labelParent = $("tabPanelsFDProps");
    this.tabParent = $("tabcontentsFDProps");
    this.tabs = [];
    var Self = this;
    
    registerView("configuration/folder",
        function() {            
            // sync'ed?
            Self.folder = ox.api.folder.get({ folder: activefolder });
            
            if (!Self.initialized) {
                if (Self.init) {
                    Self.init();
                }
                Self.addContent();
            }
            // done.
            if (Self.afterInit) {
                Self.afterInit();
            }
        },
        function() { Self.enter(); },
        function() { Self.leave(); },
        null,
        function(newfolder) {
            var tab = Number(currentpath2[2]) == currentpath2[2];
            $("tab_props3").style.display = tab ? "" : "none";
            if (!Self.folder || activefolder != Self.folder.id) {
                Self.leave();
                Self.folder = ox.api.folder.get({ folder: activefolder });
                Self.enter();
            }
        }
    );
};

temporary.Tabs.prototype = extend(ox.UI.Widget, {
    addContent: function() {
        var Self = this;
        ox.UI.Widget.prototype.addContent.call(this);
        for (var i = 0; i < this.tabs.length; i++) {
            this.realizeTab(this.tabs[i]);
        }
    },
    
    addTab: function(tab) {
        this.tabs.push(tab);
        tab.setParent(this);
        tab.setViewID("configuration/folder/" + this.tabs.length);
        if (this.initialized) {
            this.realizeTab(tab);
        }
    },
    
    labelClass: "tabPanel tabPanelColors font-color-disabled background-color-additional-content border-color-design font-weight-default",

    activeLabelClass: "tabPanelHi tabPanelHiColor background-color-content font-style-lable border-color-content-default",
    
    realizeTab: function(tab) {
        tab.labelNode = newnode("div", 0, { className: this.labelClass }, [
            newnode("span", 0, { className: "folderpropertiesTab" },
                [document.createTextNode("\xa0")]),
            newnode("span", 0, 0, [
                (tab.label instanceof I18nString) ||
                typeof(tab.label) == "function" ||
                typeof(tab.label) == "string"
                    ? addTranslated(tab.label) : tab.label
            ])
        ]);
        var Self = this;
        this.labelParent.insertBefore(tab.labelNode,
                                      $("temporary.folderTabs.cleaner"));
        registerView(tab.viewID, null, function() {
            ox.Configuration.View.current = tab;
            tab.labelNode.className = Self.activeLabelClass;
            $("tab_props3").appendChild(tab.content);
            temporary.configuration.showToolbar(tab.toolbar);
            tab.enter();
        }, function() {
            tab.leave();
            $("tab_props3").removeChild(tab.content);
            tab.labelNode.className = Self.labelClass;
            ox.Configuration.View.current = null;
        }, null, function() {
            tab.leave();
            tab.enter();
        });
        addDOMEvent(tab.labelNode, "click", function(e) {
            Self.current = tab;
            changeTab("tab_props3", "");
            triggerEvent("OX_Switch_View", tab.viewID);
        });
        if (tab.init) tab.init();
        if (!tab.toolbar) {
            tab.toolbar = temporary.configuration.newToolbar(tab.title,
                [temporary.configuration.saveButton]);
        }
        ox.widgets.toolBar.views[tab.viewID] = tab.toolbar;
        changeDisplay.update(tab.viewID);
        tab.addContent();
    },
    
    showTab: function(tab) {
        this.current = tab;
        changeTab("tab_props3", "");
        triggerEvent("OX_Switch_View", tab.viewID);
    },

    enter: function() {},
    
    leave: function() {},

    saveView: function(callback) { 
        if (this.current) {
            this.current.saveView(callback);
        } else {
            if (callback) {
                callback();
            }
        }
    },
    
    cancelView: function() { this.current.cancelView(); },
    
    viewModified: function() {
        for (var i = 0; i < this.tabs.length; i++) {
            if (this.tabs[i].viewModified()) {
                return true;
            }
        }
        return false;
    }
    
});

temporary.Tab = function(title, label) {
    this.title = title;
    this.label = label;
    ox.UI.Container.apply(this);
};

temporary.Tab.prototype = extend(ox.Configuration.Page, {
    applyVisible: function() {
        this.labelNode.style.display = this.isVisible ? "" : "none";
    },
    setViewID: function(viewID) { this.viewID = viewID; }
});

temporary.VTab = function(title, label, size) {
    this.title = title;
    this.label = label;
    this.size = size;
    ox.UI.Container.call(this);
};

temporary.VTab.prototype = extend(ox.Configuration.VSplit, {
    applyVisible: temporary.Tab.prototype.applyVisible,
    setViewID: temporary.Tab.prototype.setViewID
});


temporary.MailFolderSelection = function(label, findRoot) {
    ox.UI.Widget.apply(this);
    this.label = label;
    this.findRoot = findRoot;
};

temporary.MailFolderSelection.prototype = extend(ox.UI.Widget,
    {
    
    drawMyNode: function() {
         var Self = this;
         this.input = newnode("div",
             { height: "1.25em", overflow: "hidden", whiteSpace: "nowrap" },
             { className: "font-color-default background-color-content " +
                          "smallpopupborder border-color-design" },
             [document.createTextNode("")]);
         
         var justOpened = false;
         addDOMEvent(this.input, "click", function(e) {
             if (Self.folderpopup.style.display == "none") {
                 removeChildNodes(Self.folderpopup);
                 if (!Self.enabled || !Self.isEnabled) {
                     return;
                 }
                 
                 // select folder
                 var opt = {
                     type: "mail",
                     callback: function(data) {
                         Self.set(data.id);
                         Self.folderpopup.style.display = "none";
                     },
                     node: Self.folderpopup
                 };
                 // change root folder?
                 if (ox.util.isFunction(Self.findRoot)) {
                     opt.root = Self.findRoot.call(Self);
                 }
                 // open select dialog
                 ox.api.ui.selectFolder(opt);
                 
                 Self.folderpopup.style.display = "block";
                 justOpened = true;
                 addDOMEvent(body, "click", bodyClick);
             }
         });
         function bodyClick() {
             if (justOpened) {
                 justOpened = false;
                 return;
             }
             removeChildNodes(Self.folderpopup);
             Self.folderpopup.style.display = "none";
             removeDOMEvent(body, "click", bodyClick);
         }
         this.folderpopup = newnode("div",
             { position: "absolute", display: "none", zIndex: 21,
               height: "10em", width: this.width || this.parent.childWidth },
             { className: "background-color-content smallpopupborder " +
                          "border-color-design" });
         addDOMEvent(this.folderpopup, "click", function(e) {
             cancelBubbling(e);
         });
         this.node = this.parent.addCells(this.label, newnode("div",
             { width: this.width || this.parent.childWidth }, 0,
             [this.input, this.folderpopup]));        
         this.initialized = true;
    },
    
    addContent: function(node_id) {
         var Self = this;
         ox.UI.Widget.prototype.addContent.call(this);
         this.drawMyNode();
    },

    get: function() { return this.folderid; },

    set: function(value) {
        this.folderid = value;
        // set default value, then try to make it look more beautiful
        this.input.firstChild.data = value || "\u00a0";
        // vars
        var m, id, path, account;
        // regexp to cut off account id
        m = (value + "").match(/^default(\d+)\D(.+)$/);
        if (m && m.length) {
            // get account
            id = m[1];
            path = m[2];
            if ((account = ox.api.account.get(id))) {
                this.input.firstChild.data = account.name + ": " + path;
            }
        }
    },
    
    saveView: function(callback) { this.current.saveView(callback); },
    
    cancelView: function() { this.current.cancelView(); }
});

register("Loaded", function() {
    temporary.folderTabs = new temporary.Tabs();
});