/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2004-2012 Open-Xchange, Inc.
 * Mail: info@open-xchange.com 
 * 
 * @author Ben Pahne <ben.pahne@open-xchange.com>
 * @author Karsten Will <karsten.will@open-xchange.com> (fixes for bugs 15726, 16244)
 * @author Wolfgang Rosenauer <wolfgang.rosenauer@open-xchange.com>
 * 
 */


var wizzard;
var wizzardPath = urlify("plugins/com.openexchange.wizard/");
var wizzardTemplate = wizzardPath+"wizard.html";
var wizzardCSS = wizzardPath+"wizard.css";
var wizzardConfig = wizzardPath+"config.js";
var wizzardMailConfig = wizzardPath+"mailconfig.js";
var wizzardImages = "../../"+wizzardPath+"images/";
var wizzardMailServices = new Object();
var wizardPopEnabled = (ox.api.config.contains("modules.mail.protocols") === false
        || jQuery.inArray("pop3", ox.api.config.get("modules.mail.protocols", [ ])) !== -1);

function getAccountName(name) {
    return String(name).replace(/@.*$/, "").
        replace(/[\t\n\f\r!"#$%&'()*+,.\/:;<=>?@\[\\\]^`{|}~]/, " ");
}

function saveCalendarSubscriptionData(service, fields, aData) {
	saveContactSubscriptionData(service, fields, aData);
}

function saveContactSubscriptionData(service, fields, aData) {
	var validError = false;
	var user = aData.login;
	var password = aData.password;
	var crawler = aData.crawler;
	var image = aData.image;
	var subscriptionType = "contacts";
	if (crawler.match(/calendar/)) {
		subscriptionType = "calendar";
	}
	setWizardFieldsDisabled(fields, true);		
	if (user == "" || password == "") {
		ox.UINotifier.note(_("Provide a valid E-Mail address and password."));
		setWizardFieldsDisabled(fields, false);
	} else {
		body.style.cursor="wait";
		var parentFolder;
		
        ox.api.folder.get({
	     folder: getUrlEncodedString(configGetKey("folder."+subscriptionType)),
	     success: function (checkfolder){
			parentFolder = checkfolder;
			
			// simple hard-coded 'Google' fix (#19132)
			var title = service === "gmail" ?
			    "Google" :
			    service.charAt(0).toUpperCase() + service.substr(1);
			
			var data = { "title": title+" "+ user,
			   		"module":subscriptionType,	
			   		"permissions": [{ bits: 403710016, // all admin
			   		                  entity: configGetKey("identifier"),
			   		                  group: false }],
			   		"subscribed":1 };
			ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder."+subscriptionType)), data, 
    			function(reply) {
					var timestamp = reply.timestamp;
					var fid = reply.data;
					var _service = "com.openexchange.subscribe."+crawler;
					var moreData = {"source":_service,
							        "folder":reply.data,
							        "entityModule":subscriptionType,
							        "entity": {"folder":reply.data}};
					moreData[_service] = {"login": user,"password": password};
					
    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
			    			function(reply) {
			    				ox.UINotifier.info(_("Loading Data. This may take a while."));
    							ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
						    			function(reply) {
			    							body.style.cursor="default";
						    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
						    				//image.className = "wizard"+service+"MiniOk";
						    				ox.api.folder.refresh();
						    			},
					                    function(reply) {
						    				ox.UINotifier.warn(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
						    				body.style.cursor="default";
						    				setWizardFieldsDisabled(fields, false);
						    				wizDeleteFolder(fid, timestamp);
					                    	return true;
					                    });
			    			},
		                    function(reply) {
			    				ox.UINotifier.warn(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
			    				body.style.cursor="default";
			    				setWizardFieldsDisabled(fields, false);
			    				wizDeleteFolder(fid, timestamp);
		                    	return true;
		                    });
    			},
                function(reply) {
    				ox.UINotifier.warn(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
    				body.style.cursor="default";
    				setWizardFieldsDisabled(fields, false);
                	return true;
                });
		}});
	}
}


function createMailAccount(fields, data) {
    ox.api.account.create({
        data: data,
        success: function (reply) {
        	if (reply)
        		ox.UINotifier.ok(_("The E-Mail account has been subscribed successfully."));
        	else
        		ox.UINotifier.error(_("Connection failed. Please check your settings."));
            body.style.cursor = "default";
            triggerEvent("OX_Refresh");
        },
        error: function (reply) {
            ox.UINotifier.warn(reply.error ? 
                (
                    reply.error === "Found two mail accounts with same email address %1$s for user %2$s in context %3$s." ? 
                    _("You already subscribed to this account.") : 
                    formatError(reply)
                ) : 
                _("Connection failed. Please check your settings.")
            );
            body.style.cursor = "default";
            setWizardFieldsDisabled(fields, false);
        }
    });
}

function testMailAccount(fields, data, callback) {
    ox.api.account.validate(data,
        // ok
		function (reply) {
    		if (reply.data){
			    if (callback) callback();
			} else {
			    ox.UINotifier.error(_("Connection failed. Please check your settings."));
			    setWizardFieldsDisabled(fields, false);
			}
			body.style.cursor = "default";
		},
		// error
        function (reply) {
			ox.UINotifier.error(_("Connection failed. Please check your settings."));
			body.style.cursor = "default";
			setWizardFieldsDisabled(fields, false);
        	return true;
        }
	);
}

/**
 * Creates an OAuth form for minitabs.
 * @param {Object} self The wizard minitab.
 * @param {String} name The name of the minitab. Used to generate unique IDs.
 * @param {Object} description The account description object
 * (the data parameter for createOAuthAccount).
 * @type DOMNode
 * @return A table DOM element which contains the form elements.
 */
function createOAuthForm(self, name, description) {
    var ctable = newnode('table', { width:"100%", borderCollapse:"collapse" },
        { cellpadding:"0",cellspacing:"0"});
    var ctbody = newnode('tbody');
    
    var oauthButton = newnode("input", { marginTop: "5px" }, {
            className: "wizzardBlankButton fakeButton", type: "button",
            name: "wizzard." + name + ".oauth",
            id: "wizzard." + name + ".oauth", value: _("OK")
        });
    var oauth = wizButton(oauthButton, _("OK"));
    
    var oauthName = newnode("input",
        { width:"14em", margin: "3px 10px 0 10px", flt: "left" },
        { type:"text", id:"wizzard." + name + ".name" });
    ctbody.appendChild(newnode("tr", 0 , 0, [
        newnode("td", { minWidth: "100px", whiteSpace:"nowrap",
                        paddingTop: "10px" }, 0,
                      [addTranslated(_("Account Name"))]),
        newnode("td", { verticalAlign: "middle", paddingTop: "10px"}, 0,
                      [oauthName, oauth])]));
    
    ctbody.appendChild(newnode("tr", 0 , 0, [
        newnode("td"),
        newnode("td", { minWidth: "100px" } , 0, [
            newtext(String(format(_("After pressing OK, a new window will open where you can authorize %s to access your account data."),
                                  oxProductInfo.product_name)))])]));
    
    addDOMEvent(oauth, "click", function() {
        if (oauthButton.disabled == false) {
            if (oauthName.value == "") {
                ox.UINotifier.warn(_("Provide a valid account name."));
            } else {
                createOAuthAccount(description, function(data) {
                    oauthButton.value = _("Done");
                    oauthButton.disabled = true;
                    oauthName.disabled = true;
                    self.saveData({ account: data.id });
                });
            }
        }
    });
    
    ctable.appendChild(ctbody);
    return { table: ctable, body: ctbody };
}

/**
 * ******************************* Generic Mail Minitab
 * 
 */
function MiniTabGenericMail(name) {
	this.name = name;
	this.account = window.wizzardMailServices[name];
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardgenericMailMini", src: getFullImgSrc(wizzardImages+name+"_mini_d.png")});
	this.node = null;
	this.fields = [ "wizzard."+name+".user", "wizzard."+name+".pass", "wizzard."+name+".save" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null){
			//#. %1$s is the product name
			//#, c-format
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardgenericMailMini",src: getFullImgSrc(wizzardImages+name+"_mini_d.png")})]),
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to an EMail account with %1$s."), oxProductInfo.product_name)) ])]));
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("Username"))]),
		                             		            newnode("td", { width: "100%", paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard."+name+".user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard."+name+".pass" })])]));			

			
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard."+name+".save", id:"wizzard."+name+".save", value: _("Save") }), _("Save"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard."+name+".save").disabled == false){
					Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
				}
			});
			
			ctable.appendChild(ctbody);
			this.node = newnode("div",
			    { paddingLeft: "50px", paddingTop: "15px" },
			    0, [ctable2, ctable]);
		}
		base.appendChild(this.node);
		
		if (Self.image.src.lastIndexOf(name+"_mini_ok.png") == -1) {
			Self.image.src = getFullImgSrc(wizzardImages+name + "_mini_o.png");
		}
	};

	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard."+this.name+".user").value == "" || document.getElementById("wizzard."+this.name+".pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			testMailAccount(fields, data, callback);
		}	
	};
	this.saveData = function (data){
		var fields = this.fields;
		if (document.getElementById("wizzard."+this.name+".user").value == "" || document.getElementById("wizzard."+this.name+".pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
			var aid = createMailAccount(fields, data);
		}		
	};
	this.getData = function (){
        var data = this.account;
        data["name"] = this.name + " Mail " + getAccountName(document.getElementById("wizzard."+this.name+".user").value);
		data["primary_address"] = document.getElementById("wizzard."+this.name+".user").value;
		data["login"] = document.getElementById("wizzard."+this.name+".user").value;
		data["password"] = document.getElementById("wizzard."+this.name+".pass").value;
		data["personal"] = document.getElementById("wizzard."+this.name+".user").value;
		return data;
	};
}


/**
 * ******************************* FACEBOOK MINITAB
 * 
 */
function MiniTabFacebook(withMessaging, withSubscription){
	this.name = "facebook";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardfacebookMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.fields = [ "wizzard.facebook.name", "wizzard.facebook.oauth", "wizzard.facebook.withmessaging", "wizzard.facebook.withsubscription" ];
	this.facebookMessaging = withMessaging;
	this.facebookSubscription = withSubscription;
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null){
			var ctable2 = newnode('table',{ minHeight: "5em", borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardfacebookMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(_("Subscribe to a Facebook account. Your facebook contacts will be synchronized into a newly created folder and will be kept up to date.")) ])]));				
			ctable2.appendChild(ctbody2);
			
			
			var ctable = newnode('table',{ width:"90%",borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');				
			
						
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("Account Name"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.facebook.name" })])]));
			
			var oauth = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.facebook.oauth", id:"wizzard.facebook.oauth", value: _("OK") }), _("OK"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("Authorization"))]),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [oauth])]));
			

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap" } , 0, [ ]),
		                             		            newnode("td", { } , 0, [ addTranslated(_("Select the services you want to use")) ])]));			

			if (this.facebookMessaging){
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap" } , 0, [ ]),
				                                          	newnode("td", { paddingTop: "10px" } , 0, [newcheckbox({ marginRight: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.facebook.withmessaging", name:"wizzard.facebook.withmessaging", value:"withmessaging", checked:"true" }), addTranslated(_("With Messaging")) ])]));			
			}
			if (this.facebookSubscription){
				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { } , 0),
				                                          	newnode("td", { paddingTop: "2px" } , 0, [newcheckbox({ marginRight: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.facebook.withsubscription", name:"wizzard.facebook.withsubscription", value:"withsubscription", checked:"true" }), addTranslated(_("With Subscription")) ])]));			
			}
			
			
			function s(text) { return newtext(String(text)); }
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td"), newnode("td", { minWidth: "100px", paddingTop: "15px" } , 0, [s(format(_("After pressing OK, a new window will open where you can authorize %s to access your account data."), oxProductInfo.product_name))])]));

			addDOMEvent(oauth, "click", function() {
				
				var withMes = document.getElementById("wizzard.facebook.withmessaging");
				var withSub = document.getElementById("wizzard.facebook.withsubscription");
				
				if (document.getElementById("wizzard.facebook.oauth").disabled == false){	
					if (document.getElementById("wizzard.facebook.name").value == ""){
						ox.UINotifier.warn(_("Provide a valid account name"));
					} else if (!((withMes && withMes.checked) || (withSub && withSub.checked))){
						ox.UINotifier.warn(_("Select a service you want to use"));
					} else {		
						createOAuthAccount(
			            	{
			                    serviceId: "com.openexchange.oauth.facebook",
			                    displayName: "Wizard Facebook"
			                },
			                function(data) {
			                	document.getElementById("wizzard.facebook.oauth").value = _("Done");
			                	document.getElementById("wizzard.facebook.oauth").disabled = true;
			                	
			                	if (withMes && withMes.checked){
									Self.saveDataMessaging({ configuration: {account: data.id},
										displayName: document.getElementById("wizzard.facebook.name").value,
										messagingService: "com.openexchange.messaging.facebook"
									});
			                	}
			                	if (withSub && withSub.checked){
			                		Self.saveData({ account: data });
			                	}
			                });
					}
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);		
		//if (Self.image.className != "wizardfacebookMiniOk") {
			Self.image.className = "wizardfacebookMiniInactive";
		//}
	};
	this.saveDataMessaging = function (moreData){
		ox.JSON.put(AjaxRoot + "/messaging/account/?action=new&session=" + session, moreData, 
			function(reply) {
				body.style.cursor="default";
				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
				//Self.image.className = "wizardfacebookMiniOk";
				document.getElementById("wizzard.facebook.oauth").disabled = true;
				ox.api.folder.refresh();
			},
            function(reply) {
				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				body.style.cursor="default";
            	return true;
            }
		);	
	};
	this.saveData = function (someData){
		var fields = this.fields;
		var validError  = false;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.facebook.name").value == ""){
			ox.UINotifier.warn(_("Provide a valid account name"));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			var parentFolder;
	        ox.api.folder.get({
			     folder: getUrlEncodedString(configGetKey("folder.contacts")),
			     success: function (checkfolder){
				parentFolder = checkfolder;
				var data = { "title": "Facebook "+ document.getElementById("wizzard.facebook.name").value,
				   		"module":"contacts",	
				   		"permissions": [{ bits: 403710016, // all admin
				   		                  entity: configGetKey("identifier"),
				   		                  group: false }],
				   		"subscribed":1 };
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
	    				var moreData = {"source":"com.openexchange.subscribe.socialplugin.facebook",
	    								"folder":reply.data,
	    								"com.openexchange.subscribe.socialplugin.facebook": { account: someData.account.id },
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data}};
	    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData,
				    			function(reply) {
				    				ox.UINotifier.ok(_("Loading Data. This may take a while."));
	    							ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
							    			function(reply) {
				    							body.style.cursor="default";
							    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
							    				//Self.image.className = "wizardfacebookMiniOk";
							    				ox.api.folder.refresh();
							    			},
						                    function(reply) {
							    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
							    				body.style.cursor="default";
							    				setWizardFieldsDisabled(fields, false);
							    				wizDeleteFolder(fid, timestamp);
						                    	return true;
						                    });
				    			},
			                    function(reply) {
				    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);
			                    	return true;
			                    });	
	    			},
                    function(reply) {
	    				ox.UINotifier.error(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			}});
		}
	};
}

/**
 * ******************************* Twitter MINITAB
 * 
 */

function MiniTabTwitter(){
	this.name = "twitter";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardtwitterMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null){
			var ctable2 = newnode('table',{ minHeight: "5em", borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardtwitterMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(_("Subscribe to a Twitter account. Read and post to your Twitter Stream")) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = createOAuthForm(this, "twitter", {
                serviceId: "com.openexchange.oauth.twitter",
                displayName: "Wizard Twitter"
			}).table;
            
			this.node = newnode("div",{ paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);		
		//if (Self.image.className != "wizardtwitterMiniOk") {
			Self.image.className = "wizardtwitterMiniInactive";
		//}
	};

	this.saveData = function(data) {
	    var moreData = {
	        configuration: data,
            displayName: document.getElementById("wizzard.twitter.name").value,
            messagingService: "com.openexchange.messaging.twitter"
        };
		ox.JSON.put(AjaxRoot + "/messaging/account/?action=new&session=" + session, moreData, 
			function(reply) {
				body.style.cursor="default";
				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
				//Self.image.className = "wizardtwitterMiniOk";
				document.getElementById("wizzard.twitter.oauth").disabled = true;
				ox.api.folder.refresh();
			},
            function(reply) {
				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				body.style.cursor="default";
            	return true;
            }
		);
	}
}

/**
 * ******************************* TONLINE MINITAB
 * 
 */
function MiniTabTOnline(config){
	this.name = "tonline";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardtonlineMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.withSub = config.crawler;
	this.withMail = config.mail;
	this.fields = [ "wizzard.tonline.user", "wizzard.tonline.pass", "wizzard.tonline.save",
	                "wizzard.tonline.import:1", "wizzard.tonline.import:2", "wizzard.tonline.import:3" ];
	var Self = this;

	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);

		if (this.node == null){
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody2 = newnode('tbody');
			
			//#. %1$s is the product name
			//#, c-format
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardtonlineMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a T-Online account and use your T-Online mails and contacts with %1$s."), oxProductInfo.product_name)) ])])); 				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{width:"90%",borderCollapse:"collapse"},{ cellpadding:"0", cellspacing:"0"});
			var ctbody = newnode('tbody');	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap" } , 0, [addTranslated(_("Username"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.tonline.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.tonline.pass" })])]));
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap" } , 0, [addTranslated(_("Import"))]),
		                             		            newnode("td", { } , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.tonline.import:1", name:"wizzard.tonline.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("E-Mails and contacts")) ])]));			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { } , 0),
		                             		            newnode("td", { } , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.tonline.import:2", name:"wizzard.tonline.import", value:"mails" }), addTranslated(_("E-Mails only")) ])]));			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { } , 0),
		                             		            newnode("td", { } , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.tonline.import:3", name:"wizzard.tonline.import", value:"contacts" }), addTranslated(_("Contacts only")) ])]));

			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.tonline.save", id:"wizzard.tonline.save" , value: _("Save") }), _("Save"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px" } , 0, [ save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.tonline.save").disabled == false){
					if (Self.withMail == true) {
						Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
					} else {
						Self.saveData();
					}
				}
			});
			
			ctbody.appendChild(newnode("tr", 0, 0, [
			    newnode("td", 0, { colSpan: 2 }, [
			        newnode("p", 0, 0, [addTranslated(_("In order to receive your E-Mails from a T-Online inbox, a password needs be set for this inbox. For some older inboxes this might not be the case. If you have not already set a password for the respective inbox, you can do this here:"))]),
			        newnode("a", 0, { href: "https://kundencenter.telekom.de/kundencenter/dienste-abos/email-sms/postfach-einstellungen.html", target: "_blank" },
			            [newtext("https://kundencenter.telekom.de/kundencenter/dienste-abos/email-sms/postfach-einstellungen.html")])
			    ])
			]));
			
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);
		
		if (this.withSub == false) {
			document.getElementById("wizzard.tonline.import:1").disabled = true;
			document.getElementById("wizzard.tonline.import:3").disabled = true;
			document.getElementById("wizzard.tonline.import:2").checked = true;
		} else if (this.withMail == false) {
			document.getElementById("wizzard.tonline.import:3").checked = true;
			document.getElementById("wizzard.tonline.import:1").disabled = true;
			document.getElementById("wizzard.tonline.import:2").disabled = true;
		}

		//if (Self.image.className != "wizardtonlineMiniOk") {
			Self.image.className = "wizardtonlineMiniInactive";
		//}
	};

	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.tonline.user").value == "" || document.getElementById("wizzard.tonline.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			if (! document.getElementById("wizzard.tonline.import:3").checked) {
				body.style.cursor="wait";
				testMailAccount(fields, data, callback);
			} else {
	            if (callback) callback();
	        }
		}	
	};

	this.saveData = function (data){
		var name = this.name;
		var fields = this.fields;
		if (document.getElementById("wizzard.tonline.user").value == "" || document.getElementById("wizzard.tonline.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
		
			function callMeBack(aid){
				var moreData = {"login":document.getElementById("wizzard.tonline.user").value,
								"password":document.getElementById("wizzard.tonline.pass").value,
								"crawler":"crawler.t-online.de",
								"image": Self.image};
				saveContactSubscriptionData(name, fields, moreData);
			}
			
			if (document.getElementById("wizzard.tonline.import:1").checked || document.getElementById("wizzard.tonline.import:2").checked){
				var aid = createMailAccount(fields, data);
				if (document.getElementById("wizzard.tonline.import:1").checked) {
					callMeBack(aid);
				}
	    	} else if (document.getElementById("wizzard.tonline.import:3").checked){
	    		callMeBack();
	    	}
		}		
	};

	this.getData = function (){
		var name = document.getElementById("wizzard.tonline.user").value;
		var data = {
				"name":"T-Online Mail "+ getAccountName(name),
				"primary_address": document.getElementById("wizzard.tonline.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.tonline.user").value,
				"password": document.getElementById("wizzard.tonline.pass").value,
				"transport_secure":false,
				"transport_server": wizard_tonline_transport_service,
				"transport_port": wizard_tonline_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"
			}
		data["personal"]=document.getElementById("wizzard.tonline.user").value;
		data["mail_protocol"]="imap";
		data["mail_server"]=wizard_tonline_imap_server;
		data["mail_port"]=wizard_tonline_imap_port;
					
		return data;
	}	
}

/**
 * ******************************* MSN MINITAB
 * 
 */
function MiniTabMSN(){
	this.name = "msn";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardmsnMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.fields = [ "wizzard.msn.name", "wizzard.msn.oauth" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null){
			var ctable2 = newnode('table',{ minHeight: "5em", borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardmsnMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a MSN account and use your MSN contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
            var ctable = createOAuthForm(this, "msn", {
                serviceId: "com.openexchange.oauth.msn",
                displayName: "Wizard MSN"
            }).table;
            
			this.node = newnode("div",{ paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);		
		//if (Self.image.className != "wizardmsnMiniOk") {
			Self.image.className = "wizardmsnMiniInactive";
		//}
	}
	this.saveData = function (someData){
		var fields = this.fields;
		var validError  = false;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.msn.name").value == ""){
			ox.UINotifier.warn(_("Provide a valid account name"));
			setWizardFieldsDisabled(fields, false);
		} else {			
			body.style.cursor="wait";					
			var parentFolder;
	        ox.api.folder.get({
			     folder: getUrlEncodedString(configGetKey("folder.contacts")),
			     success: function (checkfolder){
				parentFolder = checkfolder;
				var data = { "title": "MSN "+ document.getElementById("wizzard.msn.name").value,
				   		"module":"contacts",	
				   		"permissions": [{ bits: 403710016, // all admin
				   		                  entity: configGetKey("identifier"),
				   		                  group: false }],
				   		"subscribed":1 }
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
	    				var moreData = {"source":"com.openexchange.subscribe.socialplugin.msn",
	    								"folder":reply.data,
	    								"com.openexchange.subscribe.socialplugin.msn": someData,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data}}
	    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
				    				ox.UINotifier.ok(_("Loading Data. This may take a while."));
	    							ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
							    			function(reply) {
				    							body.style.cursor="default";
							    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
							    				//Self.image.className = "wizardmsnMiniOk";
							    				ox.api.folder.refresh();
							    			},
						                    function(reply) {
							    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
							    				body.style.cursor="default";
							    				setWizardFieldsDisabled(fields, false);
							    				wizDeleteFolder(fid, timestamp);
						                    	return true;
						                    });
				    			},
			                    function(reply) {
				    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);
			                    	return true;
			                    });	
	    			},
                    function(reply) {
	    				ox.UINotifier.error(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			}});
		}
	}
}


/**
 * ******************************* GMX MINITAB
 * 
 */
function MiniTabGMX(config){
	this.name = "gmx";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardgmxMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	//this.withSub = config.crawler;
	this.withSub = false;
	this.withMail = config.mail;
	this.fields = [ "wizzard.gmx.user", "wizzard.gmx.pass", "wizzard.gmx.connection:1", "wizzard.gmx.connection:2",
	                "wizzard.gmx.import:1", "wizzard.gmx.import:2", "wizzard.gmx.import:3", "wizzard.gmx.save"];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);

		if (this.node == null){
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody2 = newnode('tbody');
			
			//#. %1$s is the product name
			//#, c-format
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardgmxMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a GMX account and use your GMX E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])])); 				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0", cellspacing:"0"});
			var ctbody = newnode('tbody');	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap",paddingTop: "10px"} , 0, [addTranslated(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.gmx.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.gmx.pass" })])]));
			
			if (this.withMail == true) {
				ctbody.appendChild( newnode("tr", { display: (wizardPopEnabled ? "" : "none") } , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [addTranslated(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px"}, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.connection:1", name:"wizzard.gmx.connection",value:"imap", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("Imap")) ])]));
				if (wizardPopEnabled) {
    				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
    		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.connection:2", name:"wizzard.gmx.connection", value:"pop" }), addTranslated(_("POP3")) ])]));
				}
			}
			
			if (this.withSub === true && this.withMail === true) {
    			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [addTranslated(_("Import"))]),
    		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:1", name:"wizzard.gmx.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("E-Mails and contacts")) ])]));
			}
			if (this.withMail === true) {
			    var attr = { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:2", name:"wizzard.gmx.import", value:"mails" };
			    if (this.withSub === false) {
			        attr = jQuery.extend({ checked:"true", defaultChecked:"defaultChecked"}, attr);
			    }
    			ctbody.appendChild( newnode("tr", { display: (this.withSub === false ? "none" : "") } , 0, [	newnode("td", { paddingTop: "5px"} , 0),
    		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, attr), addTranslated(_("E-Mails only")) ])]));
			}
			if (this.withSub === true) {
			    var attr = { type:"radio", className:"noBorderRadio", id:"wizzard.gmx.import:3", name:"wizzard.gmx.import", value:"contacts" };
                if (this.withMail === false) {
                    attr = jQuery.extend({ checked:"true", defaultChecked:"defaultChecked"}, attr);
                }
			    ctbody.appendChild( newnode("tr", { display: (this.withMail === false ? "none" : "") } , 0, [ newnode("td", { paddingTop: "5px"} , 0),
		                                                        newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, attr), addTranslated(_("Contacts only")) ])]));
			}
						
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.gmx.save", id:"wizzard.gmx.save" , value: _("Save") }), _("Save"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.gmx.save").disabled == false){
					if (Self.withMail == true) {
						Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
					} else {
						Self.saveData();
					}
				}	
			});
			
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);

		//if (Self.image.className != "wizardgmxMiniOk") {
			Self.image.className = "wizardgmxMiniInactive";
		//}
	};
	this.testData = function (data, callback){
		var fields = this.fields;
		if (document.getElementById("wizzard.gmx.user").value == "" || document.getElementById("wizzard.gmx.pass").value == ""){
			ox.UINotifier.info(_("Provide a valid E-Mail address and password."));
		} else {
			// check email for gmx.de
			if (this.withSub === true && (document.getElementById("wizzard.gmx.import:1").checked || 
			    document.getElementById("wizzard.gmx.import:3").checked)) {
				if (!document.getElementById("wizzard.gmx.user").value.match(/gmx\.de/)) {
				    if (document.getElementById("wizzard.gmx.import:1").checked) {
					    ox.UINotifier.info(_("Currently only gmx.de is supported for contacts. Mail account is being set up now."));
				    } else {
				        ox.UINotifier.warn(_("Currently only gmx.de is supported for contacts."));
				        return;
				    }
				}
			}
			setWizardFieldsDisabled(fields, true);
			if (this.withMail === true && (this.withSub === true && !document.getElementById("wizzard.gmx.import:3").checked)) {
				body.style.cursor="wait";
				testMailAccount(fields, data, callback);
			} else {
	            if (callback) callback();
	        }
		}	
	};
	this.saveData = function (data){
		var name = this.name;
		var fields = this.fields;
		if (document.getElementById("wizzard.gmx.user").value == "" || document.getElementById("wizzard.gmx.pass").value == ""){
			ox.UINotifier.info(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";		
		
			function callMeBack(aid){
				var moreData = {"login":document.getElementById("wizzard.gmx.user").value,
								"password":document.getElementById("wizzard.gmx.pass").value,
								"crawler":"crawler.gmx",
								"image": Self.image};
				saveContactSubscriptionData(name, fields, moreData);
			}
			
			if ((this.withMail === true && document.getElementById("wizzard.gmx.import:2").checked)
			        || (this.withSub === true && document.getElementById("wizzard.gmx.import:1").checked)){
				var aid = createMailAccount(fields, data);
				if (this.withSub === true && document.getElementById("wizzard.gmx.import:1").checked) {
					callMeBack(aid);
				}
	    	} else if (document.getElementById("wizzard.gmx.import:3").checked){
	    		callMeBack();
	    	}
		}		
	};
	this.getData = function (){
        var name = document.getElementById("wizzard.gmx.user").value;
		var data = {
                "name": "GMX Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.gmx.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.gmx.user").value,
				"password": document.getElementById("wizzard.gmx.pass").value,
				"transport_secure":true,
				"transport_server": wizard_gmx_transport_service,
				"transport_port": wizard_gmx_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"
			};					
			if (document.getElementById("wizzard.gmx.connection:1").checked) {
				data["mail_protocol"]="imap";
				data["mail_server"]=wizard_gmx_imap_server;
				data["mail_port"]=wizard_gmx_imap_port;
			} else {
				data["personal"]=document.getElementById("wizzard.gmx.user").value;
				data["mail_protocol"]="pop3";
				data["mail_server"]=wizard_gmx_pop_server;
				data["mail_port"]=wizard_gmx_pop_port;
				data["pop3_refresh_rate"]="3";
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;
				data["pop3_storage"] = "mailaccount";
			}
		
		return data;
	};
}

/**
 * ******************************* GMAIL MINITAB
 * 
 */
function MiniTabGmail(config){
	this.name = "gmail";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardgmailMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.withSub = config.crawler;
	this.withMail = config.mail;
	this.withCalendar = config.calendar;
	this.fields = [ "wizzard.gmail.user", "wizzard.gmail.pass", "wizzard.gmail.connection:1", "wizzard.gmail.connection:2",
	                "wizzard.gmail.mail", "wizzard.gmail.contacts", "wizzard.gmail.calendar", "wizzard.gmail.save" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null) {
			//#. %1$s is the product name
            //#, c-format
			var ctable2 = newnode('table', { borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px" } , {colSpan: 2} , [ newnode("img", {}, {className:"wizardgmailMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Google E-Mail account and use your Google E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])]));
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.gmail.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.gmail.pass" })])]));
			if (this.withMail == true) {
				ctbody.appendChild( newnode("tr", { display: (wizardPopEnabled ? "" : "none") }, 0, [ newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [addTranslated(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.connection:1", name:"wizzard.gmail.connection", value:"imap", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("Imap")) ])]));
				if (wizardPopEnabled) {
    				ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { paddingTop: "5px"} , 0),
    		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.gmail.connection:2", name:"wizzard.gmail.connection", value:"pop" }), addTranslated(_("POP3")) ])]));
				}
			}
			
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [addTranslated(_("Import"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newcheckbox({ marginLeft: "10px" }, { className:"noBorderRadio", type:"checkbox", id:"wizzard.gmail.mail", value:"mail", checked:"true" }), addTranslated(_("E-Mails")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newcheckbox({ marginLeft: "10px" }, { className:"noBorderRadio", type:"checkbox", id:"wizzard.gmail.contacts", value:"contacts", checked:"true" }), addTranslated(_("Contacts")) ])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newcheckbox({ marginLeft: "10px" }, { className:"noBorderRadio", type:"checkbox", id:"wizzard.gmail.calendar", value:"calendar", checked:"true" }), addTranslated(_("Calendar")) ])]));
						
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", id:"wizzard.gmail.save", name:"wizzard.gmail.save", value: _("Save") }), _("Save"));	
			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.gmail.save").disabled == false){
					if (document.getElementById("wizzard.gmail.mail").checked) {
						Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
					} else {
						Self.saveData();
					}
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);		
		}
		base.appendChild(this.node);
		
		if (this.withSub == false) {
			document.getElementById("wizzard.gmail.contacts").disabled = true;
			document.getElementById("wizzard.gmail.contacts").checked = false;
		}
		if (this.withMail == false) {
			document.getElementById("wizzard.gmail.mail").checked = false;
			document.getElementById("wizzard.gmail.mail").disabled = true;
		}
		if (this.withCalendar == false) {
			document.getElementById("wizzard.gmail.calendar").checked = false;
			document.getElementById("wizzard.gmail.calendar").disabled = true;
		}
		
		//if (Self.image.className != "wizardgmailMiniOk") {
			Self.image.className = "wizardgmailMiniInactive";
		//}
	};
	
	this.getData = function (){
        var name = document.getElementById("wizzard.gmail.user").value;
		var data = {
				"name": "Google Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.gmail.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.gmail.user").value,
				"password": document.getElementById("wizzard.gmail.pass").value,
				"transport_secure":true,
				"transport_server":wizard_gmail_transport_service,
				"transport_port":wizard_gmail_transport_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"
			};					
			if (document.getElementById("wizzard.gmail.connection:1").checked) {
				data["mail_protocol"]="imap";
				data["mail_server"]=wizard_gmail_imap_server;
				data["mail_port"]=wizard_gmail_imap_port;
			} else {
				data["personal"]=document.getElementById("wizzard.gmail.user").value;
				data["mail_protocol"]="pop3";
				data["mail_server"]=wizard_gmail_pop_server;
				data["mail_port"]=wizard_gmail_pop_port;
				data["pop3_refresh_rate"]="3";
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;	
				data["pop3_storage"] = "mailaccount";
			}
		return data;
	};
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.gmail.user").value == "" || document.getElementById("wizzard.gmail.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {			
			if (document.getElementById("wizzard.gmail.mail").checked) {
				body.style.cursor="wait";
				testMailAccount(fields, data, callback);
			} else {
	            if (callback) callback();
	        }
		}
	};
	this.saveData = function (data){
		var name = this.name;
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.gmail.user").value == "" || document.getElementById("wizzard.gmail.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			
			function callMeBack(aid){
				// contacts subscription
				if (document.getElementById("wizzard.gmail.contacts").checked) {
					var moreData = {"login":document.getElementById("wizzard.gmail.user").value,
									"password":document.getElementById("wizzard.gmail.pass").value,
									"crawler":"crawler.googlemail",
									"image": Self.image};
					saveContactSubscriptionData(name, fields, moreData);
				}

				// calendar subscription
				if (document.getElementById("wizzard.gmail.calendar").checked) {
					var moreData = {"login":document.getElementById("wizzard.gmail.user").value,
									"password":document.getElementById("wizzard.gmail.pass").value,
									"crawler":"crawler.google.calendar",
									"image": Self.image};
					saveCalendarSubscriptionData(name, fields, moreData);
				}
			}
			
			if (document.getElementById("wizzard.gmail.mail").checked) {
				var aid = createMailAccount(fields, data);
   				if (document.getElementById("wizzard.gmail.contacts").checked){
   					callMeBack(aid);
   				}
	    	} else if (document.getElementById("wizzard.gmail.contacts").checked ||
	    			   document.getElementById("wizzard.gmail.calendar").checked) {
				callMeBack();
			}
		}
	};
}

/**
* ******************************* YAHOO MINITAB
* 
*/
function MiniTabYahoo(config){
	this.name = "yahoo";
	this.position = 0;
    this.image = newnode("img", 0, {className: "wizardyahooMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.withSub = config.crawler;
	this.withMail = config.mail;
	this.withOAuth = config.oauth;
	this.fields = [ "wizzard.yahoo.user", "wizzard.yahoo.pass", "wizzard.yahoo.connection:1", "wizzard.yahoo.connection:2",
	                "wizzard.yahoo.import:1", "wizzard.yahoo.import:2", "wizzard.yahoo.import:3", "wizzard.yahoo.save" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
        function createMail(ctbody) {
            ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { width: "140px", whiteSpace:"nowrap", paddingTop: "8px"} , 0, [addTranslated(_("E-Mail with domain"))]),
                                                        newnode("td", { paddingTop: "8px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.yahoo.user" })])]));
            ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
                                                        newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.yahoo.pass" })])])); 
            if (Self.withMail) {
                ctbody.appendChild( newnode("tr", { display: (wizardPopEnabled ? "" : "none") }, 0, [  newnode("td", { paddingTop: "15px", verticalAlign: "top" } , { rowSpan: 2 }, [addTranslated(_("Do you have a Yahoo Plus account?"))]),
                                                        newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.connection:1", name:"wizzard.yahoo.connection", value:"pop", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("No")) ])]));
                if (wizardPopEnabled) {
                    ctbody.appendChild( newnode("tr", 0 , 0, [  // first td <- rowspan
                                                        newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.yahoo.connection:2", name:"wizzard.yahoo.connection", value:"poppro" }), addTranslated(_("Yes")) ])]));
                }
            }
        }
        
        function createSaveButton(ctbody) {
            var save = newnode("input", { marginTop: "5px" },
                { className: "wizzardBlankButton fakeButton", type: "button",
                  name:"wizzard.yahoo.save", id:"wizzard.yahoo.save",
                  value: _("Save") });
            var saveButton = wizButton(save, _("Save"));          
            ctbody.appendChild( newnode("tr", 0, 0, [
                newnode("td"),
                newnode("td", { paddingLeft: "10px", paddingTop: "15px",
                                paddingBottom: "15px"}, 0, [saveButton])]));
            
            addDOMEvent(save, "click", function(){
                if (!saveButton.disabled) {
                    if (Self.withMail == true) {
                        Self.testData(Self.getData(), function() {
                            Self.saveMailData(Self.getData());
                        });
                    } else {
                        Self.saveMailData();
                    }
                }
            }); 
        }
        
        function createRadio(id, value, text, desc, padding) {
            jQuery(ctbody).append(newnode("tr", 0 , 0, [
                newnode("td",
                    { whiteSpace: "nowrap", paddingTop: padding || "5px" }, 0,
                     [addTranslated(desc)]),
                newnode("td", { paddingTop: padding || "5px"}, 0, [
                    newradio({ marginLeft: "10px" }, {
                        className: "noBorderRadio", type: "radio",
                        id: "wizzard.yahoo.import:" + id,
                        name: "wizzard.yahoo.import", value: value,
                        checked: "true", defaultChecked: "defaultChecked"
                    }),
                    addTranslated(text)
                ])
            ]));
        }
        function radio(n) {
	        // do it the jQuery way. makes selection easier when nodes 
	        // haven't been applied to the document yet
            return jQuery("#wizzard\\.yahoo\\.import\\:" + n, ctbody);
        }
        
		if (this.node == null){
            
			//#. %1$s is the product name
            //#, c-format
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardyahooMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Yahoo account and use your Yahoo E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])]));
			ctable2.appendChild(ctbody2);
            
			if (this.withOAuth) {
			    var c = createOAuthForm(this, "yahoo", {
                    serviceId: "com.openexchange.oauth.yahoo",
                    displayName: "Wizard Yahoo"
                });
			    var ctable = newnode("div", 0, 0, [c.table]);
			    var ctbody = c.body;
			    
			    if (this.withMail) {
			        ctbody.insertBefore(
			            newnode("tr", { fontWeight: "bold" }, 0,
			                [newnode("td", 0, 0, [addTranslated(_("Contacts"))])]),
			            ctbody.firstChild);
			        ctbody.appendChild(
			            newnode("tr", { fontWeight: "bold" }, 0,
                            [newnode("td", 0, 0, [addTranslated(_("E-Mail"))])]));
			        createMail(ctbody);
			        createSaveButton(ctbody);
			    }
			} else {
    			var ctable = newnode('table', { borderCollapse:"collapse" },
                                     { cellpadding:"0",cellspacing:"0"});
    			var ctbody = newnode('tbody');
    			createMail(ctbody);
                
                createRadio(1, "mailsandcontacts", _("E-Mails and contacts"), _("Import"),
                            "15px");
                createRadio(2, "mails", _("E-Mails only"), "");
                createRadio(3, "contacts", _("Contacts only"), "");
                createSaveButton(ctbody);
                ctable.appendChild(ctbody);
                
                if (this.withSub == false) {
                    radio(1).attr("disabled", true).css({ opacity: 0.5 })
                        .removeAttr("defaultChecked").attr("checked", false);
                    radio(3).attr("disabled", true).css({ opacity: 0.5 })
                        .removeAttr("defaultChecked").attr("checked", false);
                    radio(2).attr("checked", true);
                } else if (this.withMail == false) {
                    radio(3).attr("checked", true);
                    radio(1).attr("disabled", true).css({ opacity: 0.5 })
                        .removeAttr("defaultChecked").attr("checked", false);
                    radio(2).attr("disabled", true).css({ opacity: 0.5 })
                        .removeAttr("defaultChecked").attr("checked", false);
                } else {
                	radio(1).attr("checked", true);
                    radio(2).attr("checked", false)
                        .removeAttr("defaultChecked").attr("checked", false);
                    radio(3).attr("checked", false)
                        .removeAttr("defaultChecked").attr("checked", false);
                }
            }
            
			this.node = newnode("div",
			    { paddingLeft: "50px", paddingTop: "15px" }, 0,
			    [ctable2,ctable]);
		}
		base.appendChild(this.node);
		
		//if (Self.image.className != "wizardyahooMiniOk") {
		    Self.image.className = "wizardyahooMiniInactive";
		//}
	};
	this.getData = function(){
        var name = document.getElementById("wizzard.yahoo.user").value;
		var data = {
                "name": "Yahoo Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.yahoo.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.yahoo.user").value,
				"password": document.getElementById("wizzard.yahoo.pass").value,
				"transport_secure":true,
				"transport_port":wizard_yahoo_transport_service_port,
				"transport_credentials":false,
				"tree":false,				
				"spam_handler":"NoSpamHandler",
				"personal":document.getElementById("wizzard.yahoo.user").value
			};	
		
			if (wizardPopEnabled && document.getElementById("wizzard.yahoo.connection:2").checked) {
				data["transport_server"]=wizard_yahoo_plus_transport_service;
				data["mail_server"]=wizard_yahoo_plus_pop_server;
				data["mail_protocol"]="pop3";
				data["mail_port"]=wizard_yahoo_pop_port;
				data["pop3_refresh_rate"]=3;
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;
				data["pop3_storage"]="mailaccount";
			} else {
				data["transport_server"]=wizard_yahoo_transport_service;
				data["mail_server"]=wizard_yahoo_imap_service;
				data["mail_protocol"]="imap";
				data["mail_port"]=wizard_yahoo_imap_port;
			}
		return data;
	};
	this.testData = function (data, callback) {
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.yahoo.user").value == "" || document.getElementById("wizzard.yahoo.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			if (   this.withOAuth
			    || !document.getElementById("wizzard.yahoo.import:3").checked)
			{
				body.style.cursor="wait";
				testMailAccount(fields, data, callback);
			} else {
	            if (callback) callback();
	        }
		}	
    };
    
	this.saveData = function(someData) {
        var fields = this.fields;
        if (document.getElementById("wizzard.yahoo.name").value == ""){
            ox.UINotifier.warn(_("Provide a valid account name"));
        } else {            
            body.style.cursor="wait";
            var parentFolder;
            ox.api.folder.get({
                folder: getUrlEncodedString(configGetKey("folder.contacts")),
                success: createFolder
            });
        }
        function createFolder(checkfolder) {
            parentFolder = checkfolder;
            var data = {
                title: "Yahoo " +
                       document.getElementById("wizzard.yahoo.name").value,
                module: "contacts",    
                permissions: [{ bits: 403710016, // all admin
                                entity: configGetKey("identifier"),
                                group: false }],
                subscribed: 1
            };
            ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session +
                "&folder_id=" +
                getUrlEncodedString(configGetKey("folder.contacts")), data, 
                createSubscription,
                function(reply) {
                    ox.UINotifier.error(reply.error
                        ? ((reply.error == "A duplicate folder exists in " +
                                           "parent folder %1$s in context %2$s")
                            ? _("You already subscribed to this account.")
                            : formatError(reply))
                        : _("Unable to create a new folder."));
                    body.style.cursor = "default";
                    return true;
                }); 
        }
        function createSubscription(reply) {
            var timestamp = reply.timestamp;
            var fid = reply.data;
            var moreData = {
                source: "com.openexchange.subscribe.socialplugin.yahoo",
                folder: reply.data,
                "com.openexchange.subscribe.socialplugin.yahoo": someData,
                entityModule: "contacts",
                entity: { folder: reply.data }
            };
            ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" +
                session, moreData, refreshSubscriptions, function(reply) {
                    ox.UINotifier.error(reply.error ? formatError(reply) :
                        _("Unable to create a new subscription."));
                    body.style.cursor="default";
                    wizDeleteFolder(fid, timestamp);
                    return true;
                }); 
        }
        function refreshSubscriptions(reply) {
            ox.UINotifier.ok(_("Loading Data. This may take a while."));
            ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id=" +
                reply.data + "&session=" + session, refreshFolders,
                function(reply) {
                    ox.UINotifier.error(reply.error ? formatError(reply) :
                        _("Unable to create a new subscription."));
                    body.style.cursor="default";
                    wizDeleteFolder(fid, timestamp);
                    return true;
                });
        }
        function refreshFolders(reply) {
            body.style.cursor="default";
            ox.UINotifier.ok(reply.error ? formatError(reply) :
                _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
            ox.api.folder.refresh();
        }
    };
    
	this.saveMailData = function(data) {
		var name = this.name;
		var fields = this.fields;
		if (document.getElementById("wizzard.yahoo.user").value == "" || document.getElementById("wizzard.yahoo.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";

			function callMeBack() {
				var moreData = {"login":document.getElementById("wizzard.yahoo.user").value,
								"password":document.getElementById("wizzard.yahoo.pass").value,
								"crawler":"crawler.yahoocom",
								"image": Self.image};
				saveContactSubscriptionData(name, fields, moreData);
			}
			
			if (   this.withOAuth
			    || document.getElementById("wizzard.yahoo.import:1").checked
			    || document.getElementById("wizzard.yahoo.import:2").checked)
			{
				createMailAccount(fields, data);
   				if (   !this.withOAuth
   				    && document.getElementById("wizzard.yahoo.import:1").checked)
   				{
   					callMeBack();
   				}
	    	} else if (document.getElementById("wizzard.yahoo.import:3").checked){
				callMeBack();
			}		    	
		}
	};
}

/**
* ******************************* WEBDE MINITAB
* 
*/
function MiniTabWebde(config){
	this.name = "webde";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardwebdeMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	//this.withSub = config.crawler;
	this.withSub = false;
	this.withMail = config.mail;
	this.fields = [ "wizzard.webde.user", "wizzard.webde.pass", "wizzard.webde.connection:1", "wizzard.webde.connection:2",
	                "wizzard.webde.import:1", "wizzard.webde.import:2", "wizzard.webde.import:3", "wizzard.webde.save"];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null) {
			//#. %1$s is the product name
            //#, c-format
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardwebdeMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Web.de account and use your E-Mails and contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { width: "140px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("E-Mail with domain"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.webde.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.webde.pass" })])]));
			
			if (this.withMail == true) {
				ctbody.appendChild( newnode("tr", { display: (wizardPopEnabled ? "" : "none") } , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "15px"} , 0, [addTranslated(_("Type of connection"))]),
		                             		            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.connection:1", name:"wizzard.webde.connection", value:"imap", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("Imap")) ])]));
				if (wizardPopEnabled) {
    				ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { paddingTop: "5px"} , 0),
    		                             		            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, { className:"noBorderRadio", type:"radio", id:"wizzard.webde.connection:2", name:"wizzard.webde.connection", value:"pop" }), addTranslated(_("POP3")) ])]));
				}
			}
			
            if (this.withSub === true && this.withMail === true) {
                ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { whiteSpace:"nowrap",paddingTop: "15px"} , 0, [addTranslated(_("Import"))]),
                                                            newnode("td", { paddingTop: "15px"} , 0, [newradio({ marginLeft: "10px" }, { type:"radio", className:"noBorderRadio", id:"wizzard.webde.import:1", name:"wizzard.webde.import", value:"mailsandcontacts", checked:"true", defaultChecked:"defaultChecked" }), addTranslated(_("E-Mails and contacts")) ])]));
            }
            if (this.withMail === true) {
                var attr = { type:"radio", className:"noBorderRadio", id:"wizzard.webde.import:2", name:"wizzard.webde.import", value:"mails" };
                if (this.withSub === false) {
                    attr = jQuery.extend({ checked:"true", defaultChecked:"defaultChecked"}, attr);
                }
                ctbody.appendChild( newnode("tr", { display: (this.withSub === false ? "none" : "") } , 0, [    newnode("td", { paddingTop: "5px"} , 0),
                                                            newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, attr), addTranslated(_("E-Mails only")) ])]));
            }
            if (this.withSub === true) {
                var attr = { type:"radio", className:"noBorderRadio", id:"wizzard.webde.import:3", name:"wizzard.webde.import", value:"contacts" };
                if (this.withMail === false) {
                    attr = jQuery.extend({ checked:"true", defaultChecked:"defaultChecked"}, attr);
                }
                ctbody.appendChild( newnode("tr", { display: (this.withMail === false ? "none" : "") } , 0, [ newnode("td", { paddingTop: "5px"} , 0),
                                                                newnode("td", { paddingTop: "5px"} , 0, [newradio({ marginLeft: "10px" }, attr), addTranslated(_("Contacts only")) ])]));
            }

            var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.webde.save", id:"wizzard.webde.save", value: _("Save") }), _("Save"));
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [ save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.webde.save").disabled == false){
					if (Self.withMail == true) {
						Self.testData(Self.getData(), function() { Self.saveData(Self.getData()); });
					} else {
						Self.saveData();
					}
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);

		//if (Self.image.className != "wizardwebdeMiniOk") {
			Self.image.className = "wizardwebdeMiniInactive";
		//}
	};
	this.testData = function (data, callback){
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.webde.user").value == "" || document.getElementById("wizzard.webde.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			if (this.withMail === true && (this.withSub === true && !document.getElementById("wizzard.webde.import:3").checked)) {
				body.style.cursor="wait";
				testMailAccount(fields, data, callback);
			} else {
	            if (callback) callback();
	        }
		}	
	};
	this.saveData = function (data){
		var name = this.name;
		var validError  = false;
		var fields = this.fields;
		if (document.getElementById("wizzard.webde.user").value == "" || document.getElementById("wizzard.webde.pass").value == ""){
			ox.UINotifier.warn(_("Provide a valid E-Mail address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			
			function callMeBack(aid){
				var moreData = {"login":document.getElementById("wizzard.webde.user").value,
								"password":document.getElementById("wizzard.webde.pass").value,
								"crawler":"crawler.webde",
								"image": Self.image};
				saveContactSubscriptionData(name, fields, moreData);
			}
			if ((this.withMail === true && document.getElementById("wizzard.webde.import:2").checked)
                    || (this.withSub === true && document.getElementById("wizzard.webde.import:1").checked)) {
				var aid = createMailAccount(fields, data);
   				if (this.withSub === true && document.getElementById("wizzard.webde.import:1").checked ){
   					callMeBack(aid);
   				}
	    	} else if (document.getElementById("wizzard.webde.import:3").checked ){
				callMeBack();
			} 
		}		
	};
	this.getData = function (){
        var name = document.getElementById("wizzard.webde.user").value;
		var data = {
                "name": "Web de Mail " + getAccountName(name),
				"primary_address": document.getElementById("wizzard.webde.user").value,
				"unified_inbox_enabled":false,
				"mail_secure":true,
				"login": document.getElementById("wizzard.webde.user").value,
				"password": document.getElementById("wizzard.webde.pass").value,
				"transport_secure":false,
				"transport_server":wizard_webde_transport_service,
				"transport_port":wizard_webde_transport_service_port,
				"transport_credentials":false,
				"tree":false,
				"spam_handler":"NoSpamHandler"
			};					
			if (document.getElementById("wizzard.webde.connection:1").checked) {
				data["mail_protocol"]="imap";
				data["mail_server"]=wizard_webde_imap_server;
				data["mail_port"]=wizard_webde_imap_port;
			} else {
				data["personal"]=document.getElementById("wizzard.webde.user").value;
				data["mail_protocol"]="pop3";
				data["mail_server"]=wizard_webde_pop_server;
				data["mail_port"]=wizard_webde_pop_port;
				data["pop3_refresh_rate"]="15";
				data["pop3_expunge_on_quit"]=false;
				data["pop3_delete_write_through"]=false;
				data["pop3_storage"] = "mailaccount";
			}
		
		return data;
	};
}

/**
* ******************************* LINKEDIN MINITAB
* 
*/
function MiniTabLinkedin(){
	this.name = "linkedin";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardlinkedinMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.fields = [ "wizzard.linkedin.name", "wizzard.linkedin.oauth" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null){
			var ctable2 = newnode('table',{ minHeight: "5em", borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardlinkedinMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Linkedin account and use your Linkedin contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
            var ctable = createOAuthForm(this, "linkedin", {
                serviceId: "com.openexchange.socialplugin.linkedin",
                displayName: "Wizard LinkedIn"
            }).table;
            
			this.node = newnode("div",{ paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);
		//if (Self.image.className != "wizardlinkedinMiniOk") {
			Self.image.className = "wizardlinkedinMiniInactive";
		//}
	}
	this.saveData = function (someData){
		var fields = this.fields;
		var validError  = false;
		setWizardFieldsDisabled(fields, true);
		if (document.getElementById("wizzard.linkedin.name").value == ""){
			ox.UINotifier.warn(_("Provide a valid account name"));
			setWizardFieldsDisabled(fields, false);
		} else {			
			body.style.cursor="wait";
			var parentFolder;
	        ox.api.folder.get({
			     folder: getUrlEncodedString(configGetKey("folder.contacts")),
			     success: function (checkfolder){
				parentFolder = checkfolder;
				var data = { "title": "LinkedIn "+ document.getElementById("wizzard.linkedin.name").value,
				   		"module":"contacts",	
				   		"permissions": [{ bits: 403710016, // all admin
				   		                  entity: configGetKey("identifier"),
				   		                  group: false }],
				   		"subscribed":1 }
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
	    				var moreData = {"source":"com.openexchange.subscribe.socialplugin.linkedin",
	    								"folder":reply.data,
	    								"com.openexchange.subscribe.socialplugin.linkedin": someData,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data}}
	    				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
				    				ox.UINotifier.ok(_("Loading Data. This may take a while."));
	    							ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
							    			function(reply) {
				    							body.style.cursor="default";
							    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
							    				//Self.image.className = "wizardlinkedinMiniOk";
							    				ox.api.folder.refresh();
							    			},
						                    function(reply) {
							    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
							    				body.style.cursor="default";
							    				setWizardFieldsDisabled(fields, false);
							    				wizDeleteFolder(fid, timestamp);
						                    	return true;
						                    });
				    			},
			                    function(reply) {
				    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);
			                    	return true;
			                    });	
	    			},
                    function(reply) {
	    				ox.UINotifier.error(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			}});				
		}
	}
}

/**
* ******************************* XING MINITAB
* 
*/
function MiniTabXing(){
	this.name = "xing";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardxingMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.fields = [ "wizzard.xing.user", "wizzard.xing.pass", "wizzard.xing.save" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null){
			//#. %1$s is the product name
			//#, c-format
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardxingMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a Xing account and use your Xing contacts with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("Username"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.xing.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.xing.pass" })])]));			

			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.xing.save", id:"wizzard.xing.save", value: _("Save") }), _("Save"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.xing.save").disabled == false){
					Self.saveData();
				}
			});
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);
		//if (Self.image.className != "wizardxingMiniOk") {
			Self.image.className = "wizardxingMiniInactive";
		//}
	};
	
	this.saveData = function() {
		var name = this.name;
		var fields = this.fields;
		var moreData = {"login":document.getElementById("wizzard.xing.user").value,
						"password":document.getElementById("wizzard.xing.pass").value,
						"crawler":"xing",
						"image": Self.image};
		saveContactSubscriptionData(name, fields, moreData);
	};
}

/**
* ******************************* JES MINITAB
* 
*/
function MiniTabJES(){
	this.name = "jes";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardjesMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.fields = [ "wizzard.jes.user", "wizzard.jes.pass", "wizzard.jes.save" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null) {
			//#. %1$s is the product name
			//#, c-format
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {}, {className:"wizardjesMini",src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to a JES account and use your JES contacts, calendar and tasks with %1$s."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { minWidth: "100px", whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("Username"))]),
		                             		            newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.jes.user" })])]));
			ctbody.appendChild( newnode("tr", 0 , 0, [	newnode("td", { whiteSpace:"nowrap", paddingTop: "5px"} , 0, [addTranslated(_("Password"))]),
		                             		            newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"password", id:"wizzard.jes.pass" })])]));			

			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.jes.save", id:"wizzard.jes.save", value: _("Save") }), _("Save"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"} , 0, [save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.jes.save").disabled == false){
					Self.saveData();
				}
			});
			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);	
		}
		base.appendChild(this.node);		
		//if (Self.image.className != "wizardjesMiniOk") {
			Self.image.className = "wizardjesMiniInactive";
		//}
	};
	this.saveData = function (){
		var name = this.name;
		var validError  = false;
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		
		var moreData = {"login":document.getElementById("wizzard.jes.user").value,
						"password":document.getElementById("wizzard.jes.pass").value,
						"crawler":"crawler.suncontacts",
						"image": Self.image};
		saveContactSubscriptionData(name, fields, moreData);
		
		function JesCalendar() {
			body.style.cursor="wait";
			
	        ox.api.folder.get({
			    folder: getUrlEncodedString(configGetKey("folder.calendar")),
			    success: function (checkfolder){
				parentFolder = checkfolder;
				var timestamp = reply.timestamp;
				var fid = reply.data;
				var moreData = {"source":"com.openexchange.subscribe.crawler.suncalendar",
								"folder":1,
								"entityModule":"calendar",
								"entity": {"folder":getUrlEncodedString(configGetKey("folder.calendar"))},"com.openexchange.subscribe.crawler.suncalendar":{"login": document.getElementById("wizzard.jes.user").value,"password": document.getElementById("wizzard.jes.pass").value}};		    				
				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
		    			function(reply) {
    						ox.UINotifier.ok(_("Loading Data. This may take a while."));
    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
			    			
    						function(reply) {
    							body.style.cursor="default";
			    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));					    				
			    				//Self.image.className = "wizardjesMiniOk";
			    				document.getElementById("wizzard.jes.save").disabled = true;
			    				ox.api.folder.refresh();
			    			},
		                    function(reply) {
			    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
			    				body.style.cursor="default";
		                    	return true;
		                    });
		    			},
	                    function(reply) {
		    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
		    				body.style.cursor="default";
		    				setWizardFieldsDisabled(fields, false);
	                    	return true;
	                    });
			}});
		}
		/*JesCalendar(END)*/
		
		function JesTasks() {
			body.style.cursor="wait";
			
	        ox.api.folder.get({
			     folder: getUrlEncodedString(configGetKey("folder.tasks")),
			     success: function (checkfolder){
				parentFolder = checkfolder;					         			            
				var timestamp = reply.timestamp;
				var fid = reply.data;
				var moreData = {"source":"com.openexchange.subscribe.crawler.suntasks",
								"folder":parentFolder,
								"entityModule":"tasks",
								"entity": {"folder":getUrlEncodedString(configGetKey("folder.tasks"))},
								"com.openexchange.subscribe.crawler.suntasks":{"login": document.getElementById("wizzard.jes.user").value,"password": document.getElementById("wizzard.jes.pass").value}};		    				
				ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
		    			function(reply) {
    						ox.UINotifier.ok(_("Loading Data. This may take a while."));
    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
			    			
    						function(reply) {
    							body.style.cursor="default";
			    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));					    				
			    				//Self.image.className = "wizardjesMiniOk";
			    				document.getElementById("wizzard.jes.save").disabled = true;
			    				ox.api.folder.refresh();
			    			},
		                    function(reply) {
			    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
			    				body.style.cursor="default";
			    				setWizardFieldsDisabled(fields, false);
		                    	return true;
		                    });
		    			},
	                    function(reply) {
		    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
		    				body.style.cursor="default";
		    				setWizardFieldsDisabled(fields, false);
		    				//wizDeleteFolder(fid, timestamp);
	                    	return true;
	                    });
	
			}});
		}
		/*JesTasks(END)*/
		
	};
}

/**
* ******************************* OXMF MINITAB
* 
*/
function MiniTabOXMF(){
	this.name = "oxmf";
	this.position = 0;
	this.image = newnode("img", 0, {className: "wizardoxmfMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.node = null;
	this.fields = [ "wizzard.oxmf.url", "wizzard.oxmf.save" ];
	var Self = this;
	
	this.draw = function () {
		reDrawImageGrid();
		
		var base = document.getElementById("wizzardServicesTank");
		removeChildNodes(base);
		
		if (this.node == null) {
			//#. %1$s is the product name
			//#, c-format
			var ctable2 = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody2 = newnode('tbody');	
			ctbody2.appendChild( newnode("tr", 0 , 0, [
              	newnode("td", { verticalAlign: "top", paddingBottom: "1em", paddingTop: "0px"} , {colSpan: 2} , [ newnode("img", {paddingRight:"5px"}, {className: "wizardoxmfMini", src: getFullImgSrc(wizzardImages+"dummy.gif")})]),				
				newnode("td", { verticalAlign: "top", width:"100%", fontWeight:"bold", paddingTop: "0px"} , 0 , [ addTranslated(format(_("Subscribe to another %1$s publication. The contacts of this publication will be saved to a new %1$s folder."), oxProductInfo.product_name)) ])]));				
			ctable2.appendChild(ctbody2);
			
			var ctable = newnode('table',{borderCollapse:"collapse"},{ cellpadding:"0",cellspacing:"0"});
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [
			    newnode("td", { whiteSpace:"nowrap", paddingTop: "10px"} , 0, [addTranslated(_("URL"))]),
		        newnode("td", { paddingTop: "10px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.oxmf.url" })])]));
			
			var save = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name:"wizzard.oxmf.save", id:"wizzard.oxmf.save", value: _("Save") }), _("Save"));			
			ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td"),
			                                           newnode("td", { paddingLeft: "10px", paddingTop: "15px", paddingBottom: "15px"}, 0, [ save])]));

			addDOMEvent(save, "click", function() {
				if (document.getElementById("wizzard.oxmf.save").disabled == false){
					Self.saveData();
				}
			});

			ctable.appendChild(ctbody);
			this.node = newnode("div",{ width: "100%", paddingLeft: "50px", paddingTop: "15px" },0,[ctable2,ctable]);
		}
		base.appendChild(this.node);		
		//if (Self.image.className != "wizardoxmfMiniOk") {
			Self.image.className="wizardoxmfMiniInactive";
		//}
	};
	this.saveData = function (){
		var name = this.name;
		var validError  = false;
		var fields = this.fields;
		setWizardFieldsDisabled(fields, true);
		var url = document.getElementById("wizzard.oxmf.url").value;
        var title = /\/([^\/?]+)(\?.*)?$/.exec(url);
		if (!title){
			ox.UINotifier.warn(_("Provide a valid URL address and password."));
			setWizardFieldsDisabled(fields, false);
		} else {
			body.style.cursor="wait";
			
			//#. %s is the name of the OXMF publication
			//#, c-format
			title = "" + format(_("OXMF %s"), title[1]);
			
			var parentFolder;
	        ox.api.folder.get({
			     folder: getUrlEncodedString(configGetKey("folder.contacts")),
			     success: function (checkfolder){

				parentFolder = checkfolder;
				var data = { "title": title,
				   		"module":"contacts",	
                        "permissions": [{ bits: 403710016, // all admin
                                          entity: configGetKey("identifier"),
                                          group: false }],
				   		"subscribed":1 };
				ox.JSON.put(AjaxRoot + "/folders?action=new&session=" + session+ "&folder_id=" + getUrlEncodedString(configGetKey("folder.contacts")), data, 
	    			function(reply) {
						var timestamp = reply.timestamp;
						var fid = reply.data;
						var moreData = {"source":"com.openexchange.subscribe.microformats.contacts.http",
	    								"folder":reply.data,
	    								"entityModule":"contacts",
	    								"entity": {"folder":reply.data},
	    								"com.openexchange.subscribe.microformats.contacts.http":{"url": url}};
	    				
						ox.JSON.put(AjaxRoot + "/subscriptions?action=new&session=" + session, moreData, 
				    			function(reply) {
		    						ox.UINotifier.ok(_("Loading Data. This may take a while."));
		    						ox.JSON.get(AjaxRoot + "/subscriptions?action=refresh&id="+reply.data+"&session=" + session,
					    			
		    						function(reply) {
										body.style.cursor="default";
					    				ox.UINotifier.ok(reply.error ? formatError(reply) : _("The subscription has been saved. You can select further services or continue with the wizard by clicking the Next button."));
					    				//Self.image.className="wizardoxmfMiniOk";
					    				
					    				document.getElementById("wizzard.oxmf.save").disabled = true;
					    				ox.api.folder.refresh();
					    			},
				                    function(reply) {
					    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
					    				body.style.cursor="default";
					    				setWizardFieldsDisabled(fields, false);
					    				wizDeleteFolder(fid, timestamp);
				                    	return true;
				                    });
				    			},
			                    function(reply) {
				    				ox.UINotifier.error(reply.error ? formatError(reply) : _("Unable to create a new subscription."));
				    				body.style.cursor="default";
				    				setWizardFieldsDisabled(fields, false);
				    				wizDeleteFolder(fid, timestamp);
			                    	return true;
			                    });	
	    			},
                    function(reply) {
	    				ox.UINotifier.error(reply.error ? ((reply.error == "A duplicate folder exists in parent folder %1$s in context %2$s") ? _("You already subscribed to this account.") : formatError(reply) ) : _("Unable to create a new folder."));
	    				body.style.cursor="default";
	    				setWizardFieldsDisabled(fields, false);
                    	return true;
                    });	
			}});
		}
	};
}

function WiztabWelcome() {
	this.name = "welcome";	
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.headerImage = newnode("img", {padding: "5px", paddingBottom:"25px" }, {id: "wizzardStartImage", className: "wizzardStartImage", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.draw = function (wizzard) {
		var image = document.getElementById("wizzardStartImage");
		image.className = "wizzardStartImageActive";
		
		//#. %1$s is the product name
		//#, c-format
        var title = $("popup.wizzard.header").getElementsByTagName("span")[0];
        removeChildNodes(title);
        if (!this.title) {
            this.title = addTranslated(format(
                _("%1$s Wizard"), oxProductInfo.product_name));
        }
        title.appendChild(this.title);

		var header = document.getElementById("wizzardHeaderTitle");
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Instructions")));

		var base = document.getElementById("wizzardConten");
		removeChildNodes(base);
		
		//#. %1$s is the product name
		//#, c-format
		base.appendChild( newnode("div",{fontSize:"130%", fontWeight:"bold",paddingTop:"15px"},0,[ addTranslated(format(_("Welcome to %1$s."), oxProductInfo.product_name))] ));
		base.appendChild(newnode("br"));
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ id:"wizardStartTable", cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "0px"} , {colSpan:2}, [ addTranslated(_("This wizard will guide you through some basic settings around your account. You can access this wizard later by clicking on the respective entry in the help menu. Click Start if you want to start the wizard now. Click Close if you want to make the settings later.")) ])
        ]));
				
		var order = wizzard.getWizorder();		
		for (var cnt=0;cnt <order.length;cnt++){
			var tab = wizzard.getWiztabAtPosition(order[cnt]);
			if (tab.visible == true && tab.welcome_node != null){
				ctbody.appendChild(tab.welcome_node);
			}
		}
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "10px"} , {colSpan:2}, [ addTranslated(_("Press the start button to launch the wizard.")) ])
        ]));
		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		// back (disabled)
		$("popup.wizzard.back").disabled = true;
		$("popup.wizzard.back").style.display="none";
		// next = start
		$("popup.wizzard.next").value = _("Start");
		$("popup.wizzard.next").style.display="inline";
		// cancel
		$("popup.wizzard.closebutton").value = _("Close");

	};
	this.next = function (callback) {
		
		var image = document.getElementById("wizzardStartImage");
		image.className = "wizzardStartImage";
		
		$("popup.wizzard.back").disabled = false;
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").style.display="inline";
		callback();
	};
	this.previous = function (callback) {
		callback();
	};	
}

function WiztabPersonalData() {
	this.name = "personaldata";
	/* is this tab currently active, shown to the user*/
	this.enabled = false;
	/* is this even visible to the user*/
	this.visible = true;	
	/* the position on the wizzard */
	this.position = 0;
	/* has this tab been saved, is the configuration working*/
	this.errorOccured = false;		
	/* the user data object and the timestamp when we got it*/
	this.old_user_data = null;
	this.dataChanged = false;
	// the language selection drop down
	this.wiz_language;
	// the time zone selection drop down
	this.wiz_timezone;
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardUserImage", className: "wizzardUserImageInactive",src: getFullImgSrc(wizzardImages+"dummy.gif")});
	/* the small info node on the welcome page */
	this.welcome_node = newnode("tr", 0 , 0, [
	            		  newnode("td", {paddingTop: "15px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox wizzardUserImageMini", src: getFullImgSrc(wizzardImages+"dummy.gif")}) ]),
	            		  newnode("td", {width:"100%",paddingTop: "15px"} , 0, [ addTranslated(_("Complete your account information")) ])]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.closebutton").value = _("Close");
		
		setWizzardTitle(_("Complete your account information"));
		
		var header = document.getElementById("wizzardHeaderTitle");
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Personal Data")));
		
		var image = document.getElementById("wizzardUserImage");
		image.className = "wizzardUserImageActive";
		
		if (wizzard.firstrunmode && wizzard.firstrun) {
			this.loadData(true);
			this.placeData(new Object());
		} else {
			this.loadData();
		}
	};	
	this.next = function (callback) {
	    
		var image = document.getElementById("wizzardUserImage");
		image.className = "wizzardUserImage";
		
		if (this.dataChanged || wizzard.lockClose) {
			this.saveData(callback);
		} else {
			callback();
		}
	};
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardUserImage");
		image.className = "wizzardUserImageInactive";
		
		this.dataChanged = false;		
		callback();
	};
	this.loadData = function (loadOnly) {
        var Self = this;
        ox.JSON.get(AjaxRoot + "/user?action=get&id=" +
            configGetKey("identifier") + "&session=" + session,
            function (reply) {
            	Self.old_user_data = clone(reply.data);
            	Self.old_user_data.timestamp = reply.timestamp;
        		if (!loadOnly) Self.placeData(reply.data);
    		});
	};
	this.placeData = function(pdata) {
		var base = document.getElementById("wizzardConten");
		removeChildNodes(base);
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});
		var ctbody = newnode('tbody');
		
		var Self = this;
		
		// first name, last name
		ctbody.appendChild(newnode("tr", 0 , 0, [
            // first name
            newnode("td", { paddingTop: "20px", fontWeight: "bold" } , 0, [
                newnode("span", 0, 0, [addTranslated(_("First name"))]), /*i18n*/
                newnode("span", { color: "#800" }, 0, [newtext(" *")])
            ]),
            newnode("td", { paddingTop: "20px" } , 0, [
                newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id: "first_name", name: "first_name", value: (pdata.first_name != undefined) ? pdata.first_name : "" })
            ]),
            // last name
            newnode("td", { paddingTop: "20px", fontWeight: "bold" } , 0, [
                newnode("span", 0, 0, [addTranslated(_("Last name"))]), /*i18n*/
                newnode("span", { color: "#800" }, 0, [newtext(" *")])
            ]),
            newnode("td", { paddingTop: "20px"} , 0, [
                newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id: "last_name", name: "last_name", value: (pdata.last_name != undefined) ? pdata.last_name : "" })
            ])
        ]));

		// middle name, display name
		ctbody.appendChild(newnode("tr", 0 , 0, [
		    // middle name
		    newnode("td", { paddingTop: "6px" } , 0, [addTranslated(_("Middle name"))]), /*i18n*/
            newnode("td", { paddingTop: "5px" } , 0, [
                newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "second_name", value: (pdata.second_name != undefined) ? pdata.second_name : "" })
            ]),
            // display name
            newnode("td", { paddingTop: "6px", fontWeight: "bold" } , 0, [
                newnode("span", 0, 0, [addTranslated(_("Display name"))]), /*i18n*/
                newnode("span", { color: "#800" }, 0, [newtext(" *")])
            ]),
            newnode("td", { paddingTop: "5px" } , 0, [
                newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id: "display_name", name: "display_name", value: (pdata.display_name != undefined) ? pdata.display_name : "" })
            ])
        ]));
		
        var labels = { street: _("Street"), postal_code: _("ZIP"),
                       city: _("City"), state: _("State") };
        
		function FieldSet(suffix, paddings, labelFormat) {
            this.suffix = suffix;
            this.labelFormat = labelFormat;
            this.tds = [];
            for (var i = 0; i < paddings.length; i++) {
                this.tds.push({
                    label: newnode("td", { paddingTop: paddings[i] + "px" }),
                    input: newnode("td", { paddingTop: paddings[i] + "px" })
                });
            }
        }
        
        FieldSet.prototype.reorder = function(defs) {
            for (var i = 0; i < defs.length; i++) {
                var def = defs[i].split("/");
                var td = this.tds[i];
                removeChildNodes(td.label);
                removeChildNodes(td.input);
                var styles = def.length > 1 ?
                    [{ width:"4em", marginLeft: "10px", marginRight: "0.5em" },
                     { width:"9.5em", marginLeft: "-2px" }] :
                    [{ width: "14em", marginLeft: "10px" }];
                for (var j = 0; j < def.length; j++) {
                    if (j) td.label.appendChild(newtext(" / "));
                    td.label.appendChild(newtext(expectI18n(format(
                        this.labelFormat, labels[def[j]]))));
                    var name = def[j] + this.suffix;
                    td.input.appendChild(newnode("input", styles[j],
                        { type: "text", name: name,
                          value: pdata[name] || "" })); 
                }
            }
        };
        
        var home = new FieldSet("_home", [6, 6, 6], noI18n("%s"));
        var business = new FieldSet("_business", [20, 6, 6],
                                    _("%s (business)"));
        
        var company = {
            label: newnode("td", { paddingTop: "20px" }, 0,
                [addTranslated(_("Company"))]),
            input: newnode("td", { paddingTop: "20px" }, 0,
                [newnode("input", { width:"14em", marginLeft: "10px" },
                                  { type:"text", name: "company",
                                    value: pdata.company || "" })])
        };
        append(home.tds[0], home.tds[1]);
        append(home.tds[2]);
        append(company, business.tds[0]);
        append(business.tds[1], business.tds[2]);
        function append(l, r) {
            ctbody.appendChild(newnode("tr", 0, 0,
                r ? [ l.label, l.input, r.label, r.input]
                  : [ l.label, l.input]));
        }
        
        reorderFields();
        function reorderFields() {
    		//#. The address format for input fields.
            //#.
            //#. DO NOT TRANSLATE THE FIELD NAMES!
            //#.
            //#. Only change the order.
            //#. Comma (,) separates lines, slash (/) separates fields in a line.
    		var defs = _("street,postal_code/city,state").split(",");
    		home.reorder(defs);
    		business.reorder(defs);
        }
        
        if (this.langHandler) unregister("LanguageChanged", this.langHandler);
        this.langHandler = reorderFields;
        register("LanguageChanged", this.langHandler);
            
		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          
	                         		                 newnode("td", { paddingTop: "20px"} , 0, [addTranslated(_("Phone (business)"))]),
	                         		                 newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "telephone_business1", value: (pdata.telephone_business1 != undefined) ? pdata.telephone_business1 : "" })]),

                                		             newnode("td", { paddingTop: "20px"} , 0, [addTranslated(_("Fax (business)"))]),
                                		             newnode("td", { paddingTop: "20px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "fax_business", value: (pdata.fax_business != undefined) ? pdata.fax_business : "" })])
                                		                             
                                		             ]));	

		ctbody.appendChild( newnode("tr", 0 , 0, [

		                                          	 newnode("td", { paddingTop: "6px"} , 0, [addTranslated(_("Phone (private)"))]),
                                		             newnode("td", { paddingTop: "6px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "telephone_home1", value: (pdata.telephone_home1 != undefined) ? pdata.telephone_home1 : "" })]),

                                		             
                                                  	 newnode("td", { paddingTop: "6px"} , 0, [addTranslated(_("Mobile"))]),
                            		                 newnode("td", { paddingTop: "6px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", name: "cellular_telephone1", value: (pdata.cellular_telephone1 != undefined) ? pdata.cellular_telephone1 : "" })])
 
                            		                 
                            		                 ]));		
		
		// fake cb to prevent combobox translation 
		function cb_tmpLang(element) {
			return function() {
				return element;
			}
		}
		wiz_language = new ComboBox3(window, "wiz_language", "14em", 0, true, "WizLanguageChanged", 3);
		for(var i in corewindow.all_languages) {
            if (i) {
                wiz_language.addElement(noI18n(corewindow.all_languages[i]),
                    i, cb_tmpLang(corewindow.all_languages[i]));
            }
		}
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          	 newnode("td", { paddingTop: "30px"} , 0, [addTranslated(_("Language"))]),
		                                          	 newnode("td", { paddingTop: "30px", paddingLeft: "12px" } , 0, [ wiz_language.getDomNode() ]),

		                                          	 newnode("td", { paddingTop: "30px"} , 0, []),
		                                          	 newnode("td", { paddingTop: "30px"} , 0, [])

                         		                 ]));
		
		wiz_language.setKey(configGetKey("language"));
		wiz_language.onChange = function() {
			Self.dataChanged = true;
		}
		
		wiz_timezone = new ComboBox3(window, "wiz_timezone", "20em", 1, true, "WizTimezoneChanged", 8);
	    var timezones = configGetKey("availableTimeZones");
	    var tzarray = [];
	    for (var i in timezones) tzarray.push({key: i, value: timezones[i] });
	    tzarray.sort(function(a, b) {
	        return a.value < b.value ? -1 : a.value > b.value ? 1 : 0;
	    });
	    for(var i = 0; i < tzarray.length; i++) {
	    	wiz_timezone.addElement(noI18n(tzarray[i].value), tzarray[i].key);
	    }
		
		ctbody.appendChild(newnode("tr", 0 , 0, [
             newnode("td", { paddingTop: "6px"} , 0, [
                 addTranslated(_("Time zone")) /*i18n*/
             ]),
		     newnode("td",
		         { paddingTop: "6px", paddingLeft: "12px" },
		         { colSpan: "2" }, [
                 wiz_timezone.getDomNode()
             ]),
             newnode("td",
                 { paddingLeft: "12px" }, 0, [
                 newnode("span", { color: "#800" }, 0, [newtext("* ")]),
                 newnode("i", 0, 0, [addTranslated(_("mandatory field"))]) /*i18n*/
             ])
        ]));
			
		wiz_timezone.setKey(configGetKey("timezone"));
		wiz_timezone.onChange = function() {
			Self.dataChanged = true;
		}
		
		ctable.appendChild(ctbody);
		
		// adding change event to input field
		var inElems = ctbody.getElementsByTagName("input");
		for (var i in inElems) {
			inElems[i].onchange = function() {
				Self.dataChanged = true; 
			};
		}		
		
		base.appendChild(ctable);
	    base.appendChild(newnode("div", {height: "20px"}, 0));
	    
	    // convenience input helper for display name
	    var updateDisplayName = function() {
	    	if (!dnameChanged) {
	    		jQuery('#display_name').val( jQuery('#first_name').val() + " " + jQuery('#last_name').val() );
	    	}
	    }
	    
	    var dnameChanged = false;
	    addDOMEvent(document.getElementById("display_name"), "change", function() {
	    	dnameChanged = true;
	    });
	    
	    if (jQuery('#display_name').val() == "") {
	    	jQuery('#first_name').keyup(updateDisplayName);
	    	jQuery('#last_name').keyup(updateDisplayName);
	    }
	}; 
	this.saveData = function (callback) {
	    
	    // copy field data first
		var newData = {};
	    jQuery("#wizzardConten input").each(function () {
	        var node = jQuery(this);
	        newData[node.attr("name")] = jQuery.trim(node.val());
	    });
		OXContactMapping.createObject(newData);	

		// set language (contact field reorder function clears content)
	    setLanguage(wiz_language.getKey());
	    configSetKey("language", wiz_language.getKey());
	    configSetKey("timezone", wiz_timezone.getKey());

		var Self = this;
		var last_mod = this.old_user_data.timestamp;
		
		function getErrorMsg(reply) {
			if (reply.error == "You do not have permission to create objects in this folder %1$d in context %2$d with user %3$d") {
				return _("You do not have the necessary permissions to edit your own information.");
			} else {
				return formatError(reply);
			}
		}
		
		ox.JSON.put(AjaxRoot + "/user?action=update&session=" + session + "&id="+configGetKey("identifier")+"&timestamp="+last_mod, newData,
				function(reply) {					
					last_mod = reply.timestamp || last_mod;
					var cacheData = clone(newData);
					cacheData.timestamp = last_mod;
					Self.old_user_data = cacheData;
					Self.loadData(true);
					wizzard.lockClose = false;
					Self.dataChanged = false;
					$("popup.wizzard.hide").disabled = false;
					$("popup.wizzard.close").hidden = false;
					$("popup.wizzard.closebutton").hidden = false;
					
					// bug #19290
					if (ox.api.config.get("gui.wizard.firstrun") !== false) {
    					ox.api.config.set("gui.wizard.firstrun", false);
    					wizzard.firstrun = false;
    					configuration_changed_fields.gui = true;
    					triggerEvent("OX_Save_Configuration", false, true);
					}
					
					internalCache.updateUser();
					callback();
				}
		);
	};
}

function WiztabServices() {
	this.name = "services";
	this.template_name = "popup.wizzard.tab.mail";
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardServicesImage", className: "wizzardServicesImageInactive",src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.enabled = false;
	this.visible = true;
	this.position = 0;	
	this.minitabs = new Object();
	this.countTab = 0;
	this.withSub = false;
	this.enabledCrawler = new Object();
	this.enabledMailAccounts = "";
	this.enabledMessagingAccounts = "";
	this.deferred = jQuery.Deferred();
	
	//#. %1$s is the product name
	//#, c-format
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox wizzardServicesImageMini", src: getFullImgSrc(wizzardImages+"dummy.gif")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ addTranslated(format(_("Subscribe to your everyday web services and mail accounts and use them within %1$s"), oxProductInfo.product_name)) ])
	                                        ]);
	
	this.draw = function (wizzard) {
		wizzard.setWizzardBusy(true);
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.closebutton").value = _("Close");
		
		var Self = this;
		
		function drawServices (){
			var base = document.getElementById("wizzardConten");		
			removeChildNodes(base);
			
			var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
			var ctbody = newnode('tbody');	

			ctbody.appendChild( newnode("tr", 0 , 0, [   newnode("td", { width:"30%", verticalAlign:"top" } , { id: "wizzardImageTank"}, [ Self.drawTabGrid() ]),
	                		                             newnode("td", { width:"70%", verticalAlign:"top" } , { id: "wizzardServicesTank"} , [])]));
			
			ctable.appendChild(ctbody);
			base.appendChild(ctable);

			// now, the mini tabs and their container (i.e. "wizzardImageTank") are drawn
            if (Self.minitabs[0] != null) {
                    // draw/activate first tab
                    Self.minitabs[0].draw();
            }
		}
		
		setWizzardTitle(_("Subscribe services"));

		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Services")));
		
		var image = document.getElementById("wizzardServicesImage");		
		image.className = "wizzardServicesImageActive";

		this.deferred.then(function() {
			if (Self.countTab == 0){
				var GMail = { crawler: false, mail: false, calendar: false };
				var GMX = { crawler: false, mail: false };
				var Webde = { crawler: false, mail: false };
				var TOnline = { crawler: false, mail: false };
				var Yahoocom = { crawler: false, mail: false };
			
				function checkCrawlerOverride(name) {
					if (window.enabledCrawlerOverride === undefined)
						return true;
					if (enabledCrawlerOverride.search(name) != -1)
						return true;
					return false;
				};
				
				function checkMessagingOverride(name) {
					if (window.enabledMessagingOverride === undefined)
						return true;
					if (enabledMessagingOverride.search(name) != -1)
						return true;
					return false;
				}
				
				// loop subscription sources [mail first]
				for (var i in Self.enabledCrawler) {
                    var id = Self.enabledCrawler[i][0];
                    var name = Self.enabledCrawler[i][1];
					switch (id) {
						case "com.openexchange.subscribe.crawler.googlemail":
							if (checkCrawlerOverride(name))
								GMail.crawler = true;
							break;
						case "com.openexchange.subscribe.crawler.google.calendar":
							GMail.calendar = true;
							break;
						case "com.openexchange.subscribe.crawler.gmx":
							if (checkCrawlerOverride(name))
								GMX.crawler = true;
							break;
						case "com.openexchange.subscribe.crawler.webde":
							if (checkCrawlerOverride(name))
								Webde.crawler = true;
							break;
						case "com.openexchange.subscribe.crawler.t-online.de":
							if (checkCrawlerOverride(name))
								TOnline.crawler = true;
							break;
						case "com.openexchange.subscribe.crawler.yahoocom":
							if (checkCrawlerOverride(name))
								Yahoocom.crawler = true;
							break;
						case "com.openexchange.subscribe.socialplugin.yahoo":
						    if (checkCrawlerOverride(name)) {
						        Yahoocom.crawler = true;
						        Yahoocom.oauth = true;
						    }
						    break;
					}
				}
			
				if (Self.enabledMailAccounts.search(/GoogleMail/) != -1) GMail.mail=true;
				if (Self.enabledMailAccounts.search(/gmx.de/) != -1) GMX.mail=true;
				if (Self.enabledMailAccounts.search(/web.de/) != -1) Webde.mail=true;
				if (Self.enabledMailAccounts.search(/t-online.de/) != -1) TOnline.mail=true;
				if (Self.enabledMailAccounts.search(/yahoo.com/) != -1) Yahoocom.mail=true;
				
				if (GMail.mail || GMail.crawler)
					Self.addMiniTab(new MiniTabGmail(GMail));
				if (GMX.mail || GMX.crawler)
					Self.addMiniTab(new MiniTabGMX(GMX));
				if (Webde.mail || Webde.crawler)
					Self.addMiniTab(new MiniTabWebde(Webde));
				if (TOnline.mail || TOnline.crawler)
					Self.addMiniTab(new MiniTabTOnline(TOnline));
				if (Yahoocom.mail || Yahoocom.crawler)
					Self.addMiniTab(new MiniTabYahoo(Yahoocom));

				if (window.wizzardMailServices) {
					for (var id in window.wizzardMailServices) {
						Self.addMiniTab(new MiniTabGenericMail(id));
					}
				}
			
				var facebookMessaging = false;
				for (var i in Self.enabledMessagingAccounts) {
					var name = Self.enabledMessagingAccounts[i].displayName;
					switch (name) {
						case "Facebook":
							if (checkMessagingOverride(name))
								facebookMessaging = true;
							break;
						case "Twitter":
							if (checkMessagingOverride(name))
								Self.addMiniTab(new MiniTabTwitter());
							break;
					}
				}
			
				var facebookSubscription = false;
				// loop again [other sources]
				for (var i in Self.enabledCrawler) {
					var name = Self.enabledCrawler[i][1];
					switch (name) {
						case "Facebook":
							if (checkCrawlerOverride(name))
								facebookSubscription = true;
							break;
						case "Twitter":
							if (checkCrawlerOverride(name))
								Self.addMiniTab(new MiniTabTwitter());
							break;
						case "LinkedIn": 
							if (checkCrawlerOverride(name))
								Self.addMiniTab(new MiniTabLinkedin());
							break;
						case "OXMF Contacts":
							if (checkCrawlerOverride(name))
								Self.addMiniTab(new MiniTabOXMF());
							break;
						case "XING":
							if (checkCrawlerOverride(name))
								Self.addMiniTab(new MiniTabXing());
							break;										
						case "Windows Live / MSN":
							if (checkCrawlerOverride(name))
								Self.addMiniTab(new MiniTabMSN());
							break;
						case "Sun Contacts":
							if (checkCrawlerOverride(name))
								Self.addMiniTab(new MiniTabJES());
							break;
					}
				}
				if (facebookSubscription === true || facebookMessaging === true){
					Self.addMiniTab(new MiniTabFacebook(facebookMessaging,facebookSubscription));
				}
			}
		
			drawServices();
			wizzard.setWizzardBusy();
		});
	};
	this.addMiniTab = function (miniTab){
		this.minitabs[this.countTab] = miniTab;
		this.countTab++;
		addDOMEvent(miniTab.image, "click", (function (miniTab) { return function () {
			miniTab.draw();
		};}) (miniTab) );
	};
	this.drawTabGrid = function (){
		
		//#. %1$s is the product name
	    //#, c-format
		var imageTank = newnode('div', {width: "100%"}, 0); 
		imageTank.appendChild( newnode('div', {paddingTop: "15px", paddingBottom: "10px", width: "100%", fontWeight:"bold"}, 0, [addTranslated(format(_("%1$s can subscribe other web services. Select a service you want to use with %1$s."), oxProductInfo.product_name))]));		
		var factor = 4;
		for (var cnt=0; cnt < (this.countTab/factor); cnt++){					
			var base = newnode('div', {width: "100%", height: "100%"}, 0);			
			for (var cnt2 = cnt*factor; cnt2 < ((cnt*factor)+factor); cnt2++){
				if (this.minitabs[cnt2] != null){
					var cb = this.minitabs[cnt2];
					base.appendChild(cb.image);
					this.minitabs[cnt2].position = cnt2;
				}
			}
			imageTank.appendChild(base);
		}
		
		return imageTank;
	};
	this.next = function (callback) {
		var image = document.getElementById("wizzardServicesImage");		
		image.className = "wizzardServicesImage";
		callback();
	};
	this.previous = function (callback) {
		var image = document.getElementById("wizzardServicesImage");		
		image.className = "wizzardServicesImageInactive";
		callback();
	};	
}

function WiztabPublish() {
	this.name = "publish";
	this.template_name = "popup.wizzard.tab.mail";
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardPublishImage", className: "wizzardPublishImageInactive", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.node = null;
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox, wizzardPublishImageMini", src: getFullImgSrc(wizzardImages+"dummy.gif")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ addTranslated(_("Publish your contacts and share them with other people on the net")) ])
	                                        ]);
	
	this.draw = function (wizzard) {

		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.closebutton").value = _("Close");
		
		setWizzardTitle(_("Publish your contacts"));

		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Publications")));

		
		var plus = newnode("img", 0, {className: "wizardPluskMini", src: getFullImgSrc(wizzardImages+"dummy.gif")});
		
		var plustable = ctable = newnode('table',{borderCollapse:"collapse", width:"100%"},{ cellpadding:"0",cellspacing:"0"},[
		    newnode('tbody',0,0, [
                 newnode("tr", 0 , 0, [ 
	                newnode("td", { paddingTop:"15px", width:"100%", verticalAlign:"middle", fontWeight:"bold" } , {colSpan:"2"}, [ addTranslated(_("Contacts can be exchanged with other Internet users by publishing a contacts folder. The publish function provides a URL that can be sent by E-Mail.")) ])
	             ]),
		         newnode("tr", 0 , 0, [ 
		            newnode("td", { paddingTop:"15px", verticalAlign:"middle" } , 0, [plus]),
		            newnode("td", { paddingTop:"10px", width:"100%", verticalAlign:"middle" } , 0, [ addTranslated(_("Create a new publication")) ])
		         ])
		    ])]);

		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		ctbody.appendChild( newnode("tr", 0 , 0, [   newnode("td", { width:"30%", verticalAlign:"top" } , { id: "wizzardPublishImageTank"},[plustable]),
                		                             newnode("td", { width:"70%", verticalAlign:"top", paddingLeft:"35px" } , { id: "wizzardPublishServicesTank"} , [])
                		                             ]));		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		var initFolder = false;
		var Self = this;
		addDOMEvent(plus, "click", function() {						
			var newBase = document.getElementById("wizzardPublishServicesTank");
			removeChildNodes(newBase);
			if (initFolder == false ){
				/*
				newContactFolderTree = new cFolderTree(	$('folder_tree_info'),		
				function (ofolder){
					Self.drawSetup(ofolder.oxfolder.data.id,ofolder.oxfolder.data.title);
					Self.showFolderPopup();
				},
				false,
				oMainFolderTree.cache,
				optFolderState.getState('folder_tree_info'));
				newContactFolderTree.enabled_modules = {contacts:true};	
												
				newContactFolderTree.load();
				newContactFolderTree.setSaveConfiguration(optFolderState);
				
				*/
				ox.api.ui.selectFolder({
			    	type: "contacts",
			    	callback: function (data){
						Self.drawSetup(data.id,data.title);
						Self.showFolderPopup();
					},
			    	node: $('folder_tree_info')
			    });
				initFolder = true;
			}
			Self.showFolderPopup();
		});		
		
		var image = document.getElementById("wizzardPublishImage");		
		image.className = "wizzardPublishImageActive";

	};
	this.showFolderPopup = function(){
		if ($("TreeDialogImportForlder").style.display == "none"){
			centerPopupWindow($("TreeDialogImportForlder"));
			$("TreeDialogImportForlder").style.display = "block";
			$("TreeDialogImportForlder").style.top = "230px";
			$("TreeDialogImportForlder").style.left = "420px";
			$("TreeDialogImportForlder").style.zIndex = "25";			
		}else{
			$("TreeDialogImportForlder").style.display = "none";
		}
	};
	this.next = function (callback) {
		var image = document.getElementById("wizzardPublishImage");		
		image.className = "wizzardPublishImage";
		callback();
	};
	this.previous = function (callback) {
		var image = document.getElementById("wizzardPublishImage");		
		image.className = "wizzardPublishImageInactive";
		callback();
	};
	this.drawSetup = function (folderId, folderTitle){

		var base = document.getElementById("wizzardPublishServicesTank");
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody', 0, { id:"wizzard.publish.content"});	

		ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td", { paddingTop: "15px", paddingBottom: "15px"} , {colSpan: 2} , [ addTranslated(_("The site name will be the name of the publication. A template will be saved in your infostore folder with the given template name. You can change this template later whenever you want.")) ])]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
	                                               	 newnode("td", { paddingTop: "5px"} , 0, [addTranslated(_("Folder"))]),
	                             		             newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { id:"wizzard.publish.folder",value:folderTitle, name:folderId,type:"text",disabled:"disabled" })])]));
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
	                                               	 newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [addTranslated(_("Site name"))]),
	                             		             newnode("td", { width:"100%",paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { id:"wizzard.publish.site", type:"text" })])]));

		ctbody.appendChild( newnode("tr", 0 , 0, [
	                                               	 newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [addTranslated(_("Template name"))]),
	                             		             newnode("td", { paddingTop: "5px"} , 0, [newnode("input", { width:"14em", marginLeft: "10px" }, { type:"text", id:"wizzard.publish.template" })])]));
		
		ctbody.appendChild( newnode("tr", 0 , 0, [
		                                          newnode("td", {whiteSpace:"nowrap", paddingTop: "5px"} , {}, [ addTranslated(_("Add cipher code")) ]),
		                                          newnode("td", {paddingTop: "5px"} , {}, [ newnode("input", { marginLeft:"10px" }, { id:"wizzard.publish.cipher", type:"checkbox", checked:"false", defaultChecked:"defaultChecked", className:"noborder" }) ])
		                                        ]));

		
		
		var saveButton = wizButton(newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", name: _("Save"), value: _("Save publication") }), _("Save publication"));

		ctbody.appendChild( newnode("tr", 0 , 0, [ newnode("td", { paddingTop: "15px", paddingBottom: "15px"} , {colSpan: 2, id:"wizzard.publication.savebutton"} , [ saveButton ])]));
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		var Self = this;
		addDOMEvent(saveButton, "click", function() {	
			
			var folderId = document.getElementById("wizzard.publish.folder").name;
			var folderName = document.getElementById("wizzard.publish.folder").value;
			
			var site = document.getElementById("wizzard.publish.site").value;
			var template = document.getElementById("wizzard.publish.template").value;

			var cipher = (document.getElementById("wizzard.publish.cipher").checked == true ) ? true : false;
			
			
			if (site == null || template == null) {
				ox.UINotifier.warn(_("Please provide a site name and a template name."));
			} else {
				var data = { "target":"com.openexchange.publish.microformats.contacts.online",
						"entityModule":"contacts",
						"entity":{"folder":folderId},
						"com.openexchange.publish.microformats.contacts.online":{"siteName":site,"template":template,
						"protected": cipher,
						"url":""}};
					
				ox.JSON.put(AjaxRoot + "/publications?action=new&session=" + session, data,
					function(reply){							
						var url = "";
						if (reply.data != null){													
							ox.JSON.get(AjaxRoot + "/publications?action=get&id="+reply.data+"&session=" + session,
						            function(reply) {
										// do we already hav a protocol? if not add it!
										if (!reply.data["com.openexchange.publish.microformats.contacts.online"].url.match(/^http/)) {
											url = "http://"+window.location.host;
										}
										url += reply.data["com.openexchange.publish.microformats.contacts.online"].url;
										
										document.getElementById("wizzard.publication.savebutton").style.display="none";	
										var newBase = document.getElementById("wizzard.publish.content");
										
										newBase.appendChild( newnode("tr", 0 , 0, [
                                           	 newnode("td", { whiteSpace:"nowrap",paddingTop: "5px"} , 0, [addTranslated(_("URL"))]),
                         		             newnode("td", { width:"100%",paddingTop: "5px",paddingLeft:"15px"} , 0, [newnode("a",0,{ href: url, target: "_blank"}, [ addTranslated(reply.data["com.openexchange.publish.microformats.contacts.online"].url)])])]));										

										
										newBase.appendChild( newnode("tr", 0 , 0, [newnode("td", { width:"100%",paddingTop: "30px", fontStyle:"italic"} , {colSpan: 2}, [addTranslated(_("You can create additional publications by clicking the plus icon again."))])]));
				
									},
						            function(error) {
						            	return true;
						            });	
						}
						ox.UINotifier.ok((reply.error != null) ? formatError(reply) : (_("This publication has been saved.")));
						triggerEvent("OX_Refresh");
					}, function(reply){
						
						if (reply.error.indexOf("has already been taken (Field") != -1 ){
							ox.UINotifier.error(_("A publication with this name already exists."));
						} else if (reply.error.indexOf("You do not have the permissions to undertake the chosen action") != -1){
							ox.UINotifier.error(_("You do not have the permissions to publish this folder."));	
						} else if (reply.error != null){
							ox.UINotifier.error(formatError(reply));
						} else {
							ox.UINotifier.error(_("An unknown error occurred."));
						};
					}
				);
			}
			
		});
	
	};
}


function WiztabMobile() {
	this.name = "mobile";
	this.template_name = "popup.wizzard.tab.mail";	
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardMobileImage", className: "wizzardMobileImageInactive", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.node = null;
	
	//#. %1$s is the product name
	//#, c-format
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox wizzardMobileImageMini", src: getFullImgSrc(wizzardImages+"dummy.gif")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ addTranslated(format(_("Configure your handheld device to synchronize it with %1$s"), oxProductInfo.product_name)) ])
	                                        ]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.closebutton").value = _("Close");
		
		setWizzardTitle(_("Configure your handheld"));

		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Handhelds and mobile devices")));
		
		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
			
		//var ms_link = "[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/docs/OX6-OXtender-for-Business-Mobility-[language].pdf";
		function ms_openDocument(link) {
			var ms_language = (configGetKey("language") || "en_US").split("_");
			var ms_object = { 
					language:  
						(function() {
							switch(ms_language[0]) {
    							case "de": return "German";
    	                        case "fr": return "French";
    	                        case "nl": return "Dutch";
    	                        case "es": 
    	                        	if (ms_language[1] == "MX")
    	                        		return "Mexican_Spanish";
    	                        	else
    	                        	    return "Spanish";
    	                        case "ja": return "Japanese";
    	                        case "pl": return "Polish";
    	                        case "it": return "Italian";
    	                        default  : return "English";
							}
						})()
			};
			return link.format(ms_object);
		}

		var nokias60_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-nokias60-[language].html");
		var nokias60 = newnode("span", { } , { className:"linkstyle" }, [ addTranslated(_("Nokia Symbian S60 (N97, E51)")) ]);
		
		var winmobile_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-winmobile-[language].html");
		var winmobile = newnode("span", { } , { className:"linkstyle" }, [ addTranslated(_("Windows Mobile 6, 6.1, 6.5")) ]);
						
		var iphone_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-iphone-[language].html");
		var iphone = newnode("span", { } , { className:"linkstyle" }, [ addTranslated(_("Apple iPhone")) ]);
		
		var blackberry_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-blackberry-[language].html");
		var blackberry = newnode("span", { } , { className:"linkstyle" }, [ addTranslated(_("BlackBerry")) ]);

		var winphone7_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-winphone7-[language].html");
		var winphone7 = newnode("span", { } , { className:"linkstyle" }, [ addTranslated(_("Windows Phone 7")) ]);

		var android2_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/html/ox6-android2-[language].html");
		var android2 = newnode("span", { } , { className:"linkstyle" }, [ addTranslated(_("Android 2")) ]);

		var doc_all_link = ms_openDocument("[protocol]://[hostname][path]plugins/com.openexchange.usm.eas/docs/OX6-OXtender-for-Business-Mobility-[language].pdf");
		var doc_all = newnode("a", { } , { className:"linkstyle", href: doc_all_link, target: "_blank" }, [ addTranslated(_("Download all manuals as PDF")) ]);
		
		//var mobilityiFrame = newnode("iframe", { width:"100%", height: "305px" }, { scrolling: "auto", frameBorder: "0", src: winmobile_link, id: "mobilityiFrame", name: "mobilityiFrame" });
		var mobilityiFrame = newnode("div", { width:"98%", height: "100%", overflow: "auto", padding: "5px" }, { id: "mobilityiFrame", className:"iFrameWindow", name: "mobilityiFrame" });
		
		//#. %1$s is the product name
		//#, c-format
		var mobilityBase = newnode("td", { width:"100%", verticalAlign:"middle", fontWeight:"bold" } , {colSpan:2}, [ addTranslated(format(_("You can use your mobile device with %1$s. The following devices are supported."), oxProductInfo.product_name))]);
		
		var plustable = newnode('tbody',0,0, [ newnode("tr", 0 , 0, [ mobilityBase ])]);
	    var plust = newnode('table',{ borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"},[plustable]);
		
		function replaceText() {
			if (window.mobilityHost == undefined)
				var mobilityHost = location.host;
			else
				var mobilityHost = window.mobilityHost;
			jQuery(".sect1 span.guimenu:contains(OX_DOMAINNAME)").text(mobilityHost);
			ox.api.user.get(function(user) {
				jQuery(".sect1 span.guimenu:contains(OX_LOGINNAME)").text(user.login_info + "@" + mobilityHost);
		    });
		}
		function drawLink(link){
			jQuery(mobilityiFrame).empty().load(link, function() {
				replaceText();	
			});		
		}
		
		if (wizzardMobilityNokia){
			plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"15px", width:"100%", verticalAlign:"middle" } ,{colSpan:"2",className:"linkstyle"}, [ nokias60 ] )]));    
			addDOMEvent(nokias60, "click", function() {	drawLink(nokias60_link); });
		}
		if (wizzardMobilityWindowsMobile){
			plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ winmobile ] )]));    
			addDOMEvent(winmobile, "click", function() { drawLink(winmobile_link); });
		}
		if (wizzardMobilityiPhone){
			plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ iphone ])]));    
			addDOMEvent(iphone, "click", function() { drawLink(iphone_link); });
		}
		if (wizzardMobilityBlackBerry){
			plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ blackberry ])]));    
			addDOMEvent(blackberry, "click", function() { drawLink(blackberry_link); });
		}
		if (wizzardMobilityWinPhone7){
			plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ winphone7 ])]));    
			addDOMEvent(winphone7, "click", function() { drawLink(winphone7_link); });
		}
		if (wizzardMobilityAndroid2){
			plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ android2 ])]));    
			addDOMEvent(android2, "click", function() { drawLink(android2_link); });
		}
		
		plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", paddingTop:"4px", width:"100%", verticalAlign:"middle" } , {colSpan:"2",className:"linkstyle"}, [ doc_all ])]));
		
		//var customArea;
		//if (window.mobilityCustomArea != undefined)
		//	customArea = newnode("span");
		//plustable.appendChild(newnode("tr", 0 , 0, [newnode("td", { paddingLeft:"5px", width:"100%", height: "100px", verticalAlign:"bottom" } , {colSpan:"2"}, [ customArea ])]));
	       		
		var ctable = newnode('table',{ marginTop:"15px", borderCollapse:"collapse",width:"100%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		ctbody.appendChild( newnode("tr", 0 , 0, [  newnode("td", { width:"30%", verticalAlign:"top" } , { id: "wizzardPublishImageTank"},[plust]),
		                                            newnode("td", { height:"305px", width:"70%", verticalAlign:"top" } , { id: "wizzardServicesTank" } , [ mobilityiFrame ])
                		                         ]));		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
		var image = document.getElementById("wizzardMobileImage");		
		image.className = "wizzardMobileImageActive";
		
	};
	this.next = function (callback) {
		var image = document.getElementById("wizzardMobileImage");		
		image.className = "wizzardMobileImage";
		callback();
	};
	this.previous = function (callback) {
		var image = document.getElementById("wizzardMobileImage");		
		image.className = "wizzardMobileImageInactive";
		callback();
	};	
}

function WiztabUpsale() {
	this.name = "upsell";
	this.template_name = "popup.wizzard.tab.mail";
	this.headerImage = newnode("img", {padding: "5px"}, {id: "wizzardUpsellImage", className: "wizzardUpsellImageInactive", src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.enabled = false;
	this.visible = true;
	this.position = 0;	
	this.minitabs = new Object();
	this.countTab = 0;
	this.withSub = false;
	this.welcome_node = newnode("tr", 0 , 0, [
	                                          newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [ newnode("img", 0, {className: "wizzardGridBox wizzardUpsellImageMini", src: getFullImgSrc(wizzardImages+"dummy.gif")}) ]),
	                                          newnode("td", {paddingTop: "5px"} , 0, [ addTranslated(_("Additional services")) ])
	                                        ]);
	
	this.draw = function (wizzard) {
		
		$("popup.wizzard.next").value = _("Next");
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.closebutton").value = _("Close");
		
		setWizzardTitle(_("Upsell option"));

		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Additional services")));
		
		var image = document.getElementById("wizzardUpsellImage");		
		image.className = "wizzardUpsellImageActive";
		
		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"100%", marginTop:"15px"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	


		ctbody.appendChild( newnode("tr", 0 , 0, [   newnode("td", { width:"30%", verticalAlign:"top", fontWeight:"bold" } , {colSpan:2}, [ addTranslated(_("Enhance your feature set with the add-ons available on this page. Click one of the icons to get further information.")) ]), 
                		                             newnode("td", { height:"320px", width:"70%", verticalAlign:"top" } , { id: "wizzardServicesTank", className:"iFrameWindow" } , [ newnode("iframe", { width:"510px", height: "300px" }, { scrolling: "auto", frameBorder: "0", src: wizardUpsellLayerTabUrl, id: "upselliFrame"}) ])]));
    		                              
                		                              
		ctable.appendChild(ctbody);
		base.appendChild(ctable);
		
	};
	this.addMiniTab = function (miniTab){
		this.minitabs[this.countTab] = miniTab;
		this.countTab++;
	};
	this.next = function (callback) {
		var image = document.getElementById("wizzardUpsellImage");		
		image.className = "wizzardUpsellImage";
		callback();
	};
	this.previous = function (callback) {
		var image = document.getElementById("wizzardUpsellImage");		
		image.className = "wizzardUpsellImageInactive";
		callback();
	};	
}


function WiztabDone() {
	this.name = "done";
	this.template_name = "popup.wizzard.tab.finish";
	this.enabled = false;
	this.visible = true;	
	this.position = 0;
	this.headerImage = newnode("img", {padding: "5px", paddingBottom:"25px" }, {id: "wizzardEndImage", className: "wizzardEndImage",src: getFullImgSrc(wizzardImages+"dummy.gif")});
	this.draw = function (wizzard) {	
		$("popup.wizzard.back").value = _("Previous");
		$("popup.wizzard.next").style.display = "none";
		$("popup.wizzard.closebutton").value = _("Close");
		$("popup.wizzard.closebutton").style.color = "";
		
		setWizzardTitle(_("Wizard"));
		
		var image = document.getElementById("wizzardEndImage");		
		image.className = "wizzardEndImageActive";
		
		var header = document.getElementById("wizzardHeaderTitle");		
		removeChildNodes(header);
		header.appendChild(addTranslated(_("Finish")));

		var base = document.getElementById("wizzardConten");		
		removeChildNodes(base);
		
        var hideWizard = configContainsKey("gui.wizard.launchOnStart") &&
            !configGetKey("gui.wizard.launchOnStart");
        var check_box = newnode("input", { paddingLeft:"15px", paddingRight:"5px" }, { id:"wizzard.done.checkclose", type:"checkbox", checked: hideWizard, className:"noborder" });
		
		base.appendChild(newnode("br"));
		
		var ctable = newnode('table',{borderCollapse:"collapse",width:"80%"},{ cellpadding:"0",cellspacing:"0"});		
		var ctbody = newnode('tbody');	
		
		//#. %1$s is the product name
		//#, c-format
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "0px"} , {colSpan:2}, [ addTranslated(format(_("You have successfully completed the %1$s Wizard. You can launch the wizard anytime by clicking on the respective entry in the help menu."), oxProductInfo.product_name)) ])
        ]));
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "15px"} , {}, [ check_box ]),
          newnode("td", {paddingTop: "15px", width:"100%", fontWeight:"bold"} , {}, [ addTranslated(_("Do not show this wizard again")) ])
        ]));
		
		//#. %1$s is the product name
		//#, c-format
		ctbody.appendChild( newnode("tr", 0 , 0, [
          newnode("td", {paddingTop: "15px"} , {colSpan:2}, [ addTranslated(format(_("Thank You for using %1$s."), oxProductInfo.product_name)) ])
        ]));
		
		ctable.appendChild(ctbody);
		base.appendChild(ctable);

		
		addDOMEvent(check_box, "click", function() {
            $("popup.wizzard.hide").checked = check_box.checked;
			if (check_box.checked == true){
				configSetKey("gui.wizard.launchOnStart", false);
			} else {
				configSetKey("gui.wizard.launchOnStart", true);
			}
			triggerEvent("OX_Save_Configuration",true,false);
		});		
		
	};
	this.next = function (callback) {	
		$("popup.wizzard.next").style.display = "inline";
		
		callback();
	};
	this.previous = function (callback) {
		
		var image = document.getElementById("wizzardEndImage");		
		image.className = "wizzardEndImage";
		
		$("popup.wizzard.closebutton").value = _("Close");
		$("popup.wizzard.next").style.display = "inline";
		callback();
	};	
}

/**
 * 
 * The Main Wizzard
 * 
 */

function plugin_wizzard_init(tab, single) {

	wizzard = new Wizzard();
	wizzard.addWiztab(new WiztabWelcome());
	wizzard.addWiztab(new WiztabPersonalData());
	wizzard.addWiztab(new WiztabServices());
	wizzard.addWiztab(new WiztabPublish());
	wizzard.addWiztab(new WiztabMobile());
	wizzard.addWiztab(new WiztabUpsale());

	if (configContainsKey("gui.wizard.firstrun")) {
		wizzard.firstrun = configGetKey("gui.wizard.firstrun");
	}
	
	var tabs = temporary.services.getProviders("com.openexchange.wizard");
	for (var i = 0; i < tabs.length; i++) wizzard.addWiztab(tabs[i]);
	    
	wizzard.addWiztab(new WiztabDone());
	wizzard.initWizzard(single);
	
	if (!configContainsKey("gui.wizard.launchOnStart")) {
		if (configGetKey("ui.wizard.launchOnStart")) {
			configSetKey("gui.wizard.launchOnStart",
					configGetKey("ui.wizard.launchOnStartDefault"));
		} else {
			configSetKey("gui.wizard.launchOnStart", false);
		}
	}
	
	$("popup.wizzard.hide").checked =
	    configContainsKey("gui.wizard.launchOnStart") &&
        !configGetKey("gui.wizard.launchOnStart");
	
	ox.api.setModal(true);
	$("modal-dialog").appendChild($("popup_wizzard"));
//	showNode("disable_background_window");
//	$("disable_background_window").style.display="block";
//	$("disable_background_window").appendChild($("popup.wizzard"));

	var calledTab = wizzard.getWiztab(tab);
	if (calledTab != undefined) 
		wizzard.selectWiztab(calledTab);
	
	if (single == true) {
		$("popup.wizzard.next").style.display="none";
		$("popup.wizzard.back").style.display="none";
		$("popup.wizzard.hidediv").style.display="none";
		$("popup.wizzard.closebutton").value = _("Finish");
	} else {
		// defaults
		$("popup.wizzard.next").style.display="inline";
		$("popup.wizzard.back").style.display="inline";
		$("popup.wizzard.back").disabled=false;
		$("popup.wizzard.hidediv").style.display="inline";
		$("popup.wizzard.closebutton").value = _("Cancel");
	}
	wizzard.drawActiveTab();
	
	showNode("popup_wizzard");
	setTimeout(function() { 
		centerPopupWindow($("popup_wizzard"));
		$("popup_wizzard").style.display="block";
		$("popup_wizzard").style.width="820px";
		$("popup_wizzard").style.height="540px";
	}, 0);
	
	/* 
	 * register events for required actions
	 * e.g. next or back button, close ...
	 */
	register("OX_Wizard_Close", plugin_wizzard_close);
	register("OX_Wizard_Next", plugin_wizzard_next);
	register("OX_Wizard_Back", plugin_wizzard_previous);
}

function plugin_wizzard_close() {
	if (wizzard.lockClose) {
		ox.UINotifier.warn(_("Finishing this page is mandatory."));
		return;
	}
	$("popup_wizzard").style.display="none";
//	hideNode("disable_background_window");
//	$("disable_background_window").style.display="none";
	ox.api.setModal(false);
	configSetKey("gui.wizard.firstrun", false);	
	
	// unregister events
	unregister("OX_Wizard_Close", plugin_wizzard_close);
	unregister("OX_Wizard_Next", plugin_wizzard_next);
	unregister("OX_Wizard_Back", plugin_wizzard_previous);
	
	// fire closed event
	triggerEvent("OX_WIZARD_CLOSED");
	
    // update temporary stored display name #19649
    if (config.identifier) {
        var changeCb = function(resp) {
            myfullname = resp[config.identifier].display_name;
            internalCache.unregisterUpdate(changeCb);
        }
        internalCache.registerUpdate(changeCb);
        internalCache.updateUser();
    }
}

function plugin_wizzard_next() {
	wizzard.getActiveWiztab().next(function(error) {
		if (error == null){
			wizzard.selectNextTab();
		} else {
			ox.UINotifier.error(error);
		}
	});
}

function plugin_wizzard_previous() {
	var error = wizzard.getActiveWiztab().previous( function(error) {
		if (error == null) {
			wizzard.selectPreviousTab();
		} else {
			var base = document.getElementById("wizzardErrorBox");		
			base.appendChild( addTranslated(error) );
			base.style.display = "block";
		}
	});
}
function setWizzardTitle(title) {
	var title = new I18nNode(title);
	removeChildNodes($("popup.wizzard.header").getElementsByTagName("span")[0]);
	$("popup.wizzard.header").getElementsByTagName("span")[0].appendChild(title.node);
}

function reDrawImageGrid() {
	var at = wizzard.getActiveWiztab();
	for (var i = 0; i < at.countTab; i++){
		if (at.minitabs[i].image.className == "wizardgenericMailMini") {
			var x = at.minitabs[i].image.src;
			at.minitabs[i].image.src = x.replace(/o.png/g,"d.png");
		}
		if (at.minitabs[i].image.className.lastIndexOf("Inactive") != -1){
			var x = at.minitabs[i].image.className;
			at.minitabs[i].image.className = x.replace(/Inactive/g,"");
		}
	}
}

function wizDeleteFolder(fid, timestamp){
	json.put(AjaxRoot + "/folders?action=delete&session=" + session+"&timestamp=" + timestamp,[fid],null,function (arg){
	});
}

function wizDeleteMailAccount(id) {
    
	if (id && id >= 0){
	    ox.api.account.remove({
	        data: id
	    });
	}
}

function wizButton(button, text){
	register("LanguageChanged", function(){
		button.value = expectI18n(text);
	});
	
	var node = newnode("div",{flt:"left"},{ className:"fakeButton background-color-default cursorPointer whiteground"},[newnode("div",{},{className:"fakeButtonBottom"},[newnode("div",{},{className:"fakeButtonLeft"},[newnode("div",{},{className:"fakeButtonRight"},[
	newnode("div",{},{className:"fakeButtonTopLeft"},[newnode("div",{},{className:"fakeButtonTopRight"},[newnode("div",{},{className:"fakeButtonBottomLeft"},[newnode("div",{},{className:"fakeButtonBottomRight"},[button])])])])
	])])])]);
	return node;
}


/**
 *  The Wizzard 
 *  The Wizzard is the main container with all tabs
 */

function Wizzard() {
	this.wiztabs = new Object();
	this.wizorder = new Array();
	this.selected = null;
	this.wizzardNode = null;
	this.activeError = "";
	this.firstrun = true;
	this.firstrunmode = false;
	this.lockClose = false;
	this.singleTab = false;
 }

Wizzard.prototype = {
	length : 0,
	addWiztab : function(wiztab) {
        var Self = this;
        var validTab = false;
        
        if (this.wiztabs[wiztab.name]) {
            wiztab.position = this.wiztabs[wiztab.name].position;
            this.wiztabs[wiztab.name] = wiztab;
            return;
        }
        
        var modules = configGetKey("availableModules");	 
        switch (wiztab.name) {
            case "services":
                if (!wizardTabServices) break;
                var join = new Join(function() { wiztab.deferred.resolve(); });
                var lock = join.add();
				for (var i in modules){	
					if (modules[i] == "com.openexchange.subscribe"){
						validTab = true;
						wiztab.withSub = true;
						ox.JSON.get(AjaxRoot + "/subscriptionSources/?action=all"
								+ "&columns=id,displayName,icon,module,formDescription&session=" + session,
							join.add(function(reply) {
								if (reply != null) {
									wiztab.enabledCrawler = reply.data;
								}
							}), join.alt()
						);
					}
					if (modules[i] == "mailaccount" && configGetKey("modules.mail.module") != null ){
						validTab = true;
						if (window.enabledMailAccountsOverride === undefined) {
							//wiztab.enabledMailAccounts = ox.api.config.get("ui.wizard.mailaccounts"), "");
							ox.JSON.get(AjaxRoot + "/config/ui/wizard/mailaccounts/?session=" + session,
								join.add(function(reply) {
									if (reply != null) {
										wiztab.enabledMailAccounts = reply.data;
									}
								}), join.alt()
							);
						} else {
							wiztab.enabledMailAccounts = enabledMailAccountsOverride;
						}
					}
					if (modules[i] == "messaging"){
						validTab = true;
						ox.JSON.get(AjaxRoot + "/messaging/service?action=all&session=" + session,
							join.add(function(reply) {
								if (reply != null) {
									wiztab.enabledMessagingAccounts = reply.data;
								}
							}), join.alt()
						);
					}
				}
				lock();
                break;
            case "publish":
				if (!wizardTabPublish) break;
				for (var i in modules){
					if (modules[i] == "com.openexchange.publish"){
						validTab = true; 
					}
				}
                break;
            case "upsell":
                validTab = wizardTabUpsell;
                break;
            case "mobile":
                if (!wizardTabMobility) break;
                validTab = Boolean(configGetKey(["modules",
                    "com.openexchange.usm.eas", "active"]));
                break;
            case "personaldata":
                if (!wizardTabPersonalData) break;
                for (var i in modules) {              
                    if (modules[i] == "com.openexchange.user.personaldata") {
                        validTab = true;
                    }
                }
                break;
            default:
                validTab = true;
        }

        if (validTab){
            if (Self.length == 0) {
                wiztab.enabled = true;
				Self.selected = wiztab.name;
            }
            Self.wizorder.push(wiztab.name);
            wiztab.position=Self.length;
            Self.wiztabs[wiztab.name] = wiztab;
            Self.length++;
        }
    },
	selectWiztab : function(wiztab){
		this.unselectAllWiztabs();
		wiztab.enabled = true;
		this.selected = wiztab.name;
	},
	unselectAllWiztabs : function(){
		var Self = this;
		Self.selected = null;
		for (var i in Self.wiztabs)	{
		  if (Self.wiztabs[i].enabled == true)
			  Self.wiztabs[i].enabled = false;
		}
	},
	initWizzard : function (single){
		var Self = this;
		if (single == true) Self.singleTab=true;
		Self.firstrunmode = ox.api.config.get("ui.wizard.firstrunmode", false);
		if (Self.firstrunmode && Self.firstrun) {
			Self.lockClose = true;
			$("popup.wizzard.hide").disabled = true;
			$("popup.wizzard.close").hidden = true;
			$("popup.wizzard.closebutton").hidden = true;
		};
		removeChildNodes($("popup.wizzard.content"));
		if (null == this.wizzardNode) {	
			var template = $("popup.wizzard.tab.mail").cloneNode(true);
			template.appendChild(this.drawWiztabHeader());
			template.style.display="block";
			this.wizzardNode = template;
		}
		showNode(this.wizzardNode);
		$("popup.wizzard.content").appendChild(this.wizzardNode);
	},
	drawActiveTab : function (){
		this.getActiveWiztab().draw(this);
	},
	selectNextTab : function () {
		var currentPosition = this.getActiveWiztab().position;
		if (currentPosition == this.wizorder.length-1){
			plugin_wizzard_close();
		} else {
			this.selectWiztab(this.getWiztab(this.wizorder[(currentPosition+1)]));
			this.drawActiveTab();
		}
	},
	selectPreviousTab : function () {
		var currentPosition = this.getActiveWiztab().position;
		if (currentPosition > 0){
			this.selectWiztab(this.getWiztab(this.wizorder[(currentPosition-1)]));
			this.drawActiveTab();
		}
	},
	getWiztabAtPosition : function (pos){
		return this.wiztabs[pos];
	},
	getWizorder : function (){
		return this.wizorder;
	},
	getAllWiztabs : function (){
		return this.wiztabs;
	},
	getWiztab : function (wiztab) {
		return this.wiztabs[wiztab];
	},
	getActiveWiztab : function () {
		return this.wiztabs[this.selected];
	},
	drawWiztabHeader : function (){
		var base = newnode("div", { width: "100%", height: "100%",
		    background:"#ffffff", position: "relative" }, {id: "wiztabbase"});
		var iTank = newnode("div", {paddingTop: "10px"} , {id:"wizzardImageContainer"});
		var order = this.getWizorder();		
		for (var cnt=0;cnt <order.length;cnt++){
			var tab = this.getWiztabAtPosition(order[cnt]);
			if (tab.visible == true){
				iTank.appendChild(tab.headerImage);
				if (cnt != (order.length -1)){
					iTank.appendChild(newnode("img", {paddingTop: "35px"}, { className:"wizardArrowRight",src: getFullImgSrc(wizzardImages+"dummy.gif")}));
				}	
			}
		}
		
		base.appendChild( newnode("div", {paddingLeft: "20px"} , 0 , [iTank]));		
		base.appendChild( newnode("div", {paddingLeft: "20px",paddingRight: "20px"} , { id:"wizzardHeader"}, [ newnode("div", 0 , {className:"wizzardHeader", id:"wizzardHeaderTitle"} ), newnode("div", {display:"none"} , {className:"wizzardErrorBox",id: "wizzardErrorBox"})]));
		base.appendChild( newnode("div", {paddingLeft: "26px",paddingRight: "20px"} , 0, [ newnode("div", 0 , {id:"wizzardConten"} )]));

		return base;
	},
	setWizzardBusy : function (state) {
	    if (state == true){
	        jQuery("#modal-dialog-decorator").addClass("busy");
	        $("modal-dialog-decorator").style.zIndex = 21;
	    } else {
	        jQuery("#modal-dialog-decorator").removeClass("busy");
	        $("modal-dialog-decorator").style.zIndex = 19; //default
	    }
	}
};

function setWizardFieldsDisabled(fields, disabled) {
	$l = fields.length;
	for (var i=0; i < $l; i++) {
		if ($ALL(fields[i])) {
			$ALL(fields[i]).disabled = disabled;
		}
	}
}


function storeHTMLFile(node) {
	function getIDs(obj) {
		function recursive(obj) {
			for(var i=obj.firstChild; i!=null; i=i.nextSibling) {
				if(i.nodeType==1) { 
					idValue=i.id;
					if(idValue) { 
						if(allnodes[i.id]) {
							alert("Internal Error: ID \"" + i.id + "\" used multiple times!");
							allnodes[i.id] = "Duplicate ID";
						} else {
							allnodes[i.id]=i; 
						}
					}
					recursive(i);
				}
			}
		}
		if(obj.id) { allnodes[obj.id]=obj; } 
		recursive(obj);
	}
	var el=document.createElement("div");
	el.innerHTML=node;	
	getIDs(el);
}
/*
function loadJSFile(page) {
	if(debug) { debugJSLoad(page)}  
	else {
		jsarray[jsarray.length]=page;
		loadFile(page,jsload.add(storeJSFile),page);
	}
}
*/
function loadFile(page, cb, cb2) {
	var xmlhttp = JSON.prototype.getXmlHttp();
	function callback() {
		if (xmlhttp.readyState != 4) return;
		xmlhttp.onreadystatechange = emptyFunction; // fixes IE memory leak
		var s = xmlhttp.responseText;
		cb(s.replace(/#build\.version#/g, oxProductInfo.build));				
		cb2();
	}
	xmlhttp.onreadystatechange = callback;
	xmlhttp.open("GET",page, true);
	xmlhttp.send("");
}


function launchWizard(tab, single){
	loadFile(wizzardCSS, function (node) { 
		var d=newnode("style",null,{type : "text/css"},[]);
		if(!IE) {
			d.appendChild(document.createTextNode(node));
		} else {
			d.styleSheet.cssText = node;	
		}
		body.parentNode.getElementsByTagName("head")[0].appendChild(d);
		
	},  function () { });
	loadFile(wizzardTemplate, function (node) { storeHTMLFile(node); },  function () { 
		
//		addDOMEvent($("popup.wizzard.close"), "click", function() { plugin_wizzard_close(); });
//		addDOMEvent($("popup.wizzard.closebutton"), "click", plugin_wizzard_close);
//		addDOMEvent($("popup.wizzard.next"), "click", function() { plugin_wizzard_next(); });
//		addDOMEvent($("popup.wizzard.back"), "click", function() { plugin_wizzard_previous(); });
		
		var parent = $("popup_wizzard");
        addDOMEvent($("popup.wizzard.header"), "mousedown", function(e) {
            if (e.button != LeftButton) return;
            moving = parent;
            offsetX = parent.offsetLeft - e.clientX;
            offsetY = parent.offsetTop - e.clientY;
            parent.style.cursor = "move";
            function moveHandler(e) {
                var topposition=(e.clientY + offsetY);
                var leftposition=(e.clientX + offsetX);
                if(topposition<0) {
                    topposition=0;
                }
                else if(topposition+parent.offsetHeight > $("body").offsetHeight) {
                    topposition=$("body").offsetHeight-parent.offsetHeight;
                }
                if(leftposition<0) {
                    leftposition=0;
                }
                else if(leftposition+parent.offsetWidth > $("body").offsetWidth) {
                    leftposition=$("body").offsetWidth-parent.offsetWidth;
                }
                moving.style.left = leftposition + "px";
                moving.style.top = topposition + "px";
                stopEvent(e);
            }
            function upHandler(e) {
                if (moving && e.button == LeftButton) {
                    moving = null;
                    parent.style.cursor = "auto";
                    removeDOMEvent(body, "mousemove", moveHandler);
                    removeDOMEvent(body, "mouseup", upHandler);
                    //removeDOMEvent(body, "mouseout", upHandler);
                    stopEvent(e);
                }
            }
            addDOMEvent(body, "mousemove", moveHandler);
            addDOMEvent(body, "mouseup", upHandler);
            //addDOMEvent(body, "mouseout", upHandler);
            cancelDefault(e);
        });
		
		$("popup.wizzard.hidediv").appendChild(addTranslated(_("Do not show on start")));
		
		addDOMEvent($("popup.wizzard.hide"), "click", function() {
            var check = document.getElementById("wizzard.done.checkclose");
            if (check) check.checked = $("popup.wizzard.hide").checked;
			if ($("popup.wizzard.hide").checked == true){
				configSetKey("gui.wizard.launchOnStart", false);
			} else {
				configSetKey("gui.wizard.launchOnStart", true);
			}
			triggerEvent("OX_Save_Configuration",true,false);
		});
		
		loadFile(wizzardMailConfig, function (node) { 
			var d=newnode("script",null,{type : "text/javascript", text: node },[]);
			body.parentNode.getElementsByTagName("head")[0].appendChild(d);
		},  function () { });

		loadFile(wizzardConfig, function (node) { 
			var d=newnode("script",null,{type : "text/javascript", text: node },[]);
			body.parentNode.getElementsByTagName("head")[0].appendChild(d);
			plugin_wizzard_init(tab, single);
			
		},  function () { });
		
	});
}

return { load: launchWizard, show: plugin_wizzard_init };
