/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.cxf.common.logging.AbstractDelegatingLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
extends AbstractDelegatingLogger {
    private static final String FQCN = AbstractDelegatingLogger.class.getName();
    private final Logger logger;
    private LocationAwareLogger locationAwareLogger;

    public Slf4jLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.logger = LoggerFactory.getLogger((String)name);
        if (this.logger instanceof LocationAwareLogger) {
            this.locationAwareLogger = (LocationAwareLogger)this.logger;
        }
    }

    public Level getLevel() {
        Level level = this.logger.isTraceEnabled() ? Level.FINER : (this.logger.isDebugEnabled() ? Level.FINER : (this.logger.isInfoEnabled() ? Level.INFO : (this.logger.isWarnEnabled() ? Level.WARNING : (this.logger.isErrorEnabled() ? Level.SEVERE : Level.OFF))));
        return level;
    }

    protected void internalLogFormatted(String msg, LogRecord record) {
        Level level = record.getLevel();
        Throwable t = record.getThrown();
        if (Level.FINE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.INFO.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.info(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 20, msg, null, t);
            }
        } else if (Level.WARNING.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.warn(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 30, msg, null, t);
            }
        } else if (Level.FINER.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, msg, null, t);
            }
        } else if (Level.FINEST.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.trace(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 0, msg, null, t);
            }
        } else if (Level.ALL.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
            }
        } else if (Level.SEVERE.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.error(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
            }
        } else if (Level.CONFIG.equals(level)) {
            if (this.locationAwareLogger == null) {
                this.logger.debug(msg, t);
            } else {
                this.locationAwareLogger.log(null, FQCN, 10, msg, null, t);
            }
        } else if (Level.OFF.equals(level)) {
            // empty if block
        }
    }
}

