package org.javasimon.examples;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.javasimon.SimonManager;
import org.javasimon.StopwatchSample;
import org.javasimon.utils.BenchmarkUtils;
import org.javasimon.utils.GoogleChartImageGenerator;
import org.javasimon.utils.SimonUtils;

/**
 * Whatever.
 *
 * @author <a href="mailto:virgo47@gmail.com">Richard "Virgo" Richter</a>
 */
@SuppressWarnings("UnusedDeclaration")
public final class WhateverBenchmark {
	private static final int CALENDARS = 1000000;
	private static final int DATE_FORMATS = 1000000;
	private static final int PRINT_FORMAT = 1000000;

	private static final int SIMONS = 100000000;

	private WhateverBenchmark() {
	}

	/**
	 * Entry point of the demo application.
	 *
	 * @param args command line arguments
	 */
	public static void main(String[] args) {
		StopwatchSample[] results = BenchmarkUtils.run(2, 5,
			new BenchmarkUtils.Task("cal-" + CALENDARS) {
				@Override
				public void perform() throws Exception {
					for (int i = 0; i < CALENDARS; i++) {
						Calendar c = Calendar.getInstance();
					}
				}
			},
			new BenchmarkUtils.Task("sdf-" + DATE_FORMATS) {
				@Override
				public void perform() throws Exception {
					for (int i = 0; i < DATE_FORMATS; i++) {
						SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					}
				}
			},
			new BenchmarkUtils.Task("format-" + PRINT_FORMAT) {
				@Override
				public void perform() throws Exception {
					for (int i = 0; i < PRINT_FORMAT; i++) {
						String format = String.format("Whatever %d ", 55);
					}
				}
			},
			new BenchmarkUtils.Task("simon-" + SIMONS) {
				@Override
				public void perform() throws Exception {
					for (int i = 0; i < SIMONS; i++) {
//						SimonManager.getStopwatch("some.name").start().stop();
						boolean empty = SimonManager.callback().callbacks().isEmpty();
//						if (empty) {
//						}
					}
				}
			}
		);

		System.out.println("\nGoogle Chart avg:\n" + GoogleChartImageGenerator.barChart(
			results, "10M-loop duration", SimonUtils.NANOS_IN_MILLIS, "ms", false));
	}
}
