/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javasimon.console.ActionBinding;
import org.javasimon.console.ActionContext;
import org.javasimon.console.html.HtmlResource;
import org.javasimon.console.html.HtmlResourceType;
import org.javasimon.console.json.ObjectJS;
import org.javasimon.console.text.Stringifier;
import org.javasimon.console.text.StringifierFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimonConsolePlugin {
    private String id;
    private String label;
    private List<HtmlResource> resources = new ArrayList<HtmlResource>();

    protected SimonConsolePlugin(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Collection<ActionBinding> getActionBindings() {
        return Collections.emptyList();
    }

    public final void addResource(String path, HtmlResourceType type) {
        this.resources.add(new HtmlResource(path, type));
    }

    public final List<HtmlResource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public static List<HtmlResource> getResources(ActionContext context, Class<? extends SimonConsolePlugin> pluginType) {
        ArrayList<HtmlResource> resources = new ArrayList<HtmlResource>();
        for (SimonConsolePlugin simonConsolePlugin : context.getPluginManager().getPluginsByType(pluginType)) {
            resources.addAll(simonConsolePlugin.getResources());
        }
        return resources;
    }

    public final ObjectJS toJson(StringifierFactory jsonStringifierFactory) {
        ObjectJS pluginJS = new ObjectJS();
        Stringifier<String> stringStringifier = jsonStringifierFactory.getStringifier(String.class);
        pluginJS.setSimpleAttribute("id", this.getId(), stringStringifier);
        pluginJS.setSimpleAttribute("label", this.getLabel(), stringStringifier);
        pluginJS.setAttribute("resources", HtmlResource.toJson(this.getResources(), jsonStringifierFactory));
        return pluginJS;
    }
}

