/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;

public class InputChunked
extends Input {
    private int chunkSize = -1;

    public InputChunked() {
        super(2048);
    }

    public InputChunked(int n) {
        super(n);
    }

    public InputChunked(InputStream inputStream) {
        super(inputStream, 2048);
    }

    public InputChunked(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    public void setInputStream(InputStream inputStream) {
        super.setInputStream(inputStream);
        this.chunkSize = -1;
    }

    public void setBuffer(byte[] byArray, int n, int n2) {
        super.setBuffer(byArray, n, n2);
        this.chunkSize = -1;
    }

    public void rewind() {
        super.rewind();
        this.chunkSize = -1;
    }

    protected int fill(byte[] byArray, int n, int n2) throws KryoException {
        if (this.chunkSize == -1) {
            this.readChunkSize();
        } else if (this.chunkSize == 0) {
            return -1;
        }
        int n3 = super.fill(byArray, n, Math.min(this.chunkSize, n2));
        this.chunkSize -= n3;
        if (this.chunkSize == 0) {
            this.readChunkSize();
        }
        return n3;
    }

    private void readChunkSize() {
        try {
            InputStream inputStream = this.getInputStream();
            int n = 0;
            for (int i = 0; i < 32; i += 7) {
                int n2 = inputStream.read();
                if (n2 == -1) {
                    throw new KryoException("Buffer underflow.");
                }
                n |= (n2 & 0x7F) << i;
                if ((n2 & 0x80) != 0) continue;
                this.chunkSize = n;
                return;
            }
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
        throw new KryoException("Malformed integer.");
    }

    public void nextChunks() {
        if (this.chunkSize == -1) {
            this.readChunkSize();
        }
        while (this.chunkSize > 0) {
            this.skip(this.chunkSize);
        }
        this.chunkSize = -1;
    }
}

