/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.cluster.ClusterManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.base.SystemLogService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggingService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingServiceImpl
implements LoggingService {
    private final MemberImpl thisMember;
    private final SystemLogService systemLogService;
    private final String groupName;
    private final CopyOnWriteArrayList<LogListenerRegistration> lsListeners = new CopyOnWriteArrayList();
    private final String thisAddressString;
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private final LoggerFactory loggerFactory;
    private volatile Level minLevel = Level.OFF;

    public LoggingServiceImpl(SystemLogService systemLogService, String groupName, String loggingType, MemberImpl thisMember) {
        this.systemLogService = systemLogService;
        this.groupName = groupName;
        this.thisMember = thisMember;
        this.loggerFactory = Logger.newLoggerFactory(loggingType);
        this.thisAddressString = "[" + thisMember.getAddress().getHost() + "]:" + thisMember.getAddress().getPort();
    }

    @Override
    public ILogger getLogger(String name) {
        DefaultLogger newLogger;
        ILogger logger = (ILogger)this.mapLoggers.get(name);
        if (logger == null && (logger = this.mapLoggers.putIfAbsent(name, newLogger = new DefaultLogger(name))) == null) {
            logger = newLogger;
        }
        return logger;
    }

    @Override
    public void addLogListener(Level level, LogListener logListener) {
        this.lsListeners.add(new LogListenerRegistration(level, logListener));
        if (level.intValue() < this.minLevel.intValue()) {
            this.minLevel = level;
        }
    }

    @Override
    public void removeLogListener(LogListener logListener) {
        this.lsListeners.remove(new LogListenerRegistration(Level.ALL, logListener));
    }

    void handleLogEvent(LogEvent logEvent) {
        for (LogListenerRegistration logListenerRegistration : this.lsListeners) {
            if (logEvent.getLogRecord().getLevel().intValue() < logListenerRegistration.getLevel().intValue()) continue;
            logListenerRegistration.getLogListener().log(logEvent);
        }
    }

    class DefaultLogger
    implements ILogger {
        final String name;
        final ILogger logger;
        final boolean addToLoggingService;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = LoggingServiceImpl.this.loggerFactory.getLogger(name);
            this.addToLoggingService = name.equals(ClusterManager.class.getName());
        }

        @Override
        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            boolean loggable;
            if (this.addToLoggingService) {
                LoggingServiceImpl.this.systemLogService.logNode(String.valueOf(message) + (thrown == null ? "" : ": " + thrown.getMessage()));
            }
            if ((loggable = this.logger.isLoggable(level)) || level.intValue() >= LoggingServiceImpl.this.minLevel.intValue()) {
                message = String.valueOf(LoggingServiceImpl.this.thisAddressString) + " [" + LoggingServiceImpl.this.groupName + "] " + message;
                LogRecord logRecord = new LogRecord(level, message);
                logRecord.setThrown(thrown);
                logRecord.setLoggerName(this.name);
                logRecord.setSourceClassName(this.name);
                LogEvent logEvent = new LogEvent(logRecord, LoggingServiceImpl.this.groupName, LoggingServiceImpl.this.thisMember);
                if (loggable) {
                    this.logger.log(logEvent);
                }
                if (LoggingServiceImpl.this.lsListeners.size() > 0) {
                    LoggingServiceImpl.this.handleLogEvent(logEvent);
                }
            }
        }

        @Override
        public void log(LogEvent logEvent) {
            LoggingServiceImpl.this.handleLogEvent(logEvent);
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }

    class LogListenerRegistration {
        Level level;
        LogListener logListener;

        LogListenerRegistration(Level level, LogListener logListener) {
            this.level = level;
            this.logListener = logListener;
        }

        public Level getLevel() {
            return this.level;
        }

        public LogListener getLogListener() {
            return this.logListener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogListenerRegistration other = (LogListenerRegistration)obj;
            return !(this.logListener == null ? other.logListener != null : !this.logListener.equals(other.logListener));
        }
    }
}

