/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import javax.management.ObjectName;

@JMXDescription(value="A Entry in a Map")
public class MapEntryMBean
extends AbstractMBean<MapEntry> {
    private final IMap map;
    private final Object key;

    public static ObjectName buildObjectName(ObjectName mapName, Object key) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(mapName.getDomain()).append(':');
        sb.append(mapName.getKeyPropertyListString());
        sb.append(',');
        if (key instanceof String) {
            sb.append("key=").append(ObjectName.quote(key.toString()));
        } else {
            sb.append("name=").append(key.getClass().getName()).append('@').append(Integer.toHexString(key.hashCode()));
        }
        return new ObjectName(sb.toString());
    }

    public static ObjectName buildObjectNameFilter(ObjectName mapName) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(mapName.getDomain()).append(':');
        sb.append(mapName.getKeyPropertyListString());
        sb.append(',');
        sb.append("*");
        return new ObjectName(sb.toString());
    }

    public MapEntryMBean(IMap map, Object key) {
        super(map.getMapEntry(key), null);
        this.map = map;
        this.key = key;
    }

    @Override
    protected MapEntry refresh() {
        return this.map.getMapEntry(this.key);
    }

    @JMXAttribute(value="KeyClass")
    @JMXDescription(value="Class of the key")
    public Class<?> getKeyClass() {
        return this.key.getClass();
    }

    @JMXAttribute(value="ValueClass")
    @JMXDescription(value="Class of the value")
    public Class<?> getValueClass() {
        block4: {
            if (this.map.containsKey(this.key) || !this.mbeanServer.isRegistered(this.getObjectName())) break block4;
            this.mbeanServer.unregisterMBean(this.getObjectName());
            return null;
        }
        try {
            return this.map.get(this.key).getClass();
        }
        catch (Exception cnfe) {
            return String.class;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @JMXAttribute(value="Cost")
    @JMXDescription(value="Cost")
    public long getCost() {
        return ((MapEntry)this.getManagedObject()).getCost();
    }

    @JMXAttribute(value="CreationTime")
    @JMXDescription(value="Creation time")
    long getCreationTime() {
        return ((MapEntry)this.getManagedObject()).getCreationTime();
    }

    @JMXAttribute(value="ExpirationTime")
    @JMXDescription(value="Expiration time")
    long getExpirationTime() {
        return ((MapEntry)this.getManagedObject()).getExpirationTime();
    }

    @JMXAttribute(value="Hits")
    @JMXDescription(value="Hits")
    int getHits() {
        return ((MapEntry)this.getManagedObject()).getHits();
    }

    @JMXAttribute(value="LastAccessTime")
    @JMXDescription(value="Last access time")
    long getLastAccessTime() {
        return ((MapEntry)this.getManagedObject()).getLastAccessTime();
    }

    @JMXAttribute(value="LastUpdateTime")
    @JMXDescription(value="Last update time")
    long getLastUpdateTime() {
        return ((MapEntry)this.getManagedObject()).getLastUpdateTime();
    }

    @JMXAttribute(value="Version")
    @JMXDescription(value="Version")
    long getVersion() {
        return ((MapEntry)this.getManagedObject()).getVersion();
    }

    @JMXAttribute(value="Valid")
    @JMXDescription(value="Is valid")
    boolean isValid() {
        return ((MapEntry)this.getManagedObject()).isValid();
    }
}

