/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MaxSizeConfig
implements DataSerializable {
    public static final String POLICY_MAP_SIZE_PER_JVM = "map_size_per_jvm";
    public static final String POLICY_CLUSTER_WIDE_MAP_SIZE = "cluster_wide_map_size";
    public static final String POLICY_PARTITIONS_WIDE_MAP_SIZE = "partitions_wide_map_size";
    public static final String POLICY_USED_HEAP_SIZE = "used_heap_size";
    public static final String POLICY_USED_HEAP_PERCENTAGE = "used_heap_percentage";
    int size = Integer.MAX_VALUE;
    String maxSizePolicy = "cluster_wide_map_size";

    @Override
    public void readData(DataInput in) throws IOException {
        this.size = in.readInt();
        this.maxSizePolicy = in.readUTF();
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeUTF(this.maxSizePolicy);
    }

    public int getSize() {
        return this.size;
    }

    public MaxSizeConfig setSize(int size) {
        if (size == 0) {
            size = Integer.MAX_VALUE;
        }
        this.size = size;
        return this;
    }

    public String getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    public MaxSizeConfig setMaxSizePolicy(String maxSizePolicy) {
        this.maxSizePolicy = maxSizePolicy;
        return this;
    }

    public String toString() {
        return "MaxSizeConfig{maxSizePolicy='" + this.maxSizePolicy + '\'' + ", size=" + this.size + '}';
    }
}

