/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jopendocument.util.Unzip;

public class Zip {
    private final OutputStream outstream;
    private ZipOutputStream zos;
    private boolean entryOpen;

    public static Zip createFrom(File file, File file2, Set set) throws ZipException, IOException {
        Unzip unzip = new Unzip(file);
        Zip zip = new Zip(file2);
        Enumeration<? extends ZipEntry> enumeration = unzip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (set.contains(zipEntry.getName())) continue;
            zip.zip(zipEntry.getName(), unzip.getInputStream(zipEntry));
        }
        unzip.close();
        return zip;
    }

    public static void delete(File file, Set set, File file2) throws ZipException, IOException {
        if (file2.exists()) {
            file2.delete();
        }
        Zip.createFrom(file, file2, set).close();
    }

    public Zip(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Zip(OutputStream outputStream) {
        this.outstream = outputStream;
        this.zos = null;
        this.entryOpen = false;
    }

    public synchronized void close() throws IOException {
        if (this.zos != null) {
            this.zos.close();
        }
    }

    private synchronized ZipOutputStream getOutStream() {
        if (this.zos == null) {
            this.zos = new ZipOutputStream(this.outstream);
        }
        return this.zos;
    }

    public void zip(File file) throws IOException {
        this.zip(file.getName(), new BufferedInputStream(new FileInputStream(file)));
    }

    public synchronized void zip(String string, InputStream inputStream) throws IOException {
        this.putNextEntry(string);
        byte[] byArray = new byte[512];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            this.getOutStream().write(byArray, 0, n);
        }
        this.closeEntry();
    }

    public void zip(String string, byte[] byArray, boolean bl) throws IOException {
        if (bl) {
            this.zip(string, new ByteArrayInputStream(byArray));
        } else {
            this.zipNonCompressed(string, byArray);
        }
    }

    public synchronized void zipNonCompressed(String string, byte[] byArray) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setMethod(0);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        zipEntry.setCrc(cRC32.getValue());
        zipEntry.setSize(byArray.length);
        this.putNextEntry(zipEntry);
        this.getOutStream().write(byArray);
        this.closeEntry();
    }

    public synchronized OutputStream createEntry(String string) throws IOException {
        this.putNextEntry(string);
        return new BufferedOutputStream(this.getOutStream()){

            @Override
            public void close() throws IOException {
                this.flush();
                Zip.this.closeEntry();
            }
        };
    }

    private final synchronized void putNextEntry(String string) throws IOException, FileNotFoundException {
        this.putNextEntry(new ZipEntry(string));
    }

    private final synchronized void putNextEntry(ZipEntry zipEntry) throws IOException, FileNotFoundException {
        if (this.entryOpen) {
            throw new IllegalStateException("previous entry not closed");
        }
        this.entryOpen = true;
        this.getOutStream().putNextEntry(zipEntry);
    }

    protected final synchronized void closeEntry() throws IOException {
        this.getOutStream().closeEntry();
        this.entryOpen = false;
    }
}

