/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;

public final class HMEFContentsExtractor {
    private HMEFMessage message;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Use:");
            System.err.println("  HMEFContentsExtractor <filename> <output dir>");
            System.err.println("");
            System.err.println("");
            System.err.println("Where <filename> is the winmail.dat file to extract,");
            System.err.println(" and <output dir> is where to place the extracted files");
            System.exit(2);
        }
        HMEFContentsExtractor ext = new HMEFContentsExtractor(new File(args[0]));
        File dir = new File(args[1]);
        File rtf = new File(dir, "message.rtf");
        if (!dir.exists()) {
            throw new FileNotFoundException("Output directory " + dir.getName() + " not found");
        }
        System.out.println("Extracting...");
        ext.extractMessageBody(rtf);
        ext.extractAttachments(dir);
        System.out.println("Extraction completed");
    }

    public HMEFContentsExtractor(File filename) throws IOException {
        this(new HMEFMessage(new FileInputStream(filename)));
    }

    public HMEFContentsExtractor(HMEFMessage message) {
        this.message = message;
    }

    public void extractMessageBody(File dest) throws IOException {
        FileOutputStream fout = new FileOutputStream(dest);
        MAPIRtfAttribute body = (MAPIRtfAttribute)this.message.getMessageMAPIAttribute(MAPIProperty.RTF_COMPRESSED);
        fout.write(body.getData());
        fout.close();
    }

    public void extractAttachments(File dir) throws IOException {
        int count = 0;
        for (Attachment att : this.message.getAttachments()) {
            ++count;
            String filename = att.getLongFilename();
            if (filename == null || filename.length() == 0) {
                filename = att.getFilename();
            }
            if (filename == null || filename.length() == 0) {
                filename = "attachment" + count;
                if (att.getExtension() != null) {
                    filename = filename + att.getExtension();
                }
            }
            File file = new File(dir, filename);
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(att.getContents());
            fout.close();
        }
    }
}

