/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.templates.xmlfilters;

import net.sf.jooreports.templates.xmlfilters.XmlEntryFilter;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.Text;

public class TextInputTagFilter
extends XmlEntryFilter {
    private boolean processJooScriptOnly = true;

    public void doFilter(Document document) {
        Nodes textInputNodes = document.query("//text:text-input", XPATH_CONTEXT);
        for (int nodeIndex = 0; nodeIndex < textInputNodes.size(); ++nodeIndex) {
            Element textInputElement = (Element)textInputNodes.get(nodeIndex);
            String expression = textInputElement.getAttributeValue("description", textInputElement.getNamespaceURI()).trim();
            if (expression.equalsIgnoreCase("jooscript")) {
                String value = textInputElement.getValue();
                if (value.startsWith("${")) {
                    textInputElement.getParent().replaceChild((Node)textInputElement, (Node)new Text(value));
                    continue;
                }
                Element childNode = textInputElement;
                while (childNode.getParent().getChildCount() == 1) {
                    childNode = childNode.getParent();
                }
                childNode.getParent().replaceChild((Node)childNode, TextInputTagFilter.newNode(value));
                continue;
            }
            if (this.processJooScriptOnly) continue;
            if (expression.length() > 0 && !expression.startsWith("${")) {
                expression = "${" + expression + "}";
            }
            textInputElement.getParent().replaceChild((Node)textInputElement, (Node)new Text(expression));
        }
    }

    public void setProcessJooScriptOnly(boolean processJooScriptOnly) {
        this.processJooScriptOnly = processJooScriptOnly;
    }
}

