/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.folder.impl;

import static com.openexchange.usm.api.datatypes.DataTypes.*;

import com.openexchange.usm.api.contenttypes.*;
import com.openexchange.usm.api.datatypes.PIMAttachment;
import com.openexchange.usm.api.datatypes.PIMAttachments;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.*;
import com.openexchange.usm.contenttypes.util.AbstractContentType;
import com.openexchange.usm.contenttypes.util.UtilConstants;
import com.openexchange.usm.datatypes.folder.FolderPermissionDataType;
import com.openexchange.usm.session.dataobject.DataObjectUtil;
import com.openexchange.usm.session.dataobject.FolderImpl;

/**
 * This class defines all relevant information for content type folder
 * 
 * @author ibr
 *
 */
public class FolderContentTypeImpl extends AbstractContentType implements FolderContentType {
	private static final ContentTypeField[] FIELDS = {
	// Common folder data 
			new ContentTypeField(1, UtilConstants.FIELD_ID, STRING, false, true, false, false),//Object ID
			new ContentTypeField(20, UtilConstants.FOLDER_ID, STRING, false, false, true, false), //Object ID of the parent folder.
			new ContentTypeField(2, UtilConstants.CREATED_BY, STRING), //User ID of the user who created this object. 
			new ContentTypeField(3, UtilConstants.MODIFIED_BY, STRING), //User ID of the user who last modified this object.
			new ContentTypeField(4, UtilConstants.CREATION_DATE, TIME), //Date and time of creation.
			new ContentTypeField(5, UtilConstants.LAST_MODIFIED, TIME), //Date and time of the last modification. 
			new ContentTypeField(6, FolderConstants.LAST_MODIFIED_UTC, TIMESTAMP), //Timestamp of the last modification.
			// Detailed folder data 
			new ContentTypeField(300, FolderConstants.TITLE, STRING), //Name of this folder. 
			new ContentTypeField(301, FolderConstants.MODULE, STRING), //Name of the module which implements this folder; e.g. "tasks", "calendar", "contacts", "infostore", or "mail" 
			new ContentTypeField(302, FolderConstants.TYPE, NUMBER), //Type of folder: 1 - private, 2 - public, 3 - shared, 5 - system folder 
			new ContentTypeField(304, FolderConstants.SUBFOLDERS, BOOLEAN), //true if this folder has subfolders. 
			new ContentTypeField(305, FolderConstants.OWN_RIGHTS, new OwnRightsDataType()), //Permissions which apply to the current user, as described either in  Permission flags or in RFC 2086.
			new ContentTypeField(306, FolderConstants.PERMISSIONS, new FolderPermissionDataType(), true), //Each element is an object described in  (Folder)Permission object. 
			new ContentTypeField(307, FolderConstants.SUMMARY, STRING), //Information about contained objects.
			new ContentTypeField(308, FolderConstants.STANDARD_FOLDER, BOOLEAN), //Indicates whether or not folder is marked as a default folder (only OX folder) 
			// XXX total can be reported as NULL ? Maybe also other fields ? Why ?
			new ContentTypeField(309, FolderConstants.TOTAL, NUMBER), //The number of objects in this Folder.
			new ContentTypeField(310, FolderConstants.NEW, NUMBER), //The number of new objects in this Folder. 
			new ContentTypeField(311, FolderConstants.UNREAD, NUMBER), //The number of unread objects in this Folder.
			new ContentTypeField(312, FolderConstants.DELETED, NUMBER), //The number of deleted objects in this Folder. 
			new ContentTypeField(313, FolderConstants.CAPABILITIES, NUMBER), //Bit mask containing information about mail folder capabilites, as described in  capabilities. 
			new ContentTypeField(314, FolderConstants.SUBSCRIBED, BOOLEAN), //Indicates whether this folder should appear in folder tree or not.
			new ContentTypeField(315, FolderConstants.SUBSCR_SUBFLDS, BOOLEAN), //Indicates whether subfolders should appear in folder tree or not. 
			new ContentTypeField(316, FolderConstants.STANDARD_FOLDER_TYPE, NUMBER_NOT_NULL), //Special code indicating standard folders with special meaning like "Trash" 
	};

	private FolderContentTypeTransferHandler _transferHandler;

	/**
	 * Constructor is package private to discourage access from outside the bundle (but to allow usage in test cases)
	 */
	FolderContentTypeImpl() {
	}

	public ContentTypeField[] getFields() {
		return FIELDS;
	}

	public String getID() {
		return DefaultContentTypes.FOLDER_ID;
	}

	@Override
	public Folder newDataObject(Session session) {
		return new FolderImpl(session, this);
	}

	public FolderContentTypeTransferHandler getTransferHandler() {
		return _transferHandler;
	}

	public void setTransferHandler(FolderContentTypeTransferHandler transferHandler) {
		_transferHandler = transferHandler;
	}

	@Override
	public int hashCode() {
		return 1931;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof FolderContentType))
			return false;
		return true;
	}

	@Override
	public int getMatchRating(DataObject client, DataObject server) {
		// TODO Add more heuristic to determine possible match ?
		// Currently Folders are assumed a match if their title matches, the match is more likely if also their parent folder id matches
		if (!DataObjectUtil.isFieldEqual(client, server, FolderConstants.TITLE))
			return -1;
		return DataObjectUtil.isEqual(client.getParentFolderID(), server.getParentFolderID()) ? 2 : 1;
	}

	public int getCode() {
		return DefaultContentTypes.FOLDER_CODE;
	}

	public long createNewAttachment(DataObject object, PIMAttachment attachment) throws USMException {
		// do nothing, attachments are not supported
		return 0L;
	}

	public long deleteAttachments(DataObject object, PIMAttachment... attachmentsToDelete) throws USMException {
		// do nothing, attachments are not supported
		return 0L;
	}

	public PIMAttachments getAllAttachments(DataObject object, String sort, String order) throws USMException {
		// do nothing, attachments are not supported
		return null;
	}

	public PIMAttachments getAllAttachments(DataObject object) throws USMException {
		// do nothing, attachments are not supported
		return null;
	}

	public byte[] getAttachmentData(DataObject object, int attachmentId) throws USMException {
		// do nothing, attachments are not supported
		return null;
	}

	public boolean supportsPIMAttachments() {
		return false;
	}

	public Object getObjectGroupOwner(DataObject object) {
		return object.getID();
	}

	@Override
	public boolean canBeFolderElementsContentType() {
		return false;
	}
}
