/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

ox.gui.initToppanel = function () {
        
    /*
     * Module Icons
     */
    //var today = new Date(now()).getUTCDate();
    var modules = ox.api.ui.listModules();
    var moduleNodes = {}, selectedModule;
    
    $("#header").css({
        height: "30px",
        backgroundImage: "url('" + getFullImgSrc("img/toolbar/toolbar30.png") + "')"
    }).empty();

    
    $("#notheader").css({
        top: "30px"
    });
    
    var topPanel = ox.widgets.toppanel = new ox.gui.Container("ox-top").
        addTo(ox.desktop).
        setParentDOMNode($("#header")[0]).
        css({
            position: "absolute", right: "18px", 
            bottom: "0px", left: "0px", top: "0px"
        }).
        setLayout(new ox.gui.BorderLayout());
    
    ox.widgets.toppanel.hide = function() {
        this.setVisible(false);
        jQuery("#header").hide();
        jQuery("#notheader").css({ top: "0px" });
    };
    
    ox.widgets.toppanel.show = function() {
        this.setVisible(true);
        jQuery("#notheader").css({ top: "30px" });
        jQuery("#header").show();
    };
    
    var moduleContainer = ox.widgets.moduleNavigation = new ox.gui.Container("ox-modules").
        addTo(topPanel).
        setLayout(new ox.gui.ZeroLayout()).
        setLayoutParam({ position: "center" });
   
    
    var changeIconState = ox.UIController.changeIconState = function (name) {
        
        // visual selection
        var select = function (name) {
            $(moduleNodes[name].dom.node).
                css({
                    borderLeft: "1px inset silver",
                    borderRight: "1px inset silver"
                }).
                addClass("background-color-PMG-selection-elements");
        };
        
        var deselect = function (name) {
         // fixed: changed from null to "" due to ie problem
            $(moduleNodes[name].dom.node).
                css({ border: "" }).removeClass("background-color-PMG-selection-elements");
        };
        
        // if module selection hasn't change, return!
        if (selectedModule === name) {
            return;
        }
        
        // remove styles on all nodes first except for expert tree (if active)
        for (var i in moduleNodes) {
            deselect(i);
        }
        
        // update module selection
        if (ox.api.ui.moduleExists(name)) {
            // set selection
            select(name);
            selectedModule = name;
        }
    };
    
    // TODO rename to something not global or move into ox.UIController.
    expertSelection = new ox.gui.Custom(function() {
        var input = this.input = $("<input/>").css({ "float": "left", border: "0px none" }).
        attr({ type: "checkbox", id: "expert-tree" }).
        bind("click", function(event) {
            var flag = $(this).is(":checked");
            track({
                type: "click",
                dest: "expert_mode",
                data: { expert: flag },
                text: flag ? "Change to expert mode" : "Change to non-expert mode"
            });
            ox.UIController.setExpertTree(flag);
        });
        
        $(this.dom.node).
        append(input).
        append($("<div/>").css({ "float": "left" }).
                append($("<label/>").attr({ "for": "expert-tree" }).
                        append(addTranslated(_("Expert mode"))))
        );
        // initial state
        if (ox.UIController.showExpertTree) {
            input.attr("checked", "checked");
        }
    });
    
    
    ox.UIController.dispatcher.bind("expertchanged", function (e) {
        // change status only if != current status
        if (expertSelection && expertSelection.input && 
                expertSelection.input.attr("checked") != e.enabled) {
            expertSelection.input.attr("checked", e.enabled);
        }
    });
    
    ox.UIController.bind("modulechange", function (e) {
        changeIconState(e.module === "messaging" ? "mail" : e.module);
    });
    
    // loop
    var i = 0, $l = modules.length;
    var factory = function (module) {
        
        // set icons if not already done
        if (module.icons === undefined) {
            module.icons = ["icons/24/mod_" + module.name + ".png"];
        }
        
        // special handling for calendar
        if (module.name === "calendar") {
            module.icons[0] = "img/calendar/dayicons/mod_calendar-" + (new Date(now())).getUTCDate() + ".png";
        }
        
        var img = new ox.gui.Image().
        	addCSSClass("ox-top-module-icons top-icon-" + module.name).
            setSrc(getFullImgSrc(module.icons[0])).
            setTitle(module.title);
                
        // module activated?
        if (module.disabled) {
            
            // show for upsell?
            if (ox.upsell.isVisible(module.name)) {
                
                // disable image
                img.disable();
                
                // append lock icon
                jQuery(img.dom.node).append(
                      jQuery("<div>").addClass("top-icon-disabled")
                      .css({ 
                          backgroundImage: "url(" + getFullImgSrc("icons/16/lock.png") + ")",
                          position: "absolute",
                          width: "16px",
                          height: "16px",
                          bottom: "2px",
                          right: "0px"
                      })
                );
                
            	// trigger upsell if feature is disabled
            	img.addListener("click", function (e) {
                    triggerEvent("Feature_Not_Available", "modules/" + module.name, window);
            	});
            	
            	// add image to container
                moduleContainer.add(img);
                moduleNodes[module.name] = img;
            }
        	
        } else {
            
        	// bind click to icon
            img.css({ cursor: "pointer" }).
            addListener("click", function (e) {
                
                track({
                    type: "click",
                    dest: "module_bar",
                    data: { module: module.name, folder: "auto" },
                    text: "Change to module " + module.name
                });
                
                ox.UIController.setModule({ module: module.name, folder: "auto" });
            });
            
            // add image to container
            moduleContainer.add(img);
            moduleNodes[module.name] = img;
        }
    };
    
    for (; i < $l; i++) {
        factory(modules[i]);
    }

    // adding checkbox to toggle expert
    if (ox.api.config.get("ui.global.expert.mode.configurable", true) === true) {
        moduleContainer.add(
                expertSelection.
                setLayoutParam({ position: "center" }).
                setCSSClass("top-icon-expert-selection").
                css({ margin: "5px 0 0 20px", "float": "left" })
        );
    }

    //---- Logout button

    new ox.gui.Button("ox-topbar-logout", _("Logout"), function() {
        triggerEvent("Logout");
    }).addTo(topPanel).
    setLayoutParam({ position: "right", width: 120, valign: "top", align: "right" }).
    css({ position: "absolute", top: "5px", right: "0px" });
    
    //----- search bar
    ox.widgets.searchField = {
        active: function() {
            if (this[ox.api.ui.getActiveModule()]) {
                return this[ox.api.ui.getActiveModule()];
            } else {
                return this.top;
            }
        }
    };
    
    ox.widgets.searchField.top = new ox.gui.SearchField("ox-topbar-search", { disabled: true }).
    addTo(topPanel).
    setLayoutParam({ position: "right", width: "250px" }).
    css({ position: "absolute", top: "5px", bottom: "4px", left: "0px", right: "0px" }).
    addListener("widget:search", function (e) {
        // vars
        var module = ox.UIController.getModule(),
            id = "",
            tmp = this.searchMenu.checked;
            trigger = function () {
                triggerEvent("OX_New_Search", ox.api.ui.getActiveModule(), e.data.value);
            };
        // module with criteria?
        if (module === "mail" || module === "contacts") {
            // any criteria selected?
            for (id in tmp) {
                if (tmp[id] === true) {
                    // trigger search
                    trigger();
                    break;
                }
            }
        } else {
            // trigger search for module without criteria
            trigger();
        }
    });
    
    
    //----- buttons
    
    var buttons = new ox.gui.Container("ox-buttons").
    addTo(topPanel).
    setLayout(new ox.gui.HBoxLayout()).
    setLayoutParam({ position: "right", width: "80px" }).
    css({ position: "absolute", top: "3px", right: "10px" });
    
    
    var loading = new ox.gui.Image().
    addCSSClass("ox-top-module-buttons").
    css({ cursor: "pointer" }).
    setLayoutParam({ width: "20px", align: "right" }).
    setSrc(getFullImgSrc("img/toolbar/tb_loading.gif")).
    setTitle(_("Refresh")).
    addListener("click", function (e) {
        track({
            type: "click",
            dest: "refresh_button",
            text: "User clicked on the refresh button"
        });
        triggerEvent("OX_Refresh");
    });
    
    buttons.add(loading);
    
    setLoading = function(enabled) {
        loading.setSrc(getFullImgSrc(enabled ? 
                "img/toolbar/ox_animated.gif" : "img/toolbar/tb_loading.gif"));
        loading.setTitle(enabled ? _("Loading...") : _("Refresh"));
    };
    
    var cursor = null;
    setLoadingCursor = function(enabled) {
        if (IE) return; // Changing the cursor triggers mouseup in IE
        if (enabled) {
            if (!cursor){
                cursor = setMouseCursor("wait");
            }
        } else if (cursor) {
            removeMouseCursor(cursor);
            cursor = null;
        }
    };
    
    // Listen to legacy event.
    register("Loading", function(isLoading) {
        setLoading(enabled);
        setLoadingCursor(enabled);
    });
    
    var help = new ox.gui.Image().
    addCSSClass("ox-top-module-buttons").
    css({ cursor: "pointer" }).
    setLayoutParam({ width: "20px", align: "right" }).
    setSrc(getFullImgSrc("img/toolbar/help.gif")).
    setTitle(_("Help"));

    buttons.add(help);

    var _faq_guid = null;
    var faq = new MenuItem(_("FAQ"),
            function() {
                var uri = ox.api.config.get("ui.global.help.faq_path");
                var win = window.open(uri, "faq");
                win.focus();
            }
    );
    faq.setVisible(ox.api.config.contains("ui.global.help.faq_path"));
    
    var menu = globalContextMenus.help = new PulldownMenu(help.dom.node);
    menu.addItem(new MenuItem(_("Help"),
        function() { triggerEvent("OX_Show_Help", help_location); }));
    menu.addItem(faq);
    if (ox.api.config.get("ui.global.error_history.disabled", false) === false) {
	    menu.addItem(new MenuItem(_("Error messages"),
	        function() { ox.UINotifier.showReport(); }));
    }
    menu.addItem(new MenuItem(_("About"),
        function() { triggerEvent("OX_Show_About"); }));

};