/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Suphi Basdemir <suphi.basdemir@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

var contactDetailId = 0, color_label = 0, newContactId = 0, lastTimestamp = 0;
var activefolderLocal = "", clickedItem = "", clickedItemForSave = "";
var activemoduleLocal = corewindow.activemodule;
var modulPopup = "new", contact_object = {};
var configGetKey = corewindow.configGetKey;
var configSetKey = corewindow.configSetKey;
var configContainsKey = corewindow.configContainsKey;
var json = null, distruBigGrid = null, session = url["session"];
var messageOnCancel = false, savePending = false;
var dataFromDb, myDistrListExternEmails;
var triggerReady = jQuery.noop;
var messageCloseWindow = _("Do you really want to discard your changes and close the window?");

/********************************** before on unload *****************************************************************/
// modal dialog
function setModalBusy(state){
    if (state == true){
        ox.api.setModal(true);
        jQuery("#modal-dialog-decorator").addClass("busy");
    }else{
        ox.api.setModal(false);
        jQuery("#modal-dialog-decorator").removeClass("busy");
    }
}

/********************************** Init *****************************************************************/

function closeWindow() {
	function cbyes() {
		ctrl.close(true);
	}
	if (messageOnCancel) {
		newConfirm(_("Close Window"),messageCloseWindow,AlertPopup.YESNO,null,null,cbyes,null);		
	} else {
		cbyes();
	}
}

function initDistributionListLoaded() {
    
    // add default theme (should be in browser cache)
    var themeStyle = corewindow.oxThemeStyle || { name: "Default", path: "default" };
    ox.gui.themePath = getFullImgSrc("");
    removeCSSFilesForNewWindow(themeStyle.path);
    
	activemodule='contact_new';
	initContents('contact_new');
	initAll();
	
	// extend url object
	url = jQuery.extend((url || {}), ox.api.window.getData(url.guid));
	url.module = url.modul || "new";
}

function viewDistributionMenu() {
    
    myDistrListExternEmails = new DistrListExtEmail();
    distrFromAddressbookLive(); 
    
	activefolderLocal = url.folder !== undefined ? url.folder : corewindow.activefolder;
	activemodule="contact_new";	
	json = new JSONX();	
	register("OX_SAVE_OBJECT", saveContact);
	register("OX_Cancel_Object", closeWindow);
    
    register("OX_Object_Distributionlist_Internal_Contact",
    	function() {
    		participants.openAddParticipantsWindow();
    		triggerEvent('searchContacts');
    		if ($("distribution_extern_emails")) {
				$("distribution_extern_emails").style.display = 'none';
			}
    	}
    );
    
    register("OX_Object_Distributionlist_External_Mail",
    	function() {
            myDistrListExternEmails.clearList(); 
    		myDistrListExternEmails.showDialog();
    		$('extern_displayname').focus();
    	}
    );
    
    register("OX_Object_Distributionlist_EditName", function() {
        distruBigGrid.updateSelected(function(i, data) {
            if (data.edit) {
                setTimeout( function() { data.edit.display_name(); }, 0);
            }
        });
    });
    
    register("OX_Object_Distributionlist_EditEmail", function() {
        distruBigGrid.updateSelected(function(i, data) {
            if (data.edit) {
                setTimeout( function() { data.edit.email(); }, 0);
            }
        });
    });
    
    register("OX_Object_Distributionlist_Delete", 
    	function() {
    		distruBigGrid.deleteIDs(distruBigGrid.selection.getSelected());
    		setBeforeUnload(true);
    	}
    );
    
	if (window.location.hash != "") {
		setModulPopup();
	}	
	folderPath();
	loadingComplete();

	triggerEvent("OX_Switch_View","contact_new/distributionlist");
};

register("Loaded", viewDistributionMenu);

registerView("contact_new/distributionlist",
    null,
	function () {
		setTimeout(function() {	$("display_name").focus();	},0);
	},
	null,
	null,
	function () {
		setTimeout(function() {	$("display_name").focus();	},0);
	});


/********************************** Distribution List **********************************/
function folderPath() {
	if(activefolderLocal && activefolderLocal != "" && activemoduleLocal =="contacts"){
		clickedItemForSave = activefolderLocal;
	} else {
		clickedItemForSave = corewindow.configGetKey("folder.contacts");
	}
	
	ox.api.folder.get({
	    folder: clickedItemForSave,
	    success: function (data) {
    		if (ox.api.folder.derive("permissions", data, 14).bit < 2) {
    			triggerEvent("OX_New_Error", 4, _("You do not have write permission for this folder. The new contact will be saved in your personal contacts folder. "));
    			clickedItemForSave = configGetKey("folder.contacts");
    		}
    		
    		var folderViewSettingsNewContact = new Object();
    		var folderViewSettingsNewContactById = new Object();
    		//Disable Email... 
    		// folder.popup
    		folderViewSettingsNewContact["mail"] = 4;
    		folderViewSettingsNewContactById["default"] = 4;
    		folderViewSettingsNewContact["contacts"] = 8;
    		folderViewSettingsNewContact["calendar"] = 4;
    		folderViewSettingsNewContact["tasks"] = 4;
    		folderViewSettingsNewContact["infostore"] = 4;
    		if (!dlTreeLoaded){
    		    addOnClose($("treeDialogNewDL"), toggleTreePath);
    			ox.api.ui.selectFolder({
    		    	type: "contacts",
    		    	id: "select-folder-popup-distribution-list",
    		    	callback: folderDLAction,
    		    	node: $('folder_tree_info'),
    		    	minPerms: 2, // create objects
    		    	destroy: false
    		    });
    			dlTreeLoaded = true;
    			ox.api.folder.getPathString({
        		    folder: clickedItemForSave,
        		    success: cb_DLgetpath
        		});
    		}
	    }
	});
}

corewindow.register("OX_Configuration_Changed", function () {
    if (ox && ox.api && clickedItemForSave) {
        ox.api.folder.getPathString({
            folder: clickedItemForSave,
            cache: false,
            success: cb_DLgetpath
        });
    }
});

function cb_DLgetpath(sPath) {
	document.getElementsByName('newDL_folder')[0].value = sPath;
}

function folderDLAction(data) {
	toggleTreePath();
	clickedItemForSave = data.id;
	ox.api.folder.getPathString({
	    folder: clickedItemForSave,
	    success: function(s) {
	        cb_DLgetpath(s);
            setBeforeUnload(true);
	    }
	});
}

var dlTreeLoaded = false;
var dlTreeVisible = false;

function toggleTreePath(){
    // prevent a second popup in background during folder selection
    if ($("treeDialogNewParticitpantList").style.display === "none" ) {
    	if(!dlTreeVisible){
    		centerPopupWindow($("treeDialogNewDL"), 400, 300);
    		$("treeDialogNewDL").style.display = "block";
    		dlTreeVisible = true;
    		if (!dlTreeLoaded){
    			newDlFolderTree.load(corewindow.optFolderState.getState('folder_tree_info'));
    			dlTreeLoaded = true;
			}
    	} else{
    		$("treeDialogNewDL").style.display = "none";
    		dlTreeVisible = false;
    	}
    }
    ox.api.setModal(dlTreeVisible);
}

var callback_new = callback_update = function (arg) {
	if (arg.error) {
		newServerError(arg);
	} else {
		finalFunction();
	}
};
/*********** DL - Extern Email *********/


/**
 * Distribution List for external E-Mail adresses constructor
 */
function DistrListExtEmail() {  
    // init livegrid and new storage for external e-mail addresses
    this.selection = new Selection();
    this.storage = new Storage(0, [], 0, 0, 0, 0, function(external) { return external.id; });
    this.grid = new LiveGrid([
        { 
            text: _("Name"),
            clear: LiveGrid.makeClear(""),
            set: function(div, external) {
                if (div.firstChild)
                    div.firstChild.data = external.display_name;
                else
                    div.appendChild(document.createTextNode(external.display_name));
            }
        },
        {
            text: _("E-Mail"),
            clear: LiveGrid.makeClear(""),
            set: function(div, external) {
                if (div.firstChild)
                    div.firstChild.data = external.email;
                else
                    div.appendChild(document.createTextNode(external.email));
            }
        }
    ], this.selection);
    this.grid.emptylivegridtext = "";
    
    // add livegrid header and content to dom node
    $("dist.ext.mail.grid.header").appendChild(this.grid.getHeader());
    this.grid.getTable($("dist.ext.mail.grid"));
}

DistrListExtEmail.prototype = {
    
    /**
     * Displays the external E-Mail Dialog
     */
    showDialog: function() {
        this.grid.enable(this.storage);
        $("floatingdivParticipants").style.display = 'none';
        centerPopupWindow($("distribution_extern_emails"));
        $("distribution_extern_emails").style.display = 'block';
    },  
    
    /**
     * Closes the external E-Mail Dialog
     */
    closeDialog: function() {
        $("distribution_extern_emails").style.display = 'none';
        this.grid.disable();
    },
    
    /**
     * Resets the list of external e-mail addresses
     */
    clearList: function(){
        $('extern_displayname').value = "";
        $('extern_email').value = "";
        this.storage.remove(0, this.storage.ids.length);
    },
    
    /**
     * Adds a new external e-mail address to the list
     * @param displayName The display name
     * @param email The e-mail address (required)
     */
    addToList: function(display_name, email) {
        display_name = trimStr(display_name || "");
        email = trimStr(email);
        this.storage.append([{ 'id': this.storage.ids.length, 'display_name': display_name, 'email': email }]);     
    }
};

/**
 * Closes the external E-Mail Dialog and clears the temp list.
 */
function closeExternalEmailDialog() {
    myDistrListExternEmails.clearList(); 
    myDistrListExternEmails.closeDialog();
}

/**
 * Gets the display name and email address from the page, validates and 
 * adds it to the list. Afterwards the fields on the page gets cleared
 * or fucused. 
 */
function addExternalEmailToList() {
    var disp = trimStr($('extern_displayname').value || ""); 
    var email = trimStr($('extern_email').value || "");
    var goahead = function(disp, email) {
        $("extern_email").className = removeClass($("extern_email").className, "border-color-error");
        myDistrListExternEmails.addToList(disp, email);
        $('extern_displayname').value = "";
        $('extern_email').value = "";
    };
    if (email.length == 0) {
        if (!$("extern_email").className.match(/border-color-error/gi)) 
            $("extern_email").className += " border-color-error";
        newAlert(_("Error"), _("Please enter a valid E-Mail address!"), function() {
               $("extern_email").focus();
            });
    } else if (!corewindow.validateEmail(email)) {
        if (!$("extern_email").className.match(/border-color-error/gi))     
            $("extern_email").className += " border-color-error";
        newConfirm(_("Error"),_("The E-Mail address you have entered seems not to be valid. Would you like to add it anyway?"),AlertPopup.YESNO,null,null,
            function() { goahead(disp, email); }, function () { $("extern_email").focus(); });
    } else {        
        goahead(disp, email);
        setFocus($('extern_displayname'));
    }
}

/**
 * Append the external added email addresses to the big grid.
 */
function appendExternalToBigGrid() {
    
    var data = myDistrListExternEmails.storage;
    // loop items
    data.newIterate(data.ids, null, function(key, item) {
        var id = item.id || -distruBigGrid.storage.ids.length || -1;
        // add to storage (live grid), external addresses do not have an id
        // only needed for the grid selection, so make it random
        var cObj = { 'id':  new Date().getTime() + "." + parseInt(Math.random() * 10000), 
                'display_name': item.display_name || "",
                'email': item.email || "",
                external: true
        };
        distruBigGrid.storage.append([cObj]);
    });
}

// to move
var participants = null;

/*********** DL - From Adressbook *********/
function distrFromAddressbookLive() {
	// selection
	var selection = new Selection();
	// storage
	function serialize(id) { return id.id + "." + id.email; }
    var storage = new Storage(0, [], 0, 0, 0, serialize,
        function(data) { return { id: data.id, email: data.email, external: data.external }; });
    
	// live grid
	distruBigGrid = new LiveGrid([
        { 
            text: _("Name"),
            clear: function(div) { setter(div, {}, "display_name"); },
            set: function(div, data) { setter(div, data, "display_name"); }
        },
        {
            text: _("E-Mail"),
            clear: function(div) { setter(div, {}, "email"); },
            set: function(div, data) { setter(div, data, "email"); }
        }
    ], selection);
    
    function setter(div, data, field) {
        var node = jQuery(div);
        if (!node.data("LiveGridData")) node.dblclick(dblclick);
        node.text(data[field]).data("LiveGridData", data);
        if (data.external) {
            if (!data.edit) data.edit = {};
            data.edit[field] = edit;
        }
        function dblclick(e) {
            if (!node.data("LiveGridData").external) return;
            e.stopPropagation();
            setTimeout(edit, 0); // Required due to the timeout in setFocus()
        }                        // which is called by the LiveGrid.
        function edit() { new inplaceEdit(div, node.text(), save).on(); }
        function save(newValue) {
            distruBigGrid.storage.localUpdate(
                [distruBigGrid.storage.makeID(node.data("LiveGridData"))],
                function(i, old) {
                    old[field] = newValue;
                    return old;
                });
            setBeforeUnload(true);
        }
    }
    
	distruBigGrid.emptylivegridtext = "";	
    // add livegrid header and content to dom node
    $("newDistrListLiveHeader").appendChild(distruBigGrid.getHeader());
    distruBigGrid.getTable($("newDistrListLive"));    
    distruBigGrid.enable(storage);
    
    // what to do when select a appointment
	distruBigGrid.events.register("Selected", function(count) {		
		triggerEvent("SubSelected", count);
	});
	
	distruBigGrid.events.register("Delete", function(ids) {
		triggerEvent("OX_Object_Distributionlist_Delete");
	});
    
    // ------------------------------------------------------------------------
	folderOwner = configGetKey("identifier");
	
	// use ParticipantsSmall (without its own LiveGrid)
	participants = new ParticipantsSmall(
		null,
		// callback function to process contacts provided by the popup window
		function(items) {
			// loop items
			for(i = 0; i < items.length; i++) {
				// shortcut
				var item = items[i];
				// type
				switch (item.type) {
					// user
					case 1:
					// contact
					case 5:
						var myObject = { 
								'id': item.contactID,
								'display_name': item.display_name || "",
								'email': item.mail,
								'recurrence': item.recurrence
							};
						// duplicate?
                        if (!(serialize(myObject) in storage.indices)) {
							// add to list
							storage.append([myObject]);
						}
						break;
				}
			}
			setBeforeUnload(true);
		},
		// showUser, showGroup, showResource, showFolder, title, id, singleFolderSearch
		true, false, false, true, _("Select Contacts"), folderOwner); /*i18n*/
	
	participants.allEmailAddresses = true;
	
    triggerReady = function () {
        // init new toolbar
        ox.gui.initToolBarNewWindowDistributionlist();
        
        // trigger panel resize
        window.setTimeout(function() {
            triggerEvent("OX_menu_Change_Height", true);
        }, 0);
        
        var metaData = {
            module: "contacts",
            distributionList: true,
            activemodule: activemodule,
            handle: url.guid,
            id: (window.url.id !== -1) ? window.url.id : null,
            folder_id: (window.url.folder !== -1) ? window.url.folder : null,
            title: window.url.modul === "new" ? corewindow._("New Distribution List") : $('display_name').value
        };
        
        ox.api.window.core.triggerEvent("OX_Window_Ready", metaData, window);
    };
	
	initParticipantContent();
}

/********************************** Save Contact *****************************************************************/
/**
 * triggerEvent -> save Button
 * switch: new, edit, dublicate, newmember
 */
function saveContact() {
	if (savePending) {
	    return;
	} else {
	    savePending = true;
	}
	
	if(modulPopup == "new" || modulPopup == "duplicate") {
		writeNewContact();
	} else if(modulPopup == "edit") {
        
        /********************************** update Contact ********************************************************/
		
		contact_object.last_name = $('display_name').value;
		contact_object.display_name = $('display_name').value;
		contact_object.folder_id = clickedItemForSave;
		
		var cb_put = function() {
			json.put(AjaxRoot + "/contacts?action=update&session=" + session + 
				"&id=" + contactDetailId + "&folder=" + activefolderLocal + 
				"&timestamp="+lastTimestamp,
				contact_object, 
				null, 
				function(updatedFields)
				{	
					if(updatedFields) {
						if(updatedFields.error) {
							//error
						} else {
							finalFunction();
						}
					}
				}
			);
		};
		
		getDistrForSave(cb_put);
	}
}

/*
 * build contact_object.distribution_list for save 
 * */

function getDistrForSave(callback) {
	var data = distruBigGrid.storage;
	var tmpDistObj = new Array();
	// loop items
	data.newIterate(data.ids, null, function(key, obj) {
		// collect items
		tmpDistObj.push({
			// positive id=user/contact; negative id=temp-id for external users
			"id": obj.external || obj.id < 0 ? null : obj.id,
			"display_name": obj.display_name,
			"mail": obj.email, 
			"mail_field" : obj.external ? 0 : obj.id < 0 ? 0 : Number(obj.recurrence) + 1
		});		
	});
	// done...
	contact_object.distribution_list = tmpDistObj;
	contact_object.color_label = color_label || 0;
	
	// callback
	if(callback) callback();
}


/********************************** set var Module *****************************************************************/
/**
 * Init Popup for setting the Modul
 * @param {String} parameters from the url 
 */
function setModulPopup(params) {
	
	/////////
	// Modul Edit or Duplicate
	if (url['modul'] && (url['modul'] == "edit" || url['modul'] == "duplicate")) {
			modulPopup = url['modul'];
			contactDetailId = url['id'];
			activefolder = url['folder'];
			session = url['session'];
			currentView = url['currentView'];
			fillFieldById();	
	} else {
		fillFields(url);		
		// disable loading screen
        $("loading_data_bg").style.display="none";
        triggerReady();
	}
	
}

/********************************** get ContactById *****************************************************************/

/**
 * fill the Fields which comes from DB 
 * id is a Param in the url, see {@link setModulPopup}
 */
function fillFieldById() {
	
	// load distribution list (ajax call)
	new JSONX().get(
		AjaxRoot + "/contacts?action=get&session=" + session +
		"&id=" + contactDetailId + "&folder=" + activefolderLocal, null,
		// callback to process the JSON response
		function(response) {
			
			// remember response (used by dialog closer)
			dataFromDb = response;
			
			// shortcut			
			var d = response.data;	
			fillFields(d);
			
			// remember timestamp
			lastTimestamp = response.timestamp;

			// disable loading screen
		    $("loading_data_bg").style.display="none";
		    
		    triggerReady();
		}
	);
}

function setWindowTitle () {
    var title = $('display_name').value || "";
    if (document) {
    	document.title = (url.modul === "new" ? _("New Distribution List") : _("Edit Distribution List") + ": " + title);
    }
}

function fillFields(data) {
    
	// map title to required fields
	if (data.title && !data.display_name) {
		data.display_name = data.title;
	}
	
	// set "display_name" (text field) -> name of the distribution list
	var title = data["display_name"] || "";
	$('display_name').value = title;
	
	// set document title too
	setWindowTitle();
	
	// set(hidden field)
	$('last_name').value = data['display_name'] || "";
	data.file_as = data.display_name;
	
	// set color label
	if (data['color_label']) color_label = data['color_label'];

	if (data['distribution_list']) {
		// shortcut
		var dl = data['distribution_list'], fl = {};
		// loop entries
		for (var i = 0; i < dl.length; i++ ) {
		    // add to storage (live grid)
            var cObj = { 'display_name': dl[i].display_name || "",
                    'email': dl[i].mail || ""
            };
            
			var id = dl[i].id;
			// external address without id
			if ((id === undefined || id === null) || trimStr(id).length === 0 
			        || dl[i].mail_field === 0) {
			    id = new Date().getTime() + "." + parseInt(Math.random() * 10000);
			    cObj.external = true;
			    cObj.mail_field = 0;
			    if (fl[cObj.email]) {
			        continue;
			    }
			    fl[cObj.email] = true;
			}
			cObj.id = id;
			// if not set, use default 1 - required to set recurrence
			if (dl[i].mail_field == undefined) {
				dl[i].mail_field = 1;
			}
			cObj.recurrence = dl[i].mail_field - 1;
			
			if (!fl[id]) {
			    distruBigGrid.storage.append([cObj]);
			    fl[id] = true;
			}
		}
		fl = dl = null;
	}
}


/********************************** Write new Contact *****************************************************************/
/**
 * Write all filled fields in DB
 * json.put -> contact_object
 */
function writeNewContact() {	
	contact_object.last_name = $('display_name').value;
	contact_object.display_name = $('display_name').value;
	contact_object.folder_id = clickedItemForSave;
			
	var tmpString = new Array;
	contact_object.distribution_list = tmpString; //mark as Distribution List
	getDistrForSave();
	setModalBusy(true);
	json.put(AjaxRoot + "/contacts?action=new" + 
			"&session=" + corewindow.session + 
			"&folder=" + clickedItemForSave , 
			contact_object, null, function(idObj){
			if(idObj) {	
				newContactId = idObj.data.id;
				finalFunction();
			}
		}, setModalBusy);
}


function finalFunction() {
	
	if (modulPopup == "new" || modulPopup == "duplicate") {
		// new/duplicate
		setBeforeUnload(false);
		corewindow.OXContactMapping.createObject(contact_object);
		corewindow.closeContactPopUp(window, clickedItemForSave);
		
	} else if(modulPopup = "edit") {
		// 	edit
		setBeforeUnload(false);
        corewindow.OXCache.newRequest(null, "contacts", { columns: null,
            objects: [corewindow.OXContactMapping.createKeyFromObject({
                module: "contacts", folder_id: clickedItemForSave,
                id: contactDetailId
            })] }, null, emptyFunction, true);
        if (activefolderLocal != clickedItemForSave) {
            corewindow.OXContactMapping.deleteObjectsInternal(
                [corewindow.OXContactMapping.createKeyFromObject({
                    module: "contacts", folder_id: activefolderLocal,
                    id: contactDetailId
                })]);
		}
		corewindow.closeContactPopUp(window, clickedItemForSave);
    }
}

function setBeforeUnload(on) {
    if (on !== undefined && on !== messageOnCancel) {
        messageOnCancel = on;
    }
    ctrl.dirty(messageOnCancel);
}

// init window controller
var ctrl = windowController = new WindowController();

ctrl.set("beforeunload", function () {
    if (messageOnCancel) {
        return messageCloseWindow + "";
    }
});

ctrl.set("confirm", closeWindow);
ctrl.set("dirty", setBeforeUnload);
