/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class ExternalObjectType
implements AtomicType,
Serializable {
    private Class javaClass;
    int fingerprint;
    int baseFingerprint = -1;
    public static final ExternalObjectType GENERAL_EXTERNAL_OBJECT_TYPE = new ExternalObjectType(class$java$lang$Object == null ? (class$java$lang$Object = ExternalObjectType.class$("java.lang.Object")) : class$java$lang$Object);
    static /* synthetic */ Class class$java$lang$Object;

    public ExternalObjectType(Class clazz) {
        this.javaClass = clazz;
        this.fingerprint = 285;
    }

    public AtomicType getCommonAtomicType() {
        return this;
    }

    public final int getValidationStatus() {
        return 3;
    }

    public final int getBlock() {
        return 0;
    }

    public final int getDerivationMethod() {
        return 1;
    }

    public final boolean allowsDerivation(int n) {
        return true;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public final boolean isComplexType() {
        return false;
    }

    public final SchemaType getBaseType() {
        return BuiltInSchemaFactory.getSchemaType(643);
    }

    public ItemType getPrimitiveItemType() {
        return this;
    }

    public int getPrimitiveType() {
        return 643;
    }

    public String toString(NamePool namePool) {
        return this.getDisplayName();
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public void isTypeDerivationOK(SchemaType schemaType, int n) throws SchemaException, ValidationException {
    }

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isAtomicType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public int getWhitespaceAction(TypeHierarchy typeHierarchy) {
        return 0;
    }

    public CharSequence applyWhitespaceNormalization(CharSequence charSequence) throws ValidationException {
        return charSequence;
    }

    public SchemaType getBuiltInBaseType() {
        return this;
    }

    public boolean isNamespaceSensitive() {
        return false;
    }

    public final SequenceIterator getTypedValue(NodeInfo nodeInfo) {
        throw new IllegalStateException("The type annotation of a node cannot be an external object type");
    }

    public Value atomize(NodeInfo nodeInfo) throws XPathException {
        throw new IllegalStateException("The type annotation of a node cannot be an external object type");
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NamespaceResolver namespaceResolver, NameChecker nameChecker) throws ValidationException {
        throw new ValidationException("Cannot validate a string against an external object type");
    }

    public AtomicValue makeDerivedValue(AtomicValue atomicValue, CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("makeDerivedValue is not supported for external object types");
    }

    public void analyzeContentExpression(Expression expression, int n, StaticContext staticContext) throws XPathException {
        ExternalObjectType.analyzeContentExpression(this, expression, staticContext, n);
    }

    public static void analyzeContentExpression(SimpleType simpleType, Expression expression, StaticContext staticContext, int n) throws XPathException {
        if (n == 1) {
            expression.checkPermittedContents(simpleType, staticContext, true);
        } else if (n == 2 && (expression instanceof ValueOf || expression instanceof Value)) {
            expression.checkPermittedContents(simpleType, staticContext, true);
        }
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public boolean isBuiltIn() {
        return true;
    }

    public boolean matchesItem(Item item, XPathContext xPathContext, boolean bl) {
        if (item instanceof ObjectValue) {
            Object object = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(object.getClass());
        }
        return false;
    }

    public ValidationException validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver, NameChecker nameChecker) {
        throw new UnsupportedOperationException("Cannot use an external object type for validation");
    }

    public ItemType getSuperType(TypeHierarchy typeHierarchy) {
        return Type.ANY_ATOMIC_TYPE;
    }

    public int getFingerprint() {
        return 285;
    }

    public String toString() {
        String string = this.javaClass.getName();
        string = string.replace('$', '-');
        return "java:" + string;
    }

    public String getDisplayName() {
        return this.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

