/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.misc.processor.XSDToWSDLProcessor;

public class XSDToWSDL
extends AbstractCXFToolContainer {
    static final String TOOL_NAME = "xsd2wsdl";

    public XSDToWSDL(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set getArrayKeys() {
        return new HashSet();
    }

    public void execute(boolean exitOnFinish) {
        block7: {
            XSDToWSDLProcessor processor = new XSDToWSDLProcessor();
            try {
                super.execute(exitOnFinish);
                if (!this.hasInfoOption()) {
                    ToolContext env = new ToolContext();
                    env.setParameters(this.getParametersMap(this.getArrayKeys()));
                    if (this.isVerboseOn()) {
                        env.put("verbose", Boolean.TRUE);
                    }
                    env.put("args", this.getArgument());
                    this.validate(env);
                    processor.setEnvironment(env);
                    processor.process();
                }
            }
            catch (ToolException ex) {
                if (ex.getCause() instanceof BadUsageException) {
                    this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
                }
                this.err.println();
                this.err.println("XSDToWSDL Error: " + ex.getMessage());
                if (this.isVerboseOn()) {
                    ex.printStackTrace(this.err);
                }
            }
            catch (Exception ex) {
                this.err.println();
                this.err.println("XSDToWSDL Error: " + ex.getMessage());
                if (!this.isVerboseOn()) break block7;
                ex.printStackTrace(this.err);
            }
        }
    }

    private void validate(ToolContext env) throws ToolException {
        String outdir = (String)env.get("outputdir");
        if (outdir != null) {
            File dir = new File(outdir);
            if (!dir.exists() && !dir.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, outdir);
                throw new ToolException(msg);
            }
            if (!dir.isDirectory()) {
                Message msg = new Message("NOT_A_DIRECTORY", LOG, outdir);
                throw new ToolException(msg);
            }
        }
    }

    public static void main(String[] pargs) {
        CommandInterfaceUtils.commandCommonMain();
        try {
            ToolRunner.runTool(XSDToWSDL.class, XSDToWSDL.class.getResourceAsStream("xsd2wsdl.xml"), false, pargs);
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("xsdurl")) {
            errors.add(new ErrorVisitor.UserError("XSD URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

