/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc4;

import java.util.List;
import org.javasimon.utils.Replacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlNormalizer {
    private static final Replacer[] FIRST_REPLACERS;
    private static final Replacer[] SECOND_REPLACERS;
    private static final Replacer FUNCTION_REPLACER;
    private static final Replacer TYPE_SELECTOR;
    private final String sql;
    private String normalizedSql;
    private String type;

    public SqlNormalizer(String sql) {
        this.sql = sql;
        if (sql != null) {
            this.normalize(sql);
        }
    }

    public SqlNormalizer(List<String> batch) {
        this.sql = "batch";
        StringBuilder sqlBuilder = new StringBuilder();
        String lastStmt = null;
        int stmtCounter = 0;
        for (String statement : batch) {
            this.normalize(statement);
            if (lastStmt == null) {
                lastStmt = this.normalizedSql;
            }
            if (!lastStmt.equalsIgnoreCase(this.normalizedSql)) {
                sqlBuilder.append(stmtCounter == 1 ? "" : stmtCounter + "x ").append(lastStmt).append("; ");
                lastStmt = this.normalizedSql;
                stmtCounter = 1;
                continue;
            }
            ++stmtCounter;
        }
        sqlBuilder.append(stmtCounter == 1 ? "" : stmtCounter + "x ").append(lastStmt);
        this.type = "batch";
        this.normalizedSql = sqlBuilder.toString();
    }

    private void normalize(String sql) {
        this.normalizedSql = sql.toLowerCase().trim();
        this.applyReplacers(FIRST_REPLACERS);
        this.type = TYPE_SELECTOR.process(this.normalizedSql);
        if (this.type.equals("select")) {
            String[] sa = this.normalizedSql.split(" from ", 2);
            if (sa.length == 2) {
                this.normalizedSql = sa[0] + " from " + FUNCTION_REPLACER.process(sa[1]);
            }
        } else {
            this.normalizedSql = FUNCTION_REPLACER.process(this.normalizedSql);
        }
        this.applyReplacers(SECOND_REPLACERS);
    }

    private void applyReplacers(Replacer[] replacers) {
        for (Replacer replacer : replacers) {
            this.normalizedSql = replacer.process(this.normalizedSql);
        }
    }

    public String getSql() {
        return this.sql;
    }

    public String getNormalizedSql() {
        return this.normalizedSql;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "SqlNormalizer{\n  sql='" + this.sql + '\'' + ",\n  normalizedSql='" + this.normalizedSql + '\'' + ",\n  type='" + this.type + '\'' + '}';
    }

    static {
        FUNCTION_REPLACER = new Replacer("([-(=<>!+*/,]+\\s?)\\w+\\([^()]*\\)", "$1?", new Replacer.Modificator[]{Replacer.Modificator.REPEAT_UNTIL_UNCHANGED});
        TYPE_SELECTOR = new Replacer("^\\W*(\\w+)\\W.*", "$1", new Replacer.Modificator[0]);
        FIRST_REPLACERS = new Replacer[]{new Replacer("''", "?", new Replacer.Modificator[0]), new Replacer(" *([-=<>!+*/,]+) *", "$1", new Replacer.Modificator[0]), new Replacer("([-=<>!+*/]+)", " $1 ", new Replacer.Modificator[0]), new Replacer("\\s+", " ", new Replacer.Modificator[0]), new Replacer("(create|alter|drop) (\\S+) ([^ (]+).*$", "$1 $2 $3", new Replacer.Modificator[0]), new Replacer("([-=<>!+*/,.(]+\\s?)(?:(?:'[^']+')|(?:[0-9.]+))", "$1?", new Replacer.Modificator[0]), new Replacer("like '[^']+'", "like ?", new Replacer.Modificator[0]), new Replacer("between \\S+ and \\S+", "between ? and ?", new Replacer.Modificator[0]), new Replacer(" in\\(", " in (", new Replacer.Modificator[0]), new Replacer("^\\{|\\}$", "", new Replacer.Modificator[0]), new Replacer("^\\s*begin", "call", new Replacer.Modificator[0]), new Replacer(";?\\s*end;?$", "", new Replacer.Modificator[0])};
        SECOND_REPLACERS = new Replacer[]{new Replacer(",", ", ", new Replacer.Modificator[0]), new Replacer(" in \\(\\?(?:, \\?)*\\)", " in (?)", new Replacer.Modificator[0])};
    }
}

