/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.calltree;

import java.util.LinkedList;
import org.javasimon.Split;
import org.javasimon.callback.calltree.CallTreeNode;
import org.javasimon.callback.logging.LogMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallTree
implements LogMessageSource<Split> {
    private final Long logThreshold;
    private final LinkedList<CallTreeNode> callStack = new LinkedList();
    private CallTreeNode rootNode;

    public CallTree(Long logThreshold) {
        this.logThreshold = logThreshold;
    }

    public CallTreeNode onStopwatchStart(Split split) {
        CallTreeNode currentNode;
        String name = split.getStopwatch().getName();
        if (this.callStack.isEmpty()) {
            currentNode = this.rootNode = new CallTreeNode(name);
            this.onRootStopwatchStart(currentNode, split);
        } else {
            currentNode = this.callStack.getLast().getOrAddChild(name);
        }
        this.callStack.addLast(currentNode);
        return currentNode;
    }

    public CallTreeNode onStopwatchStop(Split split) {
        CallTreeNode currentNode = this.callStack.removeLast();
        currentNode.addSplit(split);
        if (this.callStack.isEmpty()) {
            this.onRootStopwatchStop(currentNode, split);
        }
        return currentNode;
    }

    public void onRootStopwatchStart(CallTreeNode rootNode, Split split) {
    }

    protected void onRootStopwatchStop(CallTreeNode callTreeNode, Split split) {
    }

    @Override
    public String getLogMessage(Split context) {
        context.getStopwatch().setAttribute("lastCallTree", this);
        return "Call Tree:\r\n" + this.rootNode.toString();
    }

    public Long getLogThreshold() {
        return this.logThreshold;
    }

    public CallTreeNode getRootNode() {
        return this.rootNode;
    }
}

