/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.xmp.XmpDirectory;
import java.util.Calendar;

public class XmpReader
implements MetadataReader {
    private static final int FMT_STRING = 1;
    private static final int FMT_RATIONAL = 2;
    private static final int FMT_INT = 3;
    private static final int FMT_DOUBLE = 4;
    @NotNull
    private static final String SCHEMA_EXIF_SPECIFIC_PROPERTIES = "http://ns.adobe.com/exif/1.0/";
    @NotNull
    private static final String SCHEMA_EXIF_ADDITIONAL_PROPERTIES = "http://ns.adobe.com/exif/1.0/aux/";
    @NotNull
    private static final String SCHEMA_EXIF_TIFF_PROPERTIES = "http://ns.adobe.com/tiff/1.0/";
    @NotNull
    private static final String SCHEMA_DUBLIN_CORE_SPECIFIC_PROPERTIES = "http://purl.org/dc/elements/1.1/";

    @Override
    public void extract(@NotNull BufferReader bufferReader, @NotNull Metadata metadata) {
        String string;
        if (bufferReader == null) {
            throw new NullPointerException("reader");
        }
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        XmpDirectory xmpDirectory = metadata.getOrCreateDirectory(XmpDirectory.class);
        if (bufferReader.getLength() <= 30L) {
            xmpDirectory.addError("Xmp data segment must contain at least 30 bytes");
            return;
        }
        try {
            string = bufferReader.getString(0, 29);
        }
        catch (BufferBoundsException bufferBoundsException) {
            xmpDirectory.addError("Unable to read XMP preamble");
            return;
        }
        if (!"http://ns.adobe.com/xap/1.0/\u0000".equals(string)) {
            xmpDirectory.addError("Xmp data segment doesn't begin with 'http://ns.adobe.com/xap/1.0/'");
            return;
        }
        try {
            byte[] byArray;
            try {
                byArray = bufferReader.getBytes(29, (int)(bufferReader.getLength() - 29L));
            }
            catch (BufferBoundsException bufferBoundsException) {
                xmpDirectory.addError("Unable to read XMP data");
                return;
            }
            XMPMeta xMPMeta = XMPMetaFactory.parseFromBuffer((byte[])byArray);
            xmpDirectory.setXMPMeta(xMPMeta);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:LensInfo", 6, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Lens", 7, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:SerialNumber", 8, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_ADDITIONAL_PROPERTIES, "aux:Firmware", 9, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Make", 1, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_TIFF_PROPERTIES, "tiff:Model", 2, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureTime", 3, 1);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ExposureProgram", 12, 3);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ApertureValue", 11, 2);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FNumber", 5, 2);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:FocalLength", 10, 2);
            this.processXmpTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:ShutterSpeedValue", 4, 2);
            this.processXmpDateTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeOriginal", 13);
            this.processXmpDateTag(xMPMeta, xmpDirectory, SCHEMA_EXIF_SPECIFIC_PROPERTIES, "exif:DateTimeDigitized", 14);
            for (XMPPropertyInfo xMPPropertyInfo : xMPMeta) {
                String string2 = xMPPropertyInfo.getPath();
                Object object = xMPPropertyInfo.getValue();
                if (string2 == null || object == null) continue;
                xmpDirectory.addProperty(string2, object.toString());
            }
        }
        catch (XMPException xMPException) {
            xmpDirectory.addError("Error parsing XMP segment: " + xMPException.getMessage());
        }
    }

    private void processXmpTag(@NotNull XMPMeta xMPMeta, @NotNull XmpDirectory xmpDirectory, @NotNull String string, @NotNull String string2, int n, int n2) throws XMPException {
        String string3 = xMPMeta.getPropertyString(string, string2);
        if (string3 == null) {
            return;
        }
        switch (n2) {
            case 2: {
                String[] stringArray = string3.split("/", 2);
                if (stringArray.length == 2) {
                    try {
                        Rational rational = new Rational((long)Float.parseFloat(stringArray[0]), (long)Float.parseFloat(stringArray[1]));
                        xmpDirectory.setRational(n, rational);
                    }
                    catch (NumberFormatException numberFormatException) {
                        xmpDirectory.addError(String.format("Unable to parse XMP property %s as a Rational.", string2));
                    }
                    break;
                }
                xmpDirectory.addError("Error in rational format for tag " + n);
                break;
            }
            case 3: {
                try {
                    xmpDirectory.setInt(n, Integer.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    xmpDirectory.addError(String.format("Unable to parse XMP property %s as an int.", string2));
                }
                break;
            }
            case 4: {
                try {
                    xmpDirectory.setDouble(n, Double.valueOf(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    xmpDirectory.addError(String.format("Unable to parse XMP property %s as an double.", string2));
                }
                break;
            }
            case 1: {
                xmpDirectory.setString(n, string3);
                break;
            }
            default: {
                xmpDirectory.addError(String.format("Unknown format code %d for tag %d", n2, n));
            }
        }
    }

    void processXmpDateTag(@NotNull XMPMeta xMPMeta, @NotNull XmpDirectory xmpDirectory, @NotNull String string, @NotNull String string2, int n) throws XMPException {
        Calendar calendar = xMPMeta.getPropertyCalendar(string, string2);
        if (calendar == null) {
            return;
        }
        xmpDirectory.setDate(n, calendar.getTime());
    }
}

