/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples.jmx;

import java.lang.management.ManagementFactory;
import java.util.Random;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.callback.Callback;
import org.javasimon.jmx.SimonManagerMXBeanImpl;
import org.javasimon.utils.LoggingCallback;

public final class JmxTaskProcessingSimulator {
    public static final int NEW_TASK_MIN = 1000;
    public static final int NEW_TASK_SPREAD = 14000;
    public static final int TASK_MIN = 500;
    public static final int TASK_SPREAD = 11500;
    public static final String TASK_STOPWATCH = "org.javasimon.examples.jmx.tasksw";

    private static SimonManagerMXBeanImpl register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.javasimon.jmx.example:type=Simon");
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            SimonManagerMXBeanImpl simon = new SimonManagerMXBeanImpl(SimonManager.manager());
            mbs.registerMBean(simon, name);
            System.out.println("SimonManagerMXBean registerd under name: " + name);
            return simon;
        }
        catch (JMException e) {
            System.out.println("SimonManagerMXBean registration failed!\n" + e);
            return null;
        }
    }

    private static void unregister() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.javasimon.jmx.example:type=Simon");
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            System.out.println("SimonManagerMXBean was unregisterd");
        }
        catch (JMException e) {
            System.out.println("SimonManagerMXBean unregistration failed!\n" + e);
        }
    }

    public static void main(String[] args) throws Exception {
        LoggingCallback loggingCallback = new LoggingCallback();
        loggingCallback.setLevel(Level.INFO);
        SimonManager.callback().addCallback((Callback)loggingCallback);
        Random random = new Random();
        JmxTaskProcessingSimulator.register();
        try {
            while (true) {
                final int task = random.nextInt(11500) + 500;
                new Thread(){

                    public void run() {
                        Split split = SimonManager.getStopwatch((String)JmxTaskProcessingSimulator.TASK_STOPWATCH).start();
                        try {
                            Thread.sleep(task);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        split.stop();
                    }
                }.start();
                int sleep = random.nextInt(14000) + 1000;
                Thread.sleep(sleep);
            }
        }
        catch (Throwable throwable) {
            JmxTaskProcessingSimulator.unregister();
            throw throwable;
        }
    }
}

