/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientHandlerService;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Packet;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import javax.security.auth.Subject;

public class ClientRequestHandler
extends FallThroughRunnable {
    private final Packet packet;
    private final CallContext callContext;
    private final Node node;
    private final ClientHandlerService.ClientOperationHandler clientOperationHandler;
    private volatile Thread runningThread = null;
    private volatile boolean valid = true;
    private final ILogger logger;
    private final Subject subject;

    public ClientRequestHandler(Node node, Packet packet, CallContext callContext, ClientHandlerService.ClientOperationHandler clientOperationHandler, Subject subject) {
        this.packet = packet;
        this.callContext = callContext;
        this.node = node;
        this.clientOperationHandler = clientOperationHandler;
        this.logger = node.getLogger(this.getClass().getName());
        this.subject = subject;
    }

    @Override
    public void doRun() {
        this.runningThread = Thread.currentThread();
        ThreadContext.get().setCallContext(this.callContext);
        try {
            if (!this.valid) {
                return;
            }
            try {
                PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() {
                        Connection connection = ((ClientRequestHandler)ClientRequestHandler.this).packet.conn;
                        ClientRequestHandler.this.clientOperationHandler.handle(ClientRequestHandler.this.node, ClientRequestHandler.this.packet);
                        ((ClientRequestHandler)ClientRequestHandler.this).node.clientHandlerService.getClientEndpoint(connection).removeRequest(ClientRequestHandler.this);
                        return null;
                    }
                };
                if (this.node.securityContext == null) {
                    action.run();
                } else {
                    this.node.securityContext.doAsPrivileged(this.subject, action);
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                if (this.node.isActive()) {
                    throw (RuntimeException)e;
                }
            }
        }
        finally {
            this.runningThread = null;
        }
    }

    public void cancel() {
        this.valid = false;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }
}

