/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.session.sync;
import com.openexchange.usm.api.database.StorageAccessException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.exceptions.USMStorageException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.session.dataobject.DataObjectSet;

public interface ContentSyncerStorage {

    /**
     * Retrieves the data currently stored on the OX server. Stores all objects retrieved in the provided DataObjectSet, returns false if
     * the read was incomplete (i.e. not all new objects have been read from the OX server) and therefore must not be stored in the
     * OXDataCache
     * 
     * @param resultSet DataObjectSet in which the current folder content will be stored
     * @return true if the read was complete, false if the result was incomplete and must not be stored in any caches
     * @throws USMException
     */
    boolean getCurrentServerData(DataObjectSet resultSet) throws USMException;

    /**
     * Stores the given DataObjects associated with the timestamp. It returns the possibly modified timestamp, under which the data was
     * actually stored (if the provided timestamp was too old or the same as an already existing timestamp).
     * 
     * @param timestamp
     * @param data
     * @param updatesPending true if the stored data does not represent the current server state, i.e. the folder (hierarchy) should not be
     *            marked as "in sync" (for waitForChanges)
     * @return
     */
    long storeServerData(long timestamp, DataObjectSet data, boolean updatesPending) throws USMException;


    /**
     * @return {@link OXDataCacheID} for the OX server storage (a specific folder or the folder hierarchy for a session)
     */
    OXDataCacheID getCacheID();

    /**
     * Tries to find a matching client object for a given server object. This method is called if no client object with the same ID as the
     * given server object could be found. The method must either return one of the objects in clientDataObjects or null if none of the
     * objects matches based on other fields (e.g. standard_folder_type).
     * 
     * @param clientDataObjects set of available client objects to match
     * @param serverObject server object to match against
     * @return matching client object or null if none matches
     */
    DataObject findMatchingClientObjectForServerObject(DataObjectSet clientDataObjects, DataObject serverObject);
}
