/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.contenttypes.mail.impl;

import static com.openexchange.usm.api.datatypes.DataTypes.BOOLEAN;
import static com.openexchange.usm.api.datatypes.DataTypes.NUMBER;
import static com.openexchange.usm.api.datatypes.DataTypes.NUMBER_NOT_NULL;
import static com.openexchange.usm.api.datatypes.DataTypes.STRING;
import static com.openexchange.usm.api.datatypes.DataTypes.TIME;
import java.util.BitSet;
import java.util.List;
import org.json.JSONObject;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.common.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.mail.MailConstants;
import com.openexchange.usm.api.contenttypes.mail.MailContentType;
import com.openexchange.usm.api.contenttypes.resource.ResourceInputStream;
import com.openexchange.usm.api.contenttypes.transferhandlers.ContentTypeTransferHandler;
import com.openexchange.usm.api.datatypes.ArrayDataType;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.io.InputStreamProvider;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.contenttypes.util.AbstractContentType;
import com.openexchange.usm.datatypes.mail.FlagsDataType;
import com.openexchange.usm.datatypes.mail.HeadersDataType;
import com.openexchange.usm.datatypes.mail.MailAttachmentDataType;
import com.openexchange.usm.datatypes.mail.NestedMailDataType;

public class MailContentTypeImpl extends AbstractContentType implements MailContentType {

    // Email addresses are stored in an array with 2 indexes, containing the display name in the first, and the email address in the second
    private static final ArrayDataType EMAIL_ADDRESS_LIST = new ArrayDataType(new ArrayDataType(STRING));

    private static final ContentTypeField[] FIELDS = {
        // Detailed mail data
        new ContentTypeField(600, MailConstants.FIELD_ID, STRING, false, true, false, false),// Object ID
        new ContentTypeField(601, MailConstants.FOLDER_ID, STRING, false, false, true, false),// Object ID of the parent folder
        new ContentTypeField(602, MailConstants.ATTACHMENT, BOOLEAN),// Specifies whether this mail has attachments.
        new ContentTypeField(603, MailConstants.FROM, EMAIL_ADDRESS_LIST),// Each element is a string specifying one sender.
        new ContentTypeField(604, MailConstants.TO, EMAIL_ADDRESS_LIST),// Each element is a string specifying one receiver.
        new ContentTypeField(605, MailConstants.CC, EMAIL_ADDRESS_LIST),// Each element is a string specifying one carbon-copy receiver.
        new ContentTypeField(606, MailConstants.BCC, EMAIL_ADDRESS_LIST),// Each element is a string specifying one blind carbon-copy
                                                                         // receiver.
        new ContentTypeField(607, MailConstants.SUBJECT, STRING),// Subject line.
        new ContentTypeField(608, MailConstants.SIZE, NUMBER),// Size of the mail in bytes.
        new ContentTypeField(609, MailConstants.SENT_DATE, TIME),// Date and time as specified in the mail by the sending client.
        new ContentTypeField(610, MailConstants.RECEIVED_DATE, TIME),// Date and time as measured by the receiving server.
        new ContentTypeField(611, MailConstants.FLAGS, new FlagsDataType()),// Various system flags. See javax.mail.Flags.Flag for details.
        new ContentTypeField(612, MailConstants.LEVEL, NUMBER),// Zero-based nesting level in a thread.
        new ContentTypeField(613, MailConstants.DISP_NOTIFICATION_TO, STRING),// Content of message's header "Disposition-Notification-To"
        new ContentTypeField(614, MailConstants.PRIORITY, NUMBER),// Value of message's "X-Priority" header
        new ContentTypeField(102, MailConstants.COLOR_LABEL, NUMBER_NOT_NULL),

        new ContentTypeField(-10, MailConstants.USER, STRING, true),// An array with user-defined flags as strings.
        new ContentTypeField(-11, MailConstants.HEADERS, new HeadersDataType()),// An object with a field for every non-standard header. The
                                                                                // header name is the field name.
        // The header value is the value of the field as string.
        new ContentTypeField(-12, MailConstants.ATTACHMENTS, new MailAttachmentDataType(), true),// Each element is an attachment as
                                                                                                 // described in Attachment.
        // The first element is the mail text. If the mail has multiple representations (multipart-alternative), then the alternatives are
        // placed after the mail text and have the field disp set to alternative.
        new ContentTypeField(-14, MailConstants.NESTED_MSGS, new NestedMailDataType(), true),// Each element is a mail object as described
                                                                                             // in this table, except for fields id,
                                                                                             // folder_id and attachment.
        new ContentTypeField(-16, MailConstants.MAIL_CONTENT_TYPE, STRING),
        new ContentTypeField(-18, MailConstants.SOURCE, STRING),};

    public static ContentTypeField[] getAllFields() {
        return FIELDS;
    }

    private MailContentTypeTransferHandlerImpl _transferHandler;

    @Override
    public ContentTypeField[] getFields() {
        return FIELDS;
    }

    @Override
    public String getID() {
        return DefaultContentTypes.MAIL_ID;
    }

    @Override
    public ContentTypeTransferHandler getTransferHandler() {
        return _transferHandler;
    }

    public void setTransferHandler(MailContentTypeTransferHandlerImpl transferHandler) {
        _transferHandler = transferHandler;
    }

    @Override
    public int hashCode() {
        return 19731;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof MailContentType))
            return false;
        return true;
    }

    @Override
    public DataObject getReplyForward(Session session, String messageID, String folderID, String action, String view, boolean dropPrefix) throws USMException {
        return _transferHandler.getReplyForward(session, messageID, folderID, action, view, dropPrefix);
    }

    @Override
    public byte[] readMailSource(DataObject object, BitSet requestedFields) throws USMException {
        return _transferHandler.readMailSource(object, requestedFields, false);
    }

    @Override
    public void sendMail(String mail, Session session) throws USMException {
        _transferHandler.sendMail(mail, session);
    }

    @Override
    public void sendMail(InputStreamProvider streamProvider, Session session) throws USMException {
        _transferHandler.sendMail(streamProvider, session);
    }

    @Override
    public String createNewMail(String folderId, int flag, String mailMIMEdataBlock, Session session) throws USMException {
        return _transferHandler.createNewMail(folderId, flag, mailMIMEdataBlock, session);
    }

    @Override
    public String createNewMailFromStream(String parentFolderID, int flags, InputStreamProvider streamProvider, Session session) throws USMException {
        return _transferHandler.createNewMailFromStream(parentFolderID, flags, streamProvider, session);
    }

    @Override
    public Object getMailAttachment(Session session, String folderId, String mailId, String attachmentId) throws USMException {
        return _transferHandler.getMailAttachment(session, folderId, mailId, attachmentId);
    }

    @Override
    public ResourceInputStream getMailAttachmentAsStream(Session session, String folderId, String mailId, String attachmentId) throws USMException {
        return _transferHandler.getMailAttachmentAsStream(session, folderId, mailId, attachmentId);
    }

    @Override
    public ResourceInputStream getMailAttachmentStreamFromStructureId(Session session, String folderId, String mailId, String structureId) throws USMException {
        return _transferHandler.getMailAttachmentAsStreamFromStructureId(session, folderId, mailId, structureId);
    }

    @Override
    public int getCode() {
        return DefaultContentTypes.MAIL_CODE;
    }

    @Override
    public JSONObject readStructuredMail(DataObject object, int maxAttachmentSize) throws USMException {
        return _transferHandler.readStructuredMail(object, maxAttachmentSize);
    }

    @Override
    public boolean supportsPIMAttachments() {
        return false;
    }

    @Override
    public Object getObjectGroupOwner(DataObject object) {
        return object.getID();
    }

    @Override
    public JSONObject convertICalToJSON(DataObject mailObject, String attSeqId, String timezone) throws USMException {
        return _transferHandler.convertICalToJSON(mailObject, attSeqId, timezone);
    }

    @Override
    public JSONObject analyzeICalAttachment(DataObject mailObject, String attSeqId) throws USMException {
        return _transferHandler.analyzeICalAttachment(mailObject, attSeqId);
    }

    @Override
    public byte[] readMailSource(DataObject object, BitSet requestedFields, boolean ignoreICalAttachments) throws USMException {
        return _transferHandler.readMailSource(object, requestedFields, ignoreICalAttachments);
    }

    @Override
    public JSONObject respondToMeetingRequest(DataObject mailObject, String attSeqId, int confirmation) throws USMException {
        return _transferHandler.respondToMeetingRequest(mailObject, attSeqId, confirmation);
    }

    @Override
    public JSONObject updateObjectBasedOnMeetingRequest(DataObject mailObject, String attSeqId, String action) throws USMException {
        return _transferHandler.updateObjectBasedOnMeetingRequest(mailObject, attSeqId, action);
    }

    @Override
    public List<DataObject> searchMails(JSONObject searchCriteria, String folderId, Session session, BitSet requestedFields, int firstMatch, int lastMatch) throws USMException {
        return _transferHandler.searchMails(searchCriteria, folderId, session, requestedFields, firstMatch, lastMatch);
    }

    @Override
    public List<DataObject> searchMails(String searchText, String folderId, Session session, BitSet requestedFields, int firstMatch, int lastMatch) throws USMException {
        return _transferHandler.searchMails(searchText, folderId, session, requestedFields, firstMatch, lastMatch);
    }

    @Override
    public JSONObject getVacationRule(Session session) throws USMException {
        return _transferHandler.getVacationRule(session);
    }

    @Override
    public void setVacationRule(Session session, JSONObject rule) throws USMException {
        _transferHandler.setVacationRule(session, rule);
    }

    @Override
    public void updateVacationRule(Session session, JSONObject rule) throws USMException {
        _transferHandler.updateVacationRule(session, rule);
    }

    @Override
    public void deleteVacationRule(Session session, JSONObject rule) throws USMException {
        _transferHandler.deleteVacationRule(session, rule);
    }
    
    @Override
    public boolean hasVacationRuleTimes(Session session) throws USMException {
        return _transferHandler.hasVacationRuleTimes(session);
    }
}
