/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractReloadingMetadataProvider
extends AbstractObservableMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(AbstractReloadingMetadataProvider.class);
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    private RefreshMetadataTask refresMetadataTask;
    private float refreshDelayFactor = 0.75f;
    private long maxRefreshDelay = 14400000L;
    private int minRefreshDelay = 300000;
    private DateTime expirationTime;
    private DateTime lastUpdate;
    private DateTime lastRefresh;
    private DateTime nextRefresh;
    private XMLObject cachedMetadata;

    protected AbstractReloadingMetadataProvider() {
        this(null);
    }

    protected AbstractReloadingMetadataProvider(Timer backgroundTaskTimer) {
        if (backgroundTaskTimer == null) {
            this.log.debug("Creating own background task Timer instance");
            this.taskTimer = new Timer(true);
            this.createdOwnTaskTimer = true;
        } else {
            this.log.debug("Using ctor arg-supplied background task Timer instance");
            this.taskTimer = backgroundTaskTimer;
        }
    }

    public DateTime getExpirationTime() {
        return this.expirationTime;
    }

    public DateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public DateTime getLastRefresh() {
        return this.lastRefresh;
    }

    public DateTime getNextRefresh() {
        return this.nextRefresh;
    }

    public long getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    public void setMaxRefreshDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Maximum refresh delay must be greater than 0");
        }
        this.maxRefreshDelay = delay;
    }

    public float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(float factor) {
        if (factor <= 0.0f || factor >= 1.0f) {
            throw new IllegalArgumentException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }

    public int getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    public void setMinRefreshDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Minimum refresh delay must be greater than 0");
        }
        this.minRefreshDelay = delay;
    }

    @Override
    public synchronized void destroy() {
        this.refresMetadataTask.cancel();
        if (this.createdOwnTaskTimer) {
            this.taskTimer.cancel();
        }
        this.expirationTime = null;
        this.lastRefresh = null;
        this.lastUpdate = null;
        this.nextRefresh = null;
        this.cachedMetadata = null;
        super.destroy();
    }

    @Override
    protected XMLObject doGetMetadata() throws MetadataProviderException {
        return this.cachedMetadata;
    }

    @Override
    protected void doInitialization() throws MetadataProviderException {
        this.refresh();
        if ((long)this.minRefreshDelay > this.maxRefreshDelay) {
            throw new MetadataProviderException("Minimum refresh delay " + this.minRefreshDelay + " is greater than maximum refresh delay " + this.maxRefreshDelay);
        }
    }

    public synchronized void refresh() throws MetadataProviderException {
        DateTime now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        String mdId = this.getMetadataIdentifier();
        this.log.debug("Beginning refresh of metadata from '{}'", (Object)mdId);
        try {
            byte[] mdBytes = this.fetchMetadata();
            if (mdBytes == null) {
                this.log.debug("Metadata from '{}' has not changed since last refresh", (Object)mdId);
                this.processCachedMetadata(mdId, now);
            } else {
                this.log.debug("Processing new metadata from '{}'", (Object)mdId);
                this.processNewMetadata(mdId, now, mdBytes);
            }
            this.refresMetadataTask = new RefreshMetadataTask();
        }
        catch (Throwable t) {
            try {
                this.log.debug("Error occurred while attempting to refresh metadata from '" + mdId + "'", t);
                this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus((long)this.minRefreshDelay);
                if (t instanceof Exception) {
                    throw new MetadataProviderException((Exception)t);
                }
                throw new MetadataProviderException(String.format("Saw an error of type '%s' with message '%s'", t.getClass().getName(), t.getMessage()));
            }
            catch (Throwable throwable) {
                this.refresMetadataTask = new RefreshMetadataTask();
                long nextRefreshDelay = this.nextRefresh.getMillis() - System.currentTimeMillis();
                this.taskTimer.schedule((TimerTask)this.refresMetadataTask, nextRefreshDelay);
                this.log.info("Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{mdId, this.nextRefresh, this.nextRefresh.toDateTime(DateTimeZone.getDefault())});
                this.lastRefresh = now;
                throw throwable;
            }
        }
        long nextRefreshDelay = this.nextRefresh.getMillis() - System.currentTimeMillis();
        this.taskTimer.schedule((TimerTask)this.refresMetadataTask, nextRefreshDelay);
        this.log.info("Next refresh cycle for metadata provider '{}' will occur on '{}' ('{}' local time)", new Object[]{mdId, this.nextRefresh, this.nextRefresh.toDateTime(DateTimeZone.getDefault())});
        this.lastRefresh = now;
    }

    protected abstract String getMetadataIdentifier();

    protected abstract byte[] fetchMetadata() throws MetadataProviderException;

    protected XMLObject unmarshallMetadata(byte[] metadataBytes) throws MetadataProviderException {
        try {
            return this.unmarshallMetadata(new ByteArrayInputStream(metadataBytes));
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            this.log.error(errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
    }

    protected void processCachedMetadata(String metadataIdentifier, DateTime refreshStart) throws MetadataProviderException {
        DateTime metadataExpirationTime;
        this.log.debug("Computing new expiration time for cached metadata from '{}", (Object)metadataIdentifier);
        this.expirationTime = metadataExpirationTime = SAML2Helper.getEarliestExpiration(this.cachedMetadata, refreshStart.plus(this.getMaxRefreshDelay()), refreshStart);
        long nextRefreshDelay = this.computeNextRefreshDelay(this.expirationTime);
        this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus(nextRefreshDelay);
    }

    protected void processNewMetadata(String metadataIdentifier, DateTime refreshStart, byte[] metadataBytes) throws MetadataProviderException {
        this.log.debug("Unmarshalling metadata from '{}'", (Object)metadataIdentifier);
        XMLObject metadata = this.unmarshallMetadata(metadataBytes);
        if (!this.isValid(metadata)) {
            this.processPreExpiredMetadata(metadataIdentifier, refreshStart, metadataBytes, metadata);
        } else {
            this.processNonExpiredMetadata(metadataIdentifier, refreshStart, metadataBytes, metadata);
        }
    }

    protected void processPreExpiredMetadata(String metadataIdentifier, DateTime refreshStart, byte[] metadataBytes, XMLObject metadata) {
        this.log.warn("Entire metadata document from '{}' was expired at time of loading, existing metadata retained", (Object)metadataIdentifier);
        this.lastUpdate = refreshStart;
        this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus((long)this.getMinRefreshDelay());
    }

    protected void processNonExpiredMetadata(String metadataIdentifier, DateTime refreshStart, byte[] metadataBytes, XMLObject metadata) throws MetadataProviderException {
        long nextRefreshDelay;
        Document metadataDom = metadata.getDOM().getOwnerDocument();
        this.log.debug("Filtering metadata from '{}'", (Object)metadataIdentifier);
        try {
            this.filterMetadata(metadata);
        }
        catch (FilterException e) {
            String errMsg = "Error filtering metadata from " + metadataIdentifier;
            this.log.error(errMsg, (Throwable)e);
            throw new MetadataProviderException(errMsg, e);
        }
        this.log.debug("Releasing cached DOM for metadata from '{}'", (Object)metadataIdentifier);
        this.releaseMetadataDOM(metadata);
        this.log.debug("Post-processing metadata from '{}'", (Object)metadataIdentifier);
        this.postProcessMetadata(metadataBytes, metadataDom, metadata);
        this.log.debug("Computing expiration time for metadata from '{}'", (Object)metadataIdentifier);
        DateTime metadataExpirationTime = SAML2Helper.getEarliestExpiration(metadata, refreshStart.plus(this.getMaxRefreshDelay()), refreshStart);
        this.log.debug("Expiration of metadata from '{}' will occur at {}", (Object)metadataIdentifier, (Object)metadataExpirationTime.toString());
        this.cachedMetadata = metadata;
        this.lastUpdate = refreshStart;
        if (metadataExpirationTime.isBeforeNow()) {
            this.expirationTime = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus((long)this.getMinRefreshDelay());
            nextRefreshDelay = this.getMaxRefreshDelay();
        } else {
            this.expirationTime = metadataExpirationTime;
            nextRefreshDelay = this.computeNextRefreshDelay(this.expirationTime);
        }
        this.nextRefresh = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus(nextRefreshDelay);
        this.emitChangeEvent();
        this.log.info("New metadata succesfully loaded for '{}'", (Object)this.getMetadataIdentifier());
    }

    protected void postProcessMetadata(byte[] metadataBytes, Document metadataDom, XMLObject metadata) throws MetadataProviderException {
    }

    protected long computeNextRefreshDelay(DateTime expectedExpiration) {
        long refreshDelay;
        long now = new DateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        long expireInstant = 0L;
        if (expectedExpiration != null) {
            expireInstant = expectedExpiration.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor())) < (long)this.getMinRefreshDelay()) {
            refreshDelay = this.getMinRefreshDelay();
        }
        return refreshDelay;
    }

    protected byte[] inputstreamToByteArray(InputStream ins) throws MetadataProviderException {
        try {
            byte[] buffer = new byte[0x100000];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int n = 0;
            while (-1 != (n = ins.read(buffer))) {
                output.write(buffer, 0, n);
            }
            ins.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new MetadataProviderException(e);
        }
    }

    private class RefreshMetadataTask
    extends TimerTask {
        private RefreshMetadataTask() {
        }

        @Override
        public void run() {
            try {
                if (!AbstractReloadingMetadataProvider.this.isInitialized()) {
                    return;
                }
                AbstractReloadingMetadataProvider.this.refresh();
            }
            catch (MetadataProviderException e) {
                return;
            }
        }
    }
}

