/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.data;

import com.openexchange.projectset.data.CVSRepository;
import com.openexchange.projectset.data.GitRepository;
import com.openexchange.projectset.data.ProjectSetFileReader$Companion$WhenMappings;
import com.openexchange.projectset.data.Repository;
import com.openexchange.projectset.data.RepositoryType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.BuildException;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/openexchange/projectset/data/ProjectSetFileReader;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "projectList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getProjectList", "()Ljava/util/ArrayList;", "projects", "Ljava/util/HashMap;", "Lcom/openexchange/projectset/data/Repository;", "Lkotlin/collections/HashMap;", "getProjects", "()Ljava/util/HashMap;", "parse", "", "Companion", "projectset"})
public final class ProjectSetFileReader {
    @NotNull
    private final HashMap<String, Repository> projects;
    @NotNull
    private final ArrayList<String> projectList;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HashMap<String, Repository> getProjects() {
        return this.projects;
    }

    @NotNull
    public final ArrayList<String> getProjectList() {
        return this.projectList;
    }

    private final void parse(File file) {
        try {
            Element psf;
            Document document;
            Document document2 = document = new SAXBuilder().build(file);
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            Element element = psf = document2.getRootElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"psf");
            if (Intrinsics.areEqual((Object)"psf", (Object)element.getName()) ^ true) {
                throw (Throwable)new BuildException("Root element is not a PSF but a " + psf.toString());
            }
            List list = psf.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"psf.children");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Object tmp = element$iv;
                if (!(tmp instanceof Element)) {
                    Object object;
                    throw (Throwable)new BuildException("PSF child is not an element but a " + ((object = tmp) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                }
                Iterable $receiver$iv2 = ProjectSetFileReader.Companion.parseProvider((Element)tmp);
                for (Object element$iv2 : $receiver$iv2) {
                    Repository repository = (Repository)element$iv2;
                    Map map = this.projects;
                    String string = repository.getProjectName();
                    Repository repository2 = repository;
                    map.put(string, repository2);
                    this.projectList.add(repository.getProjectName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (Throwable)new BuildException(Unit.INSTANCE.toString());
        }
    }

    public ProjectSetFileReader(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.projects = new HashMap();
        this.projectList = new ArrayList();
        this.parse(file);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0005J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/openexchange/projectset/data/ProjectSetFileReader$Companion;", "", "()V", "parseMap", "", "", "Lcom/openexchange/projectset/data/Repository;", "projectSetFileName", "parseProject", "projectElement", "Lorg/jdom/Element;", "type", "Lcom/openexchange/projectset/data/RepositoryType;", "parseProvider", "", "providerElement", "projectset"})
    public static final class Companion {
        private final List<Repository> parseProvider(Element providerElement) {
            String providerName;
            if (Intrinsics.areEqual((Object)"provider", (Object)providerElement.getName()) ^ true) {
                throw (Throwable)new BuildException("PSF child is not a provider but a " + providerElement.getName());
            }
            Attribute attribute = providerElement.getAttribute("id");
            if (attribute == null) {
                throw (Throwable)new BuildException("Attribute id for tag provider is missing");
            }
            Attribute id = attribute;
            String string = providerName = id.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"providerName");
            RepositoryType repositoryType = RepositoryType.Companion.byProvider(string);
            if (repositoryType == null) {
                throw (Throwable)new BuildException("Unknown provider " + providerName);
            }
            RepositoryType type = repositoryType;
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            List list = providerElement.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"providerElement.children");
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                Object tmp = element$iv;
                if (!(tmp instanceof Element)) {
                    Object object;
                    throw (Throwable)new BuildException("Provider child is not an element but a " + ((object = tmp) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                }
                repositories.add(Companion.parseProject((Element)tmp, type));
            }
            return repositories;
        }

        private final Repository parseProject(Element projectElement, RepositoryType type) {
            Repository repository;
            if (Intrinsics.areEqual((Object)"project", (Object)projectElement.getName()) ^ true) {
                throw (Throwable)new BuildException("Provider child is not a project but a " + projectElement.getName());
            }
            Attribute attribute = projectElement.getAttribute("reference");
            if (attribute == null) {
                throw (Throwable)new BuildException("Attribute reference for tag project is missing");
            }
            Attribute reference = attribute;
            String projectReference = reference.getValue();
            switch (ProjectSetFileReader$Companion$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    String string = projectReference;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectReference");
                    repository = CVSRepository.Companion.parseCVSReference(string);
                    break;
                }
                case 2: {
                    throw (Throwable)new BuildException("Parsing a SVN repository reference is currently not implemented.");
                }
                case 3: {
                    String string = projectReference;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectReference");
                    repository = GitRepository.Companion.parseGitReference(string);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return repository;
        }

        @NotNull
        public final Map<String, Repository> parseMap(@NotNull String projectSetFileName) {
            Intrinsics.checkParameterIsNotNull((Object)projectSetFileName, (String)"projectSetFileName");
            try {
                Element psf;
                Document document;
                Document document2 = document = new SAXBuilder().build(new File(projectSetFileName));
                Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                Element element = psf = document2.getRootElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"psf");
                if (Intrinsics.areEqual((Object)"psf", (Object)element.getName()) ^ true) {
                    throw (Throwable)new BuildException("Root element is not a PSF but a " + psf);
                }
                HashMap projects = new HashMap();
                List list = psf.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"psf.children");
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    Object tmp = element$iv;
                    if (!(tmp instanceof Element)) {
                        Object object;
                        throw (Throwable)new BuildException("PSF child is not an element but a " + ((object = tmp) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null));
                    }
                    Iterable $receiver$iv2 = Companion.parseProvider((Element)tmp);
                    for (Object element$iv2 : $receiver$iv2) {
                        Repository repository = (Repository)element$iv2;
                        Map map = projects;
                        String string = repository.getProjectName();
                        Repository repository2 = repository;
                        map.put(string, repository2);
                    }
                }
                return projects;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw (Throwable)new BuildException(Unit.INSTANCE.toString());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

