/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class StartTaskRequestMarshaller
implements Marshaller<Request<StartTaskRequest>, StartTaskRequest> {
    @Override
    public Request<StartTaskRequest> marshall(StartTaskRequest startTaskRequest) {
        if (startTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartTaskRequest> request = new DefaultRequest<StartTaskRequest>(startTaskRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.StartTask";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag containerInstancesList;
            TaskOverride overrides;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (startTaskRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(startTaskRequest.getCluster());
            }
            if (startTaskRequest.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value(startTaskRequest.getTaskDefinition());
            }
            if ((overrides = startTaskRequest.getOverrides()) != null) {
                jsonWriter.key("overrides");
                jsonWriter.object();
                ListWithAutoConstructFlag containerOverridesList = (ListWithAutoConstructFlag)overrides.getContainerOverrides();
                if (!(containerOverridesList == null || containerOverridesList.isAutoConstruct() && containerOverridesList.isEmpty())) {
                    jsonWriter.key("containerOverrides");
                    jsonWriter.array();
                    for (ContainerOverride containerOverridesListValue : containerOverridesList) {
                        ListWithAutoConstructFlag environmentList;
                        ListWithAutoConstructFlag commandList;
                        if (containerOverridesListValue == null) continue;
                        jsonWriter.object();
                        if (containerOverridesListValue.getName() != null) {
                            jsonWriter.key("name").value(containerOverridesListValue.getName());
                        }
                        if (!((commandList = (ListWithAutoConstructFlag)containerOverridesListValue.getCommand()) == null || commandList.isAutoConstruct() && commandList.isEmpty())) {
                            jsonWriter.key("command");
                            jsonWriter.array();
                            for (String commandListValue : commandList) {
                                if (commandListValue == null) continue;
                                jsonWriter.value(commandListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((environmentList = (ListWithAutoConstructFlag)containerOverridesListValue.getEnvironment()) == null || environmentList.isAutoConstruct() && environmentList.isEmpty())) {
                            jsonWriter.key("environment");
                            jsonWriter.array();
                            for (KeyValuePair environmentListValue : environmentList) {
                                if (environmentListValue == null) continue;
                                jsonWriter.object();
                                if (environmentListValue.getName() != null) {
                                    jsonWriter.key("name").value(environmentListValue.getName());
                                }
                                if (environmentListValue.getValue() != null) {
                                    jsonWriter.key("value").value(environmentListValue.getValue());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (!((containerInstancesList = (ListWithAutoConstructFlag)startTaskRequest.getContainerInstances()) == null || containerInstancesList.isAutoConstruct() && containerInstancesList.isEmpty())) {
                jsonWriter.key("containerInstances");
                jsonWriter.array();
                for (String containerInstancesListValue : containerInstancesList) {
                    if (containerInstancesListValue == null) continue;
                    jsonWriter.value(containerInstancesListValue);
                }
                jsonWriter.endArray();
            }
            if (startTaskRequest.getStartedBy() != null) {
                jsonWriter.key("startedBy").value(startTaskRequest.getStartedBy());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

