/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.CharGapList;

public class CharObjGapList
extends IList<Character> {
    CharGapList list;

    static Character[] toWrapper(char[] elems) {
        Character[] e = new Character[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = Character.valueOf(elems[i]);
        }
        return e;
    }

    static char[] toPrimitive(Character[] elems) {
        char[] e = new char[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i].charValue();
        }
        return e;
    }

    static char[] toPrimitive(GapList<? extends Character> list2) {
        char[] e = new char[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = list2.get(i).charValue();
        }
        return e;
    }

    static char[] toPrimitive(Collection<? extends Character> list) {
        char[] e = new char[list.size()];
        Iterator<? extends Character> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next().charValue();
        }
        return e;
    }

    public static CharObjGapList create() {
        return new CharObjGapList();
    }

    public static CharObjGapList create(Character ... elems) {
        CharObjGapList list = new CharObjGapList();
        list.init(elems);
        return list;
    }

    public static CharObjGapList create(Collection<? extends Character> elems) {
        return new CharObjGapList(elems);
    }

    public CharObjGapList() {
        this.init();
    }

    public void init() {
        this.list = new CharGapList();
    }

    public CharObjGapList(int capacity) {
        this.list = new CharGapList(capacity);
    }

    public void init(Character ... elems) {
        this.list = CharGapList.create(CharObjGapList.toPrimitive(elems));
    }

    public CharObjGapList(Collection<? extends Character> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Character> elems) {
        this.list = CharGapList.create(CharObjGapList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Character> that) {
        this.list = (CharGapList)((CharObjGapList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Character> that) {
        CharObjGapList list = (CharObjGapList)that;
        this.list = list.list;
    }

    public CharObjGapList copy() {
        return (CharObjGapList)this.clone();
    }

    @Override
    public Character getDefaultElem() {
        return Character.valueOf(this.list.getDefaultElem());
    }

    @Override
    public IList<Character> doCreate(int capacity) {
        if (capacity == -1) {
            capacity = 10;
        }
        return new CharObjGapList(capacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.list.get(index));
    }

    @Override
    protected Character doGet(int index) {
        return Character.valueOf(this.list.doGet(index));
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        for (int i = 0; i < len; ++i) {
            elems[i] = Character.valueOf(this.list.doGet(index + i));
        }
    }

    @Override
    protected boolean doAdd(int index, Character elem) {
        return this.list.doAdd(index, elem.charValue());
    }

    @Override
    protected Character doSet(int index, Character elem) {
        return Character.valueOf(this.list.doSet(index, elem.charValue()));
    }

    @Override
    protected Character doRemove(int index) {
        return Character.valueOf(this.list.doRemove(index));
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Character doReSet(int index, Character elem) {
        return Character.valueOf(this.list.doReSet(index, elem.charValue()));
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.list.equals(obj);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Character.class) {
            return -1;
        }
        return this.list.indexOf(((Character)elem).charValue());
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Character.class) {
            return -1;
        }
        return this.list.lastIndexOf(((Character)elem).charValue());
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Character.class) {
            return false;
        }
        int index = this.list.indexOf(((Character)elem).charValue());
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Character.class) {
            return false;
        }
        return this.list.contains(((Character)elem).charValue());
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(0, this.size());
    }

    @Override
    public Object[] toArray(int index, int len) {
        Object[] elems = new Object[len];
        for (int i = 0; i < len; ++i) {
            elems[i] = Character.valueOf(this.list.get(i));
        }
        return elems;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.list.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = Character.valueOf(this.list.get(i));
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Character> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Character> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addArray(Character ... elems) {
        char[] e = CharObjGapList.toPrimitive(elems);
        return this.list.addArray(e);
    }

    public boolean addArray(int index, Character ... elems) {
        char[] e = CharObjGapList.toPrimitive(elems);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Character> list2) {
        char[] e = CharObjGapList.toPrimitive(list2);
        return this.list.addArray(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Character> list2) {
        char[] e = CharObjGapList.toPrimitive(list2);
        return this.list.addArray(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Character.class) {
            return false;
        }
        return this.list.removeFirstOccurrence(((Character)elem).charValue());
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Character.class) {
            return false;
        }
        return this.list.removeLastOccurrence(((Character)elem).charValue());
    }

    @Override
    public GapList<Character> getAll(int index, int len) {
        char[] elems = this.list.getArray(index, len);
        return GapList.create(CharObjGapList.toWrapper(elems));
    }

    public Character[] getArray(int index, int len) {
        char[] elems = this.list.getArray(index, len);
        return CharObjGapList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Character> list2) {
        char[] e = CharObjGapList.toPrimitive(list2);
        this.list.setArray(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Character> coll) {
        char[] e = CharObjGapList.toPrimitive(coll);
        this.list.setArray(index, e);
    }

    public void setArray(int index, Character ... elems) {
        char[] e = CharObjGapList.toPrimitive(elems);
        this.list.setArray(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, ((Character)key).charValue());
    }

    public CharObjGapList unmodifiableList() {
        return new ImmutableCharObjGapList(this);
    }

    protected static class ImmutableCharObjGapList
    extends CharObjGapList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableCharObjGapList(CharObjGapList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Character elem) {
            this.error();
            return false;
        }

        @Override
        protected Character doSet(int index, Character elem) {
            this.error();
            return null;
        }

        @Override
        protected Character doReSet(int index, Character elem) {
            this.error();
            return null;
        }

        @Override
        protected Character doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

