/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.helper.primitive;

import org.magicwerk.brownies.collections.primitive.IBooleanList;

public class BooleanMergeSort {
    IBooleanList list;

    public static <E> void sort(IBooleanList list) {
        BooleanMergeSort sort = new BooleanMergeSort(list);
        sort.sort();
    }

    public static <E> void sort(IBooleanList list, int from, int to) {
        BooleanMergeSort sort = new BooleanMergeSort(list);
        sort.sort(from, to);
    }

    private BooleanMergeSort(IBooleanList list) {
        this.list = list;
    }

    private void sort() {
        this.sort(0, this.list.size());
    }

    private void sort(int from, int to) {
        if (to - from < 12) {
            this.insertSort(from, to);
            return;
        }
        int middle = (from + to) / 2;
        this.sort(from, middle);
        this.sort(middle, to);
        this.merge(from, middle, to, middle - from, to - middle);
    }

    private int compare(int idx1, int idx2) {
        boolean val2;
        boolean val1 = this.list.get(idx1);
        return val1 == (val2 = this.list.get(idx2)) ? 0 : (val1 ? 1 : -1);
    }

    private void swap(int idx1, int idx2) {
        boolean val = this.list.get(idx1);
        this.list.set(idx1, this.list.get(idx2));
        this.list.set(idx2, val);
    }

    private int lower(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int mid = from + half;
            if (this.compare(mid, val) < 0) {
                from = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private int upper(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int mid = from + half;
            if (this.compare(val, mid) < 0) {
                len = half;
                continue;
            }
            from = mid + 1;
            len = len - half - 1;
        }
        return from;
    }

    private void insertSort(int from, int to) {
        if (to > from + 1) {
            for (int i = from + 1; i < to; ++i) {
                for (int j = i; j > from && this.compare(j, j - 1) < 0; --j) {
                    this.swap(j, j - 1);
                }
            }
        }
    }

    private int gcd(int m, int n) {
        while (n != 0) {
            int t = m % n;
            m = n;
            n = t;
        }
        return m;
    }

    private void rotate(int from, int mid, int to) {
        if (from == mid || mid == to) {
            return;
        }
        int n = this.gcd(to - from, mid - from);
        while (n-- != 0) {
            boolean val = this.list.get(from + n);
            int shift = mid - from;
            int p1 = from + n;
            int p2 = from + n + shift;
            while (p2 != from + n) {
                this.list.set(p1, this.list.get(p2));
                p1 = p2;
                if (to - p2 > shift) {
                    p2 += shift;
                    continue;
                }
                p2 = from + (shift - (to - p2));
            }
            this.list.set(p1, val);
        }
    }

    private void merge(int from, int pivot, int to, int len1, int len2) {
        int len22;
        int second_cut;
        int first_cut;
        int len11;
        if (len1 == 0 || len2 == 0) {
            return;
        }
        if (len1 + len2 == 2) {
            if (this.compare(pivot, from) < 0) {
                this.swap(pivot, from);
            }
            return;
        }
        if (len1 > len2) {
            len11 = len1 / 2;
            first_cut = from + len11;
            second_cut = this.lower(pivot, to, first_cut);
            len22 = second_cut - pivot;
        } else {
            len22 = len2 / 2;
            second_cut = pivot + len22;
            first_cut = this.upper(from, pivot, second_cut);
            len11 = first_cut - from;
        }
        this.rotate(first_cut, pivot, second_cut);
        int newMid = first_cut + len22;
        this.merge(from, first_cut, newMid, len11, len22);
        this.merge(newMid, second_cut, to, len1 - len11, len2 - len22);
    }
}

