/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.fishwife.jrugged.ServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceWrapperChain
implements ServiceWrapper {
    private List<ServiceWrapper> wrappers;

    public ServiceWrapperChain(Collection<ServiceWrapper> wrappers) {
        ArrayList<ServiceWrapper> rev = new ArrayList<ServiceWrapper>();
        for (ServiceWrapper wrapper : wrappers) {
            rev.add(0, wrapper);
        }
        this.wrappers = rev;
    }

    private <T> Callable<T> wrap(final Callable<T> c, final ServiceWrapper wrapper) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                return wrapper.invoke(c);
            }
        };
    }

    private Runnable wrap(final Runnable r, final ServiceWrapper wrapper) {
        return new Runnable(){

            public void run() {
                try {
                    wrapper.invoke(r);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public <T> T invoke(Callable<T> c) throws Exception {
        for (ServiceWrapper wrapper : this.wrappers) {
            c = this.wrap(c, wrapper);
        }
        return c.call();
    }

    @Override
    public void invoke(Runnable r) throws Exception {
        for (ServiceWrapper wrapper : this.wrappers) {
            r = this.wrap(r, wrapper);
        }
        r.run();
    }

    @Override
    public <T> T invoke(Runnable r, T result) throws Exception {
        this.invoke(r);
        return result;
    }
}

