/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.concurrent.Callable;
import org.fishwife.jrugged.ServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCounter
implements ServiceWrapper {
    private long numRequests = 0L;
    private long numSuccesses = 0L;
    private long numFailures = 0L;

    private synchronized void succeed() {
        ++this.numRequests;
        ++this.numSuccesses;
    }

    private synchronized void fail() {
        ++this.numRequests;
        ++this.numFailures;
    }

    @Override
    public <T> T invoke(Callable<T> c) throws Exception {
        try {
            T result = c.call();
            this.succeed();
            return result;
        }
        catch (Exception e) {
            this.fail();
            throw e;
        }
    }

    @Override
    public void invoke(Runnable r) throws Exception {
        try {
            r.run();
            this.succeed();
        }
        catch (Exception e) {
            this.fail();
            throw e;
        }
    }

    @Override
    public <T> T invoke(Runnable r, T result) throws Exception {
        try {
            r.run();
            this.succeed();
            return result;
        }
        catch (Exception e) {
            this.fail();
            throw e;
        }
    }

    public synchronized long[] sample() {
        return new long[]{this.numRequests, this.numSuccesses, this.numFailures};
    }
}

