/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fishwife.jrugged.CircuitBreaker;
import org.fishwife.jrugged.CircuitBreakerConfig;
import org.fishwife.jrugged.DefaultFailureInterpreter;
import org.fishwife.jrugged.FailureInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitBreakerFactory {
    public static final String CONFIG_KEY_PREFIX = "circuit";
    public static final String LIMIT_KEY = "limit";
    public static final String WINDOWMILLIS_KEY = "windowMillis";
    public static final String RESETMILLIS_KEY = "resetMillis";
    private final ConcurrentHashMap<String, CircuitBreaker> circuitBreakerMap = new ConcurrentHashMap();
    private Properties properties;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public synchronized CircuitBreaker createCircuitBreaker(String name, CircuitBreakerConfig config) {
        CircuitBreaker circuitBreaker = this.findCircuitBreaker(name);
        if (circuitBreaker == null) {
            circuitBreaker = new CircuitBreaker(name);
            this.configureCircuitBreaker(name, circuitBreaker, config);
            this.addCircuitBreakerToMap(name, circuitBreaker);
        }
        return circuitBreaker;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public CircuitBreaker findCircuitBreaker(String name) {
        return this.circuitBreakerMap.get(name);
    }

    public Set<String> getCircuitBreakerNames() {
        return this.circuitBreakerMap.keySet();
    }

    protected void configureCircuitBreaker(String name, CircuitBreaker circuit, CircuitBreakerConfig config) {
        long resetMillis = config.getResetMillis();
        Long resetMillisOverride = this.getLongPropertyOverrideValue(name, RESETMILLIS_KEY);
        if (resetMillisOverride != null) {
            resetMillis = resetMillisOverride;
        }
        FailureInterpreter fi = config.getFailureInterpreter();
        circuit.setFailureInterpreter(fi);
        if (resetMillis > 0L) {
            circuit.setResetMillis(resetMillis);
        }
        if (fi instanceof DefaultFailureInterpreter) {
            this.configureDefaultFailureInterpreter(name, resetMillis, circuit);
        } else {
            this.logger.info("Created CircuitBreaker '{}', resetMillis={}", new Object[]{name, resetMillis});
        }
    }

    private void configureDefaultFailureInterpreter(String name, long resetMillis, CircuitBreaker circuit) {
        Long windowMillisOverride;
        DefaultFailureInterpreter fi = (DefaultFailureInterpreter)circuit.getFailureInterpreter();
        Integer limitOverride = this.getIntegerPropertyOverrideValue(name, LIMIT_KEY);
        if (limitOverride != null) {
            fi.setLimit(limitOverride);
        }
        if ((windowMillisOverride = this.getLongPropertyOverrideValue(name, WINDOWMILLIS_KEY)) != null) {
            fi.setWindowMillis(windowMillisOverride);
        }
        this.logger.info("Created CircuitBreaker '{}', limit={}, windowMillis={}, resetMillis={}", new Object[]{name, fi.getLimit(), fi.getWindowMillis(), resetMillis});
    }

    protected void addCircuitBreakerToMap(String name, CircuitBreaker circuitBreaker) {
        this.circuitBreakerMap.put(name, circuitBreaker);
    }

    private String getPropertyName(String name, String key) {
        return "circuit." + name + '.' + key;
    }

    private Integer getIntegerPropertyOverrideValue(String name, String key) {
        String propertyName;
        String propertyOverrideValue;
        if (this.properties != null && (propertyOverrideValue = this.properties.getProperty(propertyName = this.getPropertyName(name, key))) != null) {
            try {
                return Integer.parseInt(propertyOverrideValue);
            }
            catch (NumberFormatException e) {
                this.logger.error("Could not parse property override key={}, value={}", (Object)key, (Object)propertyOverrideValue);
            }
        }
        return null;
    }

    private Long getLongPropertyOverrideValue(String name, String key) {
        String propertyName;
        String propertyOverrideValue;
        if (this.properties != null && (propertyOverrideValue = this.properties.getProperty(propertyName = this.getPropertyName(name, key))) != null) {
            try {
                return Long.parseLong(propertyOverrideValue);
            }
            catch (NumberFormatException e) {
                this.logger.error("Could not parse property override key={}, value={}", (Object)key, (Object)propertyOverrideValue);
            }
        }
        return null;
    }
}

