/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;

public class PDType0Font
extends PDSimpleFont {
    private static final Log LOG = LogFactory.getLog(PDType0Font.class);
    private COSArray descendantFontArray;
    private PDFont descendantFont;
    private COSDictionary descendantFontDictionary;
    private Font awtFont;

    public PDType0Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE0);
    }

    public PDType0Font(COSDictionary fontDictionary) {
        super(fontDictionary);
        this.descendantFontDictionary = (COSDictionary)this.getDescendantFonts().getObject(0);
        if (this.descendantFontDictionary != null) {
            try {
                this.descendantFont = PDFontFactory.createFont(this.descendantFontDictionary);
            }
            catch (IOException exception) {
                LOG.error((Object)"Error while creating the descendant font!");
            }
        }
    }

    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            if (this.descendantFont != null) {
                this.awtFont = ((PDSimpleFont)this.descendantFont).getawtFont();
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                LOG.info((Object)("Using font " + this.awtFont.getName() + " instead of " + this.descendantFont.getFontDescriptor().getFontName()));
                this.setIsFontSubstituted(true);
            }
        }
        return this.awtFont;
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        throw new RuntimeException("Not yet implemented");
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        return this.descendantFont.getFontWidth(c, offset, length);
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        return this.descendantFont.getFontHeight(c, offset, length);
    }

    public float getAverageFontWidth() throws IOException {
        return this.descendantFont.getAverageFontWidth();
    }

    private COSArray getDescendantFonts() {
        if (this.descendantFontArray == null) {
            this.descendantFontArray = (COSArray)this.font.getDictionaryObject(COSName.DESCENDANT_FONTS);
        }
        return this.descendantFontArray;
    }

    public float getFontWidth(int charCode) {
        return this.descendantFont.getFontWidth(charCode);
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        int result;
        String retval = null;
        if (this.hasToUnicode()) {
            retval = super.encode(c, offset, length);
        }
        if (retval == null && (result = this.cmap.lookupCID(c, offset, length)) != -1) {
            retval = this.descendantFont.cmapEncoding(result, 2, true, this.cmap);
        }
        return retval;
    }

    protected PDFont getDescendantFont() {
        return this.descendantFont;
    }
}

