/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.PAMHeaderWriter;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeaderWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NodeList;

abstract class HeaderWriter {
    protected static final Charset UTF8 = Charset.forName("UTF8");
    protected final ImageOutputStream imageOutput;

    protected HeaderWriter(ImageOutputStream imageOutputStream) {
        this.imageOutput = imageOutputStream;
    }

    public static void write(IIOImage iIOImage, ImageWriterSpi imageWriterSpi, ImageOutputStream imageOutputStream) throws IOException {
        if (imageWriterSpi.getFormatNames()[0].equals("pam")) {
            new PAMHeaderWriter(imageOutputStream).writeHeader(iIOImage, imageWriterSpi);
        } else if (imageWriterSpi.getFormatNames()[0].equals("pnm")) {
            new PNMHeaderWriter(imageOutputStream).writeHeader(iIOImage, imageWriterSpi);
        } else {
            throw new AssertionError((Object)("Unsupported provider: " + imageWriterSpi));
        }
    }

    public abstract void writeHeader(IIOImage var1, ImageWriterSpi var2) throws IOException;

    protected final int getWidth(IIOImage iIOImage) {
        return iIOImage.hasRaster() ? iIOImage.getRaster().getWidth() : iIOImage.getRenderedImage().getWidth();
    }

    protected final int getHeight(IIOImage iIOImage) {
        return iIOImage.hasRaster() ? iIOImage.getRaster().getHeight() : iIOImage.getRenderedImage().getHeight();
    }

    protected final int getNumBands(IIOImage iIOImage) {
        return iIOImage.hasRaster() ? iIOImage.getRaster().getNumBands() : iIOImage.getRenderedImage().getSampleModel().getNumBands();
    }

    protected int getMaxVal(IIOImage iIOImage) {
        int n = this.getTransferType(iIOImage);
        if (n == 0) {
            return 255;
        }
        if (n == 1) {
            return 65535;
        }
        throw new IllegalArgumentException("Unsupported data type: " + n);
    }

    protected final int getTransferType(IIOImage iIOImage) {
        return iIOImage.hasRaster() ? iIOImage.getRaster().getTransferType() : iIOImage.getRenderedImage().getSampleModel().getTransferType();
    }

    protected final void writeComments(IIOMetadata iIOMetadata, ImageWriterSpi imageWriterSpi) throws IOException {
        this.imageOutput.write(String.format("# CREATOR: %s %s\n", imageWriterSpi.getVendorName(), imageWriterSpi.getDescription(Locale.getDefault())).getBytes(UTF8));
        if (iIOMetadata != null && iIOMetadata.isStandardMetadataFormatSupported()) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0");
            NodeList nodeList = iIOMetadataNode.getElementsByTagName("TextEntry");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
                this.imageOutput.write(String.format("# %s", iIOMetadataNode2.getAttribute("value")).getBytes(UTF8));
            }
        }
    }
}

