/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pnm;

import com.twelvemonkeys.imageio.plugins.pnm.PAMHeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PFMHeaderParser;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeader;
import com.twelvemonkeys.imageio.plugins.pnm.PNMHeaderParser;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

abstract class HeaderParser {
    protected final ImageInputStream input;

    protected HeaderParser(ImageInputStream imageInputStream) {
        this.input = (ImageInputStream)Validate.notNull((Object)imageInputStream);
    }

    public abstract PNMHeader parse() throws IOException;

    public static PNMHeader parse(ImageInputStream imageInputStream) throws IOException {
        short s = imageInputStream.readShort();
        return HeaderParser.createParser(imageInputStream, s).parse();
    }

    private static HeaderParser createParser(ImageInputStream imageInputStream, short s) throws IOException {
        switch (s) {
            case 20529: 
            case 20530: 
            case 20531: 
            case 20532: 
            case 20533: 
            case 20534: {
                return new PNMHeaderParser(imageInputStream, s);
            }
            case 20535: {
                return new PAMHeaderParser(imageInputStream);
            }
            case 20550: 
            case 20582: {
                return new PFMHeaderParser(imageInputStream, s);
            }
        }
        throw new IIOException("Unexpected type for PBM, PGM or PPM format: " + s);
    }
}

