/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import java.awt.image.IndexColorModel;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class TGAHeader {
    private int colorMapType;
    private int imageType;
    private int colorMapStart;
    private int colorMapSize;
    private int colorMapDepth;
    private int x;
    private int y;
    private int width;
    private int height;
    private int pixelDepth;
    private int attributeBits;
    private int origin;
    private int interleave;
    private String identification;
    private IndexColorModel colorMap;

    TGAHeader() {
    }

    public int getImageType() {
        return this.imageType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelDepth() {
        return this.pixelDepth;
    }

    public int getAttributeBits() {
        return this.attributeBits;
    }

    public int getOrigin() {
        return this.origin;
    }

    public int getInterleave() {
        return this.interleave;
    }

    public String getIdentification() {
        return this.identification;
    }

    public IndexColorModel getColorMap() {
        return this.colorMap;
    }

    public String toString() {
        return "TGAHeader{colorMapType=" + this.colorMapType + ", imageType=" + this.imageType + ", colorMapStart=" + this.colorMapStart + ", colorMapSize=" + this.colorMapSize + ", colorMapDepth=" + this.colorMapDepth + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", pixelDepth=" + this.pixelDepth + ", attributeBits=" + this.attributeBits + ", origin=" + this.origin + ", interleave=" + this.interleave + (this.identification != null ? ", identification='" + this.identification + '\'' : "") + '}';
    }

    public static TGAHeader read(ImageInputStream imageInputStream) throws IOException {
        TGAHeader tGAHeader = new TGAHeader();
        int n = imageInputStream.readUnsignedByte();
        tGAHeader.colorMapType = imageInputStream.readUnsignedByte();
        tGAHeader.imageType = imageInputStream.readUnsignedByte();
        tGAHeader.colorMapStart = imageInputStream.readUnsignedShort();
        tGAHeader.colorMapSize = imageInputStream.readUnsignedShort();
        tGAHeader.colorMapDepth = imageInputStream.readUnsignedByte();
        tGAHeader.x = imageInputStream.readUnsignedShort();
        tGAHeader.y = imageInputStream.readUnsignedShort();
        tGAHeader.width = imageInputStream.readUnsignedShort();
        tGAHeader.height = imageInputStream.readUnsignedShort();
        tGAHeader.pixelDepth = imageInputStream.readUnsignedByte();
        int n2 = imageInputStream.readUnsignedByte();
        tGAHeader.attributeBits = n2 & 0xF;
        tGAHeader.origin = (n2 & 0x30) >> 4;
        tGAHeader.interleave = (n2 & 0xC0) >> 6;
        if (n > 0) {
            byte[] byArray = new byte[n];
            imageInputStream.readFully(byArray);
            tGAHeader.identification = new String(byArray, Charset.forName("US-ASCII"));
        }
        if (tGAHeader.colorMapType == 1) {
            tGAHeader.colorMap = TGAHeader.readColorMap(imageInputStream, tGAHeader);
        }
        return tGAHeader;
    }

    static IndexColorModel readColorMap(DataInput dataInput, TGAHeader tGAHeader) throws IOException {
        boolean bl;
        int n = tGAHeader.colorMapSize;
        int n2 = tGAHeader.colorMapDepth;
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n * n3];
        dataInput.readFully(byArray);
        switch (n2) {
            case 16: {
                byte[] byArray2 = byArray;
                byArray = new byte[n * 3];
                for (int i = 0; i < byArray2.length / 2; ++i) {
                    byte by = byArray2[i * 2];
                    byte by2 = byArray2[i * 2 + 1];
                    byte by3 = (byte)(8 * ((by2 & 0x7C) >> 2));
                    byte by4 = (byte)(8 * ((by2 & 3) << 3 | (by & 0xE0) >> 5));
                    byte by5 = (byte)(8 * (by & 0x1F));
                    byArray[i * 3] = by3;
                    byArray[i * 3 + 1] = by4;
                    byArray[i * 3 + 2] = by5;
                }
                bl = false;
                break;
            }
            case 24: {
                bl = false;
                break;
            }
            case 32: {
                bl = true;
                break;
            }
            default: {
                throw new IIOException("Unsupported color map depth: " + tGAHeader.colorMapDepth);
            }
        }
        return new IndexColorModel(tGAHeader.pixelDepth, n, byArray, tGAHeader.colorMapStart, bl);
    }
}

