/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Address;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressScribe
extends VCardPropertyScribe<Address> {
    public AddressScribe() {
        super(Address.class, "ADR");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected void _prepareParameters(Address property, VCardParameters copy, VCardVersion version, VCard vcard) {
        AddressScribe.handlePrefParam(property, copy, version, vcard);
        if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
            copy.setLabel(null);
        }
    }

    @Override
    protected String _writeText(Address property, VCardVersion version) {
        return AddressScribe.structured(property.getPoBoxes(), property.getExtendedAddresses(), property.getStreetAddresses(), property.getLocalities(), property.getRegions(), property.getPostalCodes(), property.getCountries());
    }

    @Override
    protected Address _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.StructuredIterator it = AddressScribe.structured(value);
        return this.parseStructuredValue(it);
    }

    @Override
    protected void _writeXml(Address property, XCardElement parent) {
        parent.append("pobox", property.getPoBoxes());
        parent.append("ext", property.getExtendedAddresses());
        parent.append("street", property.getStreetAddresses());
        parent.append("locality", property.getLocalities());
        parent.append("region", property.getRegions());
        parent.append("code", property.getPostalCodes());
        parent.append("country", property.getCountries());
    }

    @Override
    protected Address _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        Address property = new Address();
        property.getPoBoxes().addAll(this.sanitizeXml(element, "pobox"));
        property.getExtendedAddresses().addAll(this.sanitizeXml(element, "ext"));
        property.getStreetAddresses().addAll(this.sanitizeXml(element, "street"));
        property.getLocalities().addAll(this.sanitizeXml(element, "locality"));
        property.getRegions().addAll(this.sanitizeXml(element, "region"));
        property.getPostalCodes().addAll(this.sanitizeXml(element, "code"));
        property.getCountries().addAll(this.sanitizeXml(element, "country"));
        return property;
    }

    private List<String> sanitizeXml(XCardElement element, String name) {
        return element.all(name);
    }

    @Override
    protected Address _parseHtml(HCardElement element, List<String> warnings) {
        Address property = new Address();
        property.getPoBoxes().addAll(element.allValues("post-office-box"));
        property.getExtendedAddresses().addAll(element.allValues("extended-address"));
        property.getStreetAddresses().addAll(element.allValues("street-address"));
        property.getLocalities().addAll(element.allValues("locality"));
        property.getRegions().addAll(element.allValues("region"));
        property.getPostalCodes().addAll(element.allValues("postal-code"));
        property.getCountries().addAll(element.allValues("country-name"));
        List<String> types = element.types();
        property.getParameters().putAll("TYPE", types);
        return property;
    }

    @Override
    protected JCardValue _writeJson(Address property) {
        return JCardValue.structured(property.getPoBoxes(), property.getExtendedAddresses(), property.getStreetAddresses(), property.getLocalities(), property.getRegions(), property.getPostalCodes(), property.getCountries());
    }

    @Override
    protected Address _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, List<String> warnings) {
        VCardPropertyScribe.StructuredIterator it = AddressScribe.structured(value);
        return this.parseStructuredValue(it);
    }

    private Address parseStructuredValue(VCardPropertyScribe.StructuredIterator it) {
        Address property = new Address();
        property.getPoBoxes().addAll(it.nextComponent());
        property.getExtendedAddresses().addAll(it.nextComponent());
        property.getStreetAddresses().addAll(it.nextComponent());
        property.getLocalities().addAll(it.nextComponent());
        property.getRegions().addAll(it.nextComponent());
        property.getPostalCodes().addAll(it.nextComponent());
        property.getCountries().addAll(it.nextComponent());
        return property;
    }
}

