/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.sql.Time;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="time", aliases={"java.sql.Types.TIME", "java.sql.Time"}, minParameters=0, maxParameters=0, priority=1)
public class TimeType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof InformixDatabase) {
            return new DatabaseDataType("INTERVAL HOUR TO FRACTION", 5);
        }
        if (database instanceof MSSQLDatabase) {
            try {
                if (database.getDatabaseMajorVersion() <= 9) {
                    return new DatabaseDataType("DATETIME");
                }
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("DATE");
        }
        return new DatabaseDataType(this.getName());
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return database.generateDatabaseFunctionValue((DatabaseFunction)value);
        }
        if (value instanceof Time) {
            return database.getTimeLiteral((Time)value);
        }
        return "'" + ((String)value).replaceAll("'", "''") + "'";
    }

    @Override
    public Object sqlToObject(String value, Database database) {
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"TIME\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^TIME\\('", "").replaceFirst("'\\)", "");
        }
        return super.sqlToObject(value, database);
    }
}

