/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoQueue;
import org.xsocket.connection.IoSSLProcessor;

final class IoSSLHandler
extends IoChainableHandler
implements IoSSLProcessor.EventHandler {
    private static final Logger LOG = Logger.getLogger(IoSSLHandler.class.getName());
    private final IoQueue outAppDataQueue = new IoQueue();
    private final IoQueue outNetDataQueue = new IoQueue();
    private final PendingWriteMap pendingWriteMap = new PendingWriteMap();
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private final IoSSLProcessor sslProcessor;
    private final AtomicBoolean isSSLConnected = new AtomicBoolean(false);
    private final Object initGuard = new Object();
    private final boolean isClientMode;
    private IOException readException;

    IoSSLHandler(IoChainableHandler successor, SSLContext sslContext, boolean isClientMode, AbstractMemoryManager memoryManager) throws IOException {
        super(successor);
        this.isClientMode = isClientMode;
        this.sslProcessor = new IoSSLProcessor(sslContext, isClientMode, memoryManager, this);
    }

    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
        this.startSSL();
    }

    public boolean reset() {
        this.outAppDataQueue.drain();
        this.outNetDataQueue.drain();
        this.pendingWriteMap.clear();
        return super.reset();
    }

    public boolean isSecure() {
        return this.isSSLConnected.get();
    }

    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    public int getPendingWriteDataSize() {
        return this.outAppDataQueue.getSize() + super.getPendingWriteDataSize();
    }

    public boolean hasDataToSend() {
        return !this.outAppDataQueue.isEmpty() || super.hasDataToSend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startSSL() throws IOException {
        if (!this.isSSLConnected.get()) {
            this.sslProcessor.start();
        }
        if (!this.isClientMode) return;
        Object object = this.initGuard;
        synchronized (object) {
            while (!this.isSSLConnected.get()) {
                if (this.readException != null) {
                    IOException ex = this.readException;
                    this.readException = null;
                    throw ex;
                }
                try {
                    if (ConnectionUtils.isDispatcherThread()) {
                        LOG.warning("try to initialize ssl client within xSocket I/O thread (" + Thread.currentThread().getName() + "). This will cause a deadlock");
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] waiting until ssl handeshake has been finished");
                    }
                    this.initGuard.wait();
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("[" + this.getId() + "] ssl handeshake has been finished continue processing");
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHandshakeFinished() throws IOException {
        if (!this.isSSLConnected.get()) {
            if (LOG.isLoggable(Level.FINE) && this.isClientMode) {
                LOG.fine("[" + this.getId() + "] wakeup waiting processes for handeshake");
            }
            this.isSSLConnected.set(true);
            Object object = this.initGuard;
            synchronized (object) {
                this.initGuard.notifyAll();
            }
            this.getPreviousCallback().onConnect();
        }
        boolean isEncryptRequired = false;
        IoQueue ioQueue = this.outAppDataQueue;
        synchronized (ioQueue) {
            if (!this.outAppDataQueue.isEmpty()) {
                this.sslProcessor.addOutAppData(this.outAppDataQueue.drain());
                isEncryptRequired = true;
            }
        }
        if (isEncryptRequired) {
            this.sslProcessor.encrypt();
        }
    }

    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.hardFlush();
        }
        this.getSuccessor().close(immediate);
    }

    public void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.outAppDataQueue.append(buffers);
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        IoQueue ioQueue = this.outAppDataQueue;
        synchronized (ioQueue) {
            if (!this.outAppDataQueue.isEmpty()) {
                ByteBuffer[] dataToEncrypt = this.outAppDataQueue.drain();
                if (LOG.isLoggable(Level.FINE)) {
                    int size = 0;
                    ArrayList<ByteBuffer> dataToEncryptCopy = new ArrayList<ByteBuffer>();
                    for (ByteBuffer buffer : dataToEncrypt) {
                        dataToEncryptCopy.add(buffer.duplicate());
                        size += buffer.remaining();
                    }
                    LOG.fine("encrypting out app data (" + size + "): " + DataConverter.toTextOrHexString(dataToEncryptCopy.toArray(new ByteBuffer[dataToEncryptCopy.size()]), "US-ASCII", 500));
                }
                this.sslProcessor.addOutAppData(dataToEncrypt);
            }
        }
        this.sslProcessor.encrypt();
    }

    public void hardFlush() throws IOException {
        this.flush();
    }

    private void readIncomingEncryptedData(ByteBuffer[] inNetDataList) throws ClosedChannelException, IOException {
        if (LOG.isLoggable(Level.FINE)) {
            int size = 0;
            for (ByteBuffer buffer : inNetDataList) {
                size += buffer.remaining();
            }
            LOG.fine("[" + this.getId() + "] " + size + " encrypted data received");
        }
        if (inNetDataList != null) {
            this.sslProcessor.decrypt(inNetDataList);
        }
    }

    public void onSSLProcessorClosed() throws IOException {
        this.close(true);
    }

    public void onDataDecrypted(ByteBuffer decryptedBuffer) {
        if (decryptedBuffer == null || !decryptedBuffer.hasRemaining()) {
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("in app data decrypted: " + DataConverter.toTextOrHexString(decryptedBuffer.duplicate(), "US-ASCII", 500));
        }
        this.getPreviousCallback().onData(new ByteBuffer[]{decryptedBuffer}, decryptedBuffer.remaining());
    }

    public void onPostDataDecrypted() {
        this.getPreviousCallback().onPostData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataEncrypted(ByteBuffer plainData, ByteBuffer encryptedData) throws IOException {
        if (encryptedData.hasRemaining()) {
            this.pendingWriteMap.add(plainData, encryptedData);
        }
        IoQueue ioQueue = this.outNetDataQueue;
        synchronized (ioQueue) {
            this.outNetDataQueue.append(encryptedData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostDataEncrypted() throws IOException {
        IoQueue ioQueue = this.outNetDataQueue;
        synchronized (ioQueue) {
            ByteBuffer[] data = this.outNetDataQueue.drain();
            if (LOG.isLoggable(Level.FINE) && data != null) {
                int size = 0;
                for (ByteBuffer buffer : data) {
                    size += buffer.remaining();
                }
                LOG.fine("sending out app data (" + size + ")");
            }
            this.getSuccessor().write(data);
        }
        this.getSuccessor().flush();
    }

    static final class PendingWriteMap {
        private Map<ByteBuffer, List<ByteBuffer>> plainEncryptedMapping = new IdentityHashMap<ByteBuffer, List<ByteBuffer>>();
        private Map<ByteBuffer, ByteBuffer> encryptedPlainMapping = new IdentityHashMap<ByteBuffer, ByteBuffer>();

        PendingWriteMap() {
        }

        public synchronized void add(ByteBuffer plain, ByteBuffer encrypted) {
            if (plain.limit() > 0) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                if (encryptedList == null) {
                    encryptedList = new ArrayList<ByteBuffer>();
                    this.plainEncryptedMapping.put(plain, encryptedList);
                }
                encryptedList.add(encrypted);
                this.encryptedPlainMapping.put(encrypted, plain);
            }
        }

        public synchronized ByteBuffer getPlainIfWritten(ByteBuffer encrypted) {
            ByteBuffer plain = this.encryptedPlainMapping.remove(encrypted);
            if (plain != null) {
                List<ByteBuffer> encryptedList = this.plainEncryptedMapping.get(plain);
                encryptedList.remove(encrypted);
                if (encryptedList.isEmpty()) {
                    this.plainEncryptedMapping.remove(plain);
                    return plain;
                }
            }
            return null;
        }

        public synchronized void clear() {
            this.plainEncryptedMapping.clear();
            this.encryptedPlainMapping.clear();
        }
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onData(ByteBuffer[] data, int size) {
            try {
                IoSSLHandler.this.readIncomingEncryptedData(data);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + IoSSLHandler.this.getId() + "] error occured while receiving data. Reason: " + ioe.toString());
                }
                Object object = IoSSLHandler.this.initGuard;
                synchronized (object) {
                    IoSSLHandler.this.readException = ioe;
                    IoSSLHandler.this.initGuard.notifyAll();
                }
            }
        }

        public void onPostData() {
        }

        public void onConnect() {
        }

        public void onConnectException(IOException ioe) {
            IoSSLHandler.this.getPreviousCallback().onConnectException(ioe);
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            IoSSLHandler.this.getPreviousCallback().onWriteException(ioException, data);
        }

        public void onWritten(ByteBuffer data) {
            ByteBuffer plainData = IoSSLHandler.this.pendingWriteMap.getPlainIfWritten(data);
            if (plainData != null) {
                IoSSLHandler.this.getPreviousCallback().onWritten(plainData);
            } else {
                IoSSLHandler.this.getPreviousCallback().onWritten(data);
            }
        }

        public void onDisconnect() {
            IoSSLHandler.this.sslProcessor.destroy();
            IoSSLHandler.this.getPreviousCallback().onDisconnect();
        }

        public void onConnectionAbnormalTerminated() {
            IoSSLHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }
}

