/*
 * Decompiled with CFR 0.152.
 */
package com.planetj.math.rabinhash;

import com.planetj.math.rabinhash.RabinHashFunctionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

public final class RabinHashFunction64
implements Serializable,
Cloneable {
    private static final long DEFAULT_IRREDUCIBLE_POLY = 27L;
    public static final RabinHashFunction64 DEFAULT_HASH_FUNCTION = new RabinHashFunction64(27L);
    private static final int P_DEGREE = 64;
    private static final long X_P_DEGREE = Long.MIN_VALUE;
    private static final int READ_BUFFER_SIZE = 1024;
    private final long P;
    private transient long[] table32;
    private transient long[] table40;
    private transient long[] table48;
    private transient long[] table56;
    private transient long[] table64;
    private transient long[] table72;
    private transient long[] table80;
    private transient long[] table88;

    public RabinHashFunction64(long P) {
        this.P = P;
        this.initializeTables();
    }

    private void initializeTables() {
        int i;
        long[] mods = new long[64];
        mods[0] = this.P;
        for (i = 1; i < 64; ++i) {
            long lastMod = mods[i - 1];
            long thisMod = lastMod << 1;
            if ((lastMod & Long.MIN_VALUE) != 0L) {
                thisMod ^= this.P;
            }
            mods[i] = thisMod;
        }
        this.table32 = new long[256];
        this.table40 = new long[256];
        this.table48 = new long[256];
        this.table56 = new long[256];
        this.table64 = new long[256];
        this.table72 = new long[256];
        this.table80 = new long[256];
        this.table88 = new long[256];
        for (i = 0; i < 256; ++i) {
            int c = i;
            for (int j = 0; j < 8 && c > 0; c >>>= 1, ++j) {
                if ((c & 1) == 0) continue;
                int n = i;
                this.table32[n] = this.table32[n] ^ mods[j];
                int n2 = i;
                this.table40[n2] = this.table40[n2] ^ mods[j + 8];
                int n3 = i;
                this.table48[n3] = this.table48[n3] ^ mods[j + 16];
                int n4 = i;
                this.table56[n4] = this.table56[n4] ^ mods[j + 24];
                int n5 = i;
                this.table64[n5] = this.table64[n5] ^ mods[j + 32];
                int n6 = i;
                this.table72[n6] = this.table72[n6] ^ mods[j + 40];
                int n7 = i;
                this.table80[n7] = this.table80[n7] ^ mods[j + 48];
                int n8 = i;
                this.table88[n8] = this.table88[n8] ^ mods[j + 56];
            }
        }
    }

    public long getP() {
        return this.P;
    }

    private long computeWShifted(long w) {
        return this.table32[(int)(w & 0xFFL)] ^ this.table40[(int)(w >>> 8 & 0xFFL)] ^ this.table48[(int)(w >>> 16 & 0xFFL)] ^ this.table56[(int)(w >>> 24 & 0xFFL)] ^ this.table64[(int)(w >>> 32 & 0xFFL)] ^ this.table72[(int)(w >>> 40 & 0xFFL)] ^ this.table80[(int)(w >>> 48 & 0xFFL)] ^ this.table88[(int)(w >>> 56 & 0xFFL)];
    }

    public long hash(byte[] A) {
        return this.hash(A, 0, A.length, 0L);
    }

    long hash(byte[] A, int offset, int length, long w) {
        int s;
        int max;
        int starterBytes = length % 8;
        if (starterBytes != 0) {
            max = offset + starterBytes;
            for (s = offset; s < max; ++s) {
                w = w << 8 ^ (long)(A[s] & 0xFF);
            }
        }
        max = offset + length;
        while (s < max) {
            w = this.computeWShifted(w) ^ (long)(A[s] << 56) ^ (long)((A[s + 1] & 0xFF) << 48) ^ (long)((A[s + 2] & 0xFF) << 40) ^ (long)((A[s + 3] & 0xFF) << 32) ^ (long)((A[s + 4] & 0xFF) << 24) ^ (long)((A[s + 5] & 0xFF) << 16) ^ (long)((A[s + 6] & 0xFF) << 8) ^ (long)(A[s + 7] & 0xFF);
            s += 8;
        }
        return w;
    }

    public long hash(char[] A) {
        int s;
        long w = 0L;
        int starterChars = A.length % 4;
        for (s = 0; s < starterChars; ++s) {
            w = w << 16 ^ (long)(A[s] & 0xFFFF);
        }
        while (s < A.length) {
            w = this.computeWShifted(w) ^ (long)((A[s] & 0xFFFF) << 48) ^ (long)((A[s + 1] & 0xFFFF) << 32) ^ (long)((A[s + 2] & 0xFFFF) << 16) ^ (long)(A[s + 3] & 0xFFFF);
            s += 4;
        }
        return w;
    }

    public long hash(long[] A) {
        long w = 0L;
        for (int s = 0; s < A.length; ++s) {
            w = this.computeWShifted(w) ^ A[s];
        }
        return w;
    }

    public long hash(ByteBuffer A) {
        return this.hash(A.asLongBuffer());
    }

    public long hash(LongBuffer A) {
        long w = 0L;
        while (A.hasRemaining()) {
            w = this.computeWShifted(w) ^ A.get();
        }
        return w;
    }

    public long hash(Serializable obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.hash(baos.toByteArray());
    }

    public long hash(String s) {
        return this.hash(s.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long hash(File f) throws FileNotFoundException, IOException {
        if (f == null) {
            throw new NullPointerException();
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            long l = this.hash(fis);
            return l;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long hash(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            long l = this.hash(is);
            return l;
        }
        finally {
            is.close();
        }
    }

    public long hash(InputStream is) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        long w = 0L;
        while ((bytesRead = is.read(buffer)) > 0) {
            w = this.hash(buffer, 0, bytesRead, w);
        }
        return w;
    }

    public boolean equals(Object o) {
        return o instanceof RabinHashFunction64 && ((RabinHashFunction64)o).P == this.P;
    }

    public int hashCode() {
        return (int)this.P ^ (int)(this.P >> 32);
    }

    public String toString() {
        return "RabinHashFunction64[P: " + RabinHashFunctionUtils.polynomialToString(this.P) + "]";
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializeTables();
    }
}

