/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.osgi;

import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.config.ConfigurationService;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.html.HtmlService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.ServiceLookup;
import com.openexchange.templating.OXTemplateImpl;
import com.openexchange.templating.TemplateHelperFactory;
import com.openexchange.templating.TemplateService;
import com.openexchange.templating.converter.TemplatedResultConverter;
import com.openexchange.templating.impl.OXIntegration;
import com.openexchange.templating.impl.TemplateServiceImpl;
import com.openexchange.tools.strings.StringParser;
import freemarker.log.OXFreemarkerLoggerFactory;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatingActivator
extends HousekeepingActivator {
    private static final Logger LOG = LoggerFactory.getLogger(TemplatingActivator.class);

    public void startBundle() throws Exception {
        boolean hasProperty;
        Field extendedProviderField = freemarker.log.Logger.class.getDeclaredField("factory");
        extendedProviderField.setAccessible(true);
        extendedProviderField.set(null, new OXFreemarkerLoggerFactory());
        ConfigurationService config = (ConfigurationService)this.getService(ConfigurationService.class);
        OXIntegration integration = new OXIntegration((InfostoreFacade)this.getService(InfostoreFacade.class));
        TemplateServiceImpl templates = new TemplateServiceImpl(config);
        templates.setOXFolderHelper(integration);
        templates.setInfostoreHelper(integration);
        this.registerService(TemplateService.class, templates);
        OXTemplateImpl.services = this;
        boolean bl = hasProperty = config.getProperty("com.openexchange.templating.path") != null;
        if (!hasProperty) {
            IllegalStateException exception = new IllegalStateException("Missing Property com.openexchange.templating.path");
            exception.fillInStackTrace();
            LOG.error("com.openexchange.templating.path is not set. Templating will remain inactive.", (Throwable)exception);
        }
        TemplatedResultConverter converter = new TemplatedResultConverter((ServiceLookup)this, templates);
        this.registerService(ResultConverter.class, converter);
        this.track(TemplateHelperFactory.class, converter);
        this.openTrackers();
    }

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class, InfostoreFacade.class, StringParser.class, HtmlService.class};
    }
}

